
### Implementations of several useful functions.
### (also some plotting procedures)

from   pylab  import *
from   loader import gload, load, save, gsave, fload
import numpy.linalg as la
import gnumpy as gpu
import numpy  as np

gray()

def LOG(x):
    return log(x+1e-300)

def show_mat(x,vmin=None,vmax=None):
    hold(False)
    imshow(x,interpolation='nearest',vmin=vmin,vmax=vmax)
    p = raw_input ('Plot!')

def show_2(V,vmin=None,vmax=None):
    if V.ndim==1:
        res = int(sqrt(shape(V)[0]))
        if abs(res**2 - shape(V)[0])>0.00001: #i.e., if its not an integer
            print "check the dimensionality of the vector, not a square"
        show_mat(V.reshape(res, res),vmin,vmax)
    if V.ndim==2:
        show_mat(V,vmin,vmax)
    if V.ndim==3:
        imshow(V,interpolation='nearest',vmin=vmin, vmax=vmax)
    if V.ndim>3:
        print "don't know how to print such a vector!"

def show_seq(V,vmin=None,vmax=None):
    T   = len(V)
    res = int(sqrt(shape(V)[1]))
    for t in range(T):
        print t
        show(V[t],vmin,vmax)

def unsigmoid(x): return log (x) - log (1-x)

def print_aligned(w):
    n1 = int(ceil(sqrt(shape(w)[1])))
    n2 = n1
    r1 = int(sqrt(shape(w)[0]))
    r2 = r1
    Z = zeros(((r1+1)*n1, (r1+1)*n2), 'd')
    i1, i2 = 0, 0
    for i1 in range(n1):
        for i2 in range(n2):
            i = i1*n2+i2
            if i>=shape(w)[1]: break
            Z[(r1+1)*i1:(r1+1)*(i1+1)-1, (r2+1)*i2:(r2+1)*(i2+1)-1] = w[:,i].reshape(r1,r2)
    return Z

def aux(a):
    (s1, s2)=shape(a)
    mu=.5*ones((s1,1),'d')
    return concatenate((a,mu),1)
def aux2(a):
    (s1, s2)=shape(a)
    mu=.5*ones((1,s2),'d')
    return concatenate((a,mu),0)

def print_seq(x): # x is assumed to be a sequence.
    (T, s0)=shape(x)
    s1 = int(sqrt(s0))
    assert(s1**2 == s0)
    Z=aux2(concatenate([aux(f) for f in x.reshape(T,s1,s1)],1))
    return Z

def stochastic(x): return gpu.garray(gpu.rand(*shape(x)) < x)
def Rsigmoid(x):   return stochastic(x.logistic())
def stochastic_no_GPU(x): return array(rand(*shape(x)) < x, 'd')
def Rsigmoid_no_GPU(x): return stochastic_no_GPU(sigmoid(x))
def sigmoid(x):    return 1./(1. + exp(-x))

def Dsigmoid(x):
    s = sigmoid(x)
    return s*(1-s)





def show_letter_activations_histogram(letter, values):
    h = len(values)
    fig = figure()
    ax = fig.add_subplot(1,1,1)
    x = arange(h)
    only_high = zeros(h)
    only_high_labels = []
    for i in range(len(values)):
        if values[i] > 0.5:
            only_high[i] = values[i]
            only_high_labels.append(str(i))
        else:
            only_high_labels.append(' ')
    ax.bar(x, values, color = 'blue', edgecolor = 'blue', align = 'center')
    ax.bar(x, only_high, color = 'red', edgecolor = 'red', align = 'center')
    label = 'Hidden units activations for ' + letter
    ax.set_title(label)
    ax.set_ylabel('Activation')
    ax.set_xticks(x)
    ax.set_xticklabels(only_high_labels)
    for tick in ax.xaxis.get_major_ticks():
        tick.label.set_fontsize(10) 
    fig.autofmt_xdate()
    show()



def show_activations_histograms(label_1, values_1, label_2, values_2):
    h = len(values_1)
    fig = figure()
    
    ax = fig.add_subplot(2,1,1)
    x = arange(h)
    only_high = zeros(h)
    only_high_labels = []
    for i in range(h):
        if values_1[i] > 0.5:
            only_high[i] = values_1[i]
            only_high_labels.append(str(i))
        else:
            only_high_labels.append(' ')
    ax.bar(x, values_1, color = 'blue', edgecolor = 'blue', align = 'center')
    ax.bar(x, only_high, color = 'red', edgecolor = 'red', align = 'center')
    ax.set_title(label_1)
    ax.set_ylabel('Activation')
    ax.set_xticks(x)
    ax.set_xticklabels(only_high_labels)
    for tick in ax.xaxis.get_major_ticks():
        tick.label.set_fontsize(10)

    ax = fig.add_subplot(2,1,2)
    x = arange(h)
    only_high = zeros(h)
    only_high_labels = []
    for i in range(h):
        if values_2[i] > 0.5:
            only_high[i] = values_2[i]
            only_high_labels.append(str(i))
        else:
            only_high_labels.append(' ')
    ax.bar(x, values_2, color = 'blue', edgecolor = 'blue', align = 'center')
    ax.bar(x, only_high, color = 'red', edgecolor = 'red', align = 'center')
    ax.set_title(label_2)
    ax.set_ylabel('Activation')
    ax.set_xticks(x)
    ax.set_xticklabels(only_high_labels)
    for tick in ax.xaxis.get_major_ticks():
        tick.label.set_fontsize(10)
    
    fig.autofmt_xdate()
    show()

def show_activations_matrices(label_1, values_1, label_2, values_2):
    fig = figure()

    alphabet = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
    pos = np.arange(11)
    
    ax_1 = fig.add_subplot(2,1,1)
    ax_1.imshow(values_1, cmap = matplotlib.cm.jet, interpolation = 'nearest')
    ax_1.set_title(label_1)
    yticks(pos, alphabet)
    for tick in ax_1.yaxis.get_major_ticks():
        tick.label1.set_fontsize(10)
    
    ax_2 = fig.add_subplot(2,1,2)
    cax = ax_2.imshow(values_2, cmap = matplotlib.cm.jet, interpolation = 'nearest')
    ax_2.set_title(label_2)
    yticks(pos, alphabet)
    for tick in ax_2.yaxis.get_major_ticks():
        tick.label1.set_fontsize(10)
    
    show()

def show_complete_activations_matrix(values, label):
    
    #data_1 = values[:, 0:200]
    #data_2 = values[:, 200:400]
    #alphabet = ['$', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
    alphabet = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
    #pos = np.arange(28)
    pos = np.arange(11)
    fig = figure(figsize = (20, 12))
    fig.suptitle(label, fontsize = 18)
    
    #ax_1 = fig.add_subplot(2,1,1)
    ax_1 = fig.add_subplot(1,1,1)
    cax = ax_1.imshow(values, cmap = matplotlib.cm.jet, interpolation = 'nearest', aspect=3)
    #ax_1.set_title('Hidden units activations (0..200)')
    ax_1.set_title('Hidden units activations')
    yticks(pos, alphabet)
    for tick in ax_1.yaxis.get_major_ticks():
        tick.label1.set_fontsize(10)
    
    #ax_2 = fig.add_subplot(2,1,2)
    #cax = ax_2.imshow(data_2, cmap = matplotlib.cm.jet, interpolation = 'nearest', aspect=3)
    #ax_2.set_title('Hidden units activations (200..400)')
    #yticks(pos, alphabet)
    #for tick in ax_2.yaxis.get_major_ticks():
    #    tick.label1.set_fontsize(10)
    
    # Add colorbar, make sure to specify tick locations to match desired ticklabels
    cbar = fig.colorbar(cax, ticks = [0, 0.5, 0.99], orientation = 'horizontal')
    cbar.ax.set_xticklabels(['Low', 'Medium', 'High'])
    
    show()

def show_reduced_activations_matrix(values, label):
    #alphabet = ['$', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z']
    alphabet = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']
    #pos = np.arange(28)
    pos = np.arange(11)
    fig = figure()
    fig.suptitle(label, fontsize = 18)
    
    ax_1 = fig.add_subplot(2,1,1)
    cax = ax_1.imshow(values, cmap = matplotlib.cm.jet, interpolation = 'nearest', aspect=3)
    ax_1.set_title('most relevant hidden units activations')
    yticks(pos, alphabet)
    for tick in ax_1.yaxis.get_major_ticks():
        tick.label1.set_fontsize(10)
    
    # Add colorbar, make sure to specify tick locations to match desired ticklabels
    cbar = fig.colorbar(cax, ticks = [0, 0.5, 0.99], orientation = 'horizontal')
    cbar.ax.set_xticklabels(['Low', 'Medium', 'High'])
    show()


def linear_regression(values, labels, slope_threshold, intercept_threshold):
    from scipy import linspace, polyval, polyfit, sqrt, stats, randn
    from pylab import plot, title, show , legend

    s, l, h = values.shape
    response_list = {}
    for n in range(h):
        response_list[n] = []
    subplots_adjust(wspace = 3)
    
    for sample in range(s):
        
        subplot(3, 1, 1)
        length = len(labels[sample]) + 1
        t = np.arange(0, length)
        
        title('Linear Regression on ' + labels[sample])
        xlabel('position', x = 0.99, ha = 'right')
        ylabel('activation')
        grid(True)
        for n in range(h):
            xn = values[sample, 0:length, n]
            r = rand()
            g = rand()
            b = rand()
            rgb = tuple((r, g, b))
            
            #Linear regression - polyfit can be used other orders polys
            (ar, br) = polyfit(t, xn, 1)
            xr = polyval([ar, br], t)
            #compute the mean square error
            err = sqrt(sum((xr - xn)**2) / length)
            if (ar > slope_threshold) or ((br > intercept_threshold) and (ar > 0.01)):
                if (n ==  396): #70) or (n == 150) or (n == 214) or (n == 225) or (n == 390) or (n ==
                    rgb = tuple((0, 0, 0))
                    m = 'None'
                    #print '**Neuron', n, ':',
                else:
                    m = 'o'
                    #print 'Neuron', n, ':',
                    #plot(t, xn, color = rgb, marker = m)
                    response_list[n].append(labels[sample])
                #print('\ta=%.2f\tb=%.2f\tms_error= %.3f' % (ar, br, err))
                #plot(t, xr, color = rgb, ls = '--')
        #print sample
        xlim( (0, 7) )
        ylim( (0, 1.2) )
    show()
    return response_list


def compute_similarity(activations):
    
    n = len(activations)
    h = len(activations[0][1])

    matrix = np.zeros((n, n))
    for i in range(n):
        for j in range(n):
            ## cosine similarity:
            #matrix[i, j] = np.inner(activations[i][1], activations[j][1]) / (la.norm(activations[i][1]) * la.norm(activations[j][1]))
            matrix[i, j] = sqrt((((activations[i][1] - activations[j][1])**2).sum()) / h)
    return matrix


def plot_similarity_matrix(m, words):
    r, c = m.shape
    assert(r == c)
    n = np.arange(r)
    fig = figure()
    fig.suptitle('Hidden representations similarity matrix', fontsize = 18)
    
    ax_1 = fig.add_subplot(1,1,1)
    cax = ax_1.imshow(m, cmap = matplotlib.cm.jet, interpolation = 'nearest')
    yticks(n, words)
    xticks(n, words, rotation = 'vertical')

    for tick in ax_1.xaxis.get_major_ticks():
        tick.label1.set_fontsize(6)
    for tick in ax_1.yaxis.get_major_ticks():
        tick.label1.set_fontsize(6)
    
    # Add colorbar, make sure to specify tick locations to match desired ticklabels
    #cbar = fig.colorbar(cax, ticks = [0, 0.5, 1], orientation = 'horizontal')
    #cbar.ax.set_xticklabels(['Low', 'Medium', 'High'])
    
    show()

def compute_activations_similarity(r1, r2, metric):
    from scipy.spatial.distance import mahalanobis
    import numpy.linalg as la
    h = len(r1)
    if len(r2) != h:
        raise Exception('Different representation sizes in similarity calculation.')
    if metric == 'L2':
        d = sqrt((((r1 - r2)**2).sum()) / h)
    elif metric == 'cosine':
        d = np.inner(r1, r2) / (la.norm(r1) * la.norm(r2))
    elif metric == 'maha':
        CC = np.column_stack((r1, r2))
        C = np.cov(CC)
        try:
            VI = la.pinv(C)
            d = mahalanobis(target, norm_pred, VI)
            if not(np.isnan(d)):
                return d
            else:
                #print '\nNan!\n'
                return 0
        except:
            #print '\nException!\n'
            return 100
    else:
        raise Exception('Unknown metric type.')
    return d

def compute_activations_maxdiff(r1, r2):
    h = len(r1)
    max_diff = 0
    index = -1
    for n in range(0, h):
        if np.abs(r1[n] - r2[n]) > max_diff:
            max_diff = np.abs(r1[n] - r2[n])
            index = n
    return max_diff, index

def compute_Levenshtein_distance(a, b):
    "Calculates the Levenshtein distance between a and b."
    
    n, m = len(a), len(b)
    if n > m:
        # Make sure n <= m, to use O(min(n,m)) space
        a,b = b,a
        n,m = m,n
    current = range(n+1)
    for i in range(1,m+1):
        previous, current = current, [i]+[0]*n
        for j in range(1,n+1):
            add, delete = previous[j]+1, current[j-1]+1
            change = previous[j-1]
            if a[j-1] != b[i-1]:
                change = change + 1
            current[j] = min(add, delete, change)
            
    return current[n]


def monomial(n, shape=(1,)): return array(floor(rand(*shape)*n),'i')
multinomial = monomial
def id(x): return x


def true_multinomial(p):
    return (p.cumsum(1)<rand(len(p),1)).sum(1)

from pylab import amap
def softmax_slow(a):
    def softmax_1(a):
        e=exp(a-a.max())
        return e/e.sum()
    return amap(softmax_1,a)

def softmax(a):
    a=a-a.max(1).reshape(-1,1)
    b=exp(a)
    c=b.sum(1)
    if isnan(a).any():
        import pdb
        pdb.set_trace()
    ans = b/c.reshape(-1,1)
    if isnan(ans).any():
        import pdb
        pdb.set_trace()
    return ans
    
def generic_softmax_deriv(dE_dY, y):
    """        shape(dE_dY)=[n,k]
     input: shape(x)=[n,k]
            shape(y)=[n,k]
     note: the total input, x, isn't used.
    """

    # for a given n, the output is diag(y)-y*y'
    Y0 = dE_dY * y 
    return Y0 - y*Y0.sum(1).reshape(-1,1)
    
### these guys are so standard... they deserve better! 
def to_list_lens(vec, lens):
    assert(len(vec)==sum(lens))
    ans = [None]*len(lens)
    a = 0
    for i in range(len(lens)):
        b = a + lens[i]
        ans[i]=vec[a:b]
        a = b
    return ans
def from_list_lens(v_l, l):
    # we need to concatenate vectors.
    assert([len(z) for z in v_l]==l)
    return concatenate(v_l)

def expand(labels, n_labels):
    a=zeros((len(labels), n_labels))
    for i in range(len(labels)):
        a[i,labels[i]]=1
    return a

def e_true_multinomial(p):
    return expand(true_multinomial(p), shape(p)[1])

def ieye(n,i):
    z= zeros(n)
    z[i]=1
    return z
