/*
 * Decompiled with CFR 0.152.
 */
package sound;

import graphics.Game;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import sound.Sound;
import sound.ThreadPool;

public class SoundManager
extends ThreadPool {
    private Game game;
    private AudioFormat playbackFormat;
    private ThreadLocal localLine;
    private ThreadLocal localBuffer;
    private Object pausedLock;
    private Object stopSoundsLock;
    private int numSndsCurrPlaying = 0;
    private boolean paused;
    private boolean stoppingSounds = false;
    private Map soundMap;
    private Map soundID;
    private Sound[] commonSounds;
    private static final String[] COMMON_SOUND_LIST = new String[]{"chestOpen"};
    private static final int NUM_COMMON_SOUNDS = 1;
    private ArrayList playersList = new ArrayList();

    public SoundManager(AudioFormat playbackFormat, Game game) {
        this(playbackFormat, 10, game);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundManager(AudioFormat playbackFormat, int maxSimultaneousSounds, Game game) {
        super(Math.min(maxSimultaneousSounds, SoundManager.getMaxSimultaneousSounds(playbackFormat)));
        this.game = game;
        this.playbackFormat = playbackFormat;
        this.localLine = new ThreadLocal();
        this.localBuffer = new ThreadLocal();
        this.pausedLock = new Object();
        this.stopSoundsLock = new Object();
        SoundManager soundManager = this;
        synchronized (soundManager) {
            this.notifyAll();
        }
        this.commonSounds = new Sound[1];
        this.initializeSoundMap();
        this.initializeGameSounds(COMMON_SOUND_LIST);
    }

    public static int getMaxSimultaneousSounds(AudioFormat playbackFormat) {
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, playbackFormat);
        Mixer mixer = AudioSystem.getMixer(null);
        int maxLines = mixer.getMaxLines(lineInfo);
        if (maxLines == -1) {
            maxLines = 32;
        }
        return maxLines;
    }

    protected void cleanUp() {
        this.setPaused(false);
        Mixer mixer = AudioSystem.getMixer(null);
        if (mixer.isOpen()) {
            mixer.close();
        }
    }

    @Override
    public void close() {
        this.cleanUp();
        super.close();
    }

    @Override
    public void join() {
        this.cleanUp();
        super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            Object object = this.pausedLock;
            synchronized (object) {
                this.paused = paused;
                if (!paused) {
                    this.pausedLock.notifyAll();
                }
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAllSounds() {
        Object object = this.stopSoundsLock;
        synchronized (object) {
            this.stoppingSounds = true;
            ArrayList players = new ArrayList(this.playersList);
            for (SoundPlayer player : players) {
                player.setToBeStopped(true);
            }
        }
        this.stoppingSounds = false;
        return true;
    }

    public Sound getSound(String filename) {
        return this.getSound(this.getAudioInputStream(filename));
    }

    public Sound getSound(InputStream is) {
        return this.getSound(this.getAudioInputStream(is));
    }

    public Sound getSound(AudioInputStream audioStream) {
        if (audioStream == null) {
            return null;
        }
        int length = (int)(audioStream.getFrameLength() * (long)audioStream.getFormat().getFrameSize());
        byte[] samples = new byte[length];
        DataInputStream is = new DataInputStream(audioStream);
        try {
            is.readFully(samples);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new Sound(samples);
    }

    public AudioInputStream getAudioInputStream(String filename) {
        try {
            return this.getAudioInputStream(this.getClass().getResource("/" + filename).openStream());
        }
        catch (IOException ex) {
            System.err.println("filename=" + filename);
            ex.printStackTrace();
            return null;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream is) {
        try {
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            AudioInputStream source = AudioSystem.getAudioInputStream(is);
            return AudioSystem.getAudioInputStream(this.playbackFormat, source);
        }
        catch (UnsupportedAudioFileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void play(String soundKey) {
        if (this.soundID.get(soundKey) != null) {
            Integer tmpSoundID = new Integer(String.valueOf(this.soundID.get(soundKey)));
            this.play(this.commonSounds[tmpSoundID]);
        } else {
            AudioInputStream streamingSound = this.getAudioInputStream(String.valueOf(this.soundMap.get(soundKey)));
            this.play(streamingSound, false);
        }
    }

    public void play(String soundKey, boolean loop) {
        if (this.soundID.get(soundKey) != null) {
            Integer tmpSoundID = new Integer(String.valueOf(this.soundID.get(soundKey)));
            this.play(this.commonSounds[tmpSoundID], loop);
        } else {
            AudioInputStream streamingSound = this.getAudioInputStream(String.valueOf(this.soundMap.get(soundKey)));
            this.play(streamingSound, loop);
        }
    }

    public InputStream play(Sound sound) {
        return this.play(sound, false);
    }

    public InputStream play(Sound sound, boolean loop) {
        if (sound != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(sound.getSamples());
            return this.play(is, loop);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream play(InputStream is, boolean loop) {
        if (is != null) {
            Object object = this.stopSoundsLock;
            synchronized (object) {
                ++this.numSndsCurrPlaying;
                SoundPlayer sp = new SoundPlayer(is, loop);
                this.playersList.add(sp);
                this.runTask(sp);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void threadStarted() {
        SourceDataLine line;
        SoundManager soundManager = this;
        synchronized (soundManager) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int bufferSize = this.playbackFormat.getFrameSize() * Math.round(this.playbackFormat.getSampleRate() / 10.0f);
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.playbackFormat);
        try {
            line = (SourceDataLine)AudioSystem.getLine(lineInfo);
            line.open(this.playbackFormat, bufferSize);
        }
        catch (LineUnavailableException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        line.start();
        byte[] buffer = new byte[bufferSize];
        this.localLine.set(line);
        this.localBuffer.set(buffer);
    }

    @Override
    protected void threadStopped() {
        SourceDataLine line = (SourceDataLine)this.localLine.get();
        if (line != null) {
            line.drain();
            line.close();
        }
    }

    private void initializeGameSounds(String[] soundKeys) {
        this.soundID = new HashMap();
        int i = 0;
        while (i < 1) {
            this.soundID.put(soundKeys[i], new Integer(i));
            this.commonSounds[i] = this.getSound(String.valueOf(this.soundMap.get(soundKeys[i])));
            ++i;
        }
    }

    private void initializeSoundMap() {
        this.soundMap = new HashMap();
        this.soundMap.put("friend1_youChose", "resources/sounds/Characters/Friend1/Dialog/tuaschoisi.wav");
        this.soundMap.put("friend1_youHaveMore", "resources/sounds/Characters/Friend1/Dialog/tuenplus.wav");
        this.soundMap.put("friend1_youHaveLess", "resources/sounds/Characters/Friend1/Dialog/tuenmoins.wav");
        this.soundMap.put("friend1_andYouGet", "resources/sounds/Characters/Friend1/Dialog/ettoituprends.wav");
        this.soundMap.put("friend1_landedOnTrap", "resources/sounds/Characters/Friend1/Dialog/tombesurpiege.wav");
        this.soundMap.put("friend1_plus", "resources/sounds/Characters/Friend1/Numbers/plus.wav");
        this.soundMap.put("friend1_minus", "resources/sounds/Characters/Friend1/Numbers/moins.wav");
        this.soundMap.put("friend1_equals", "resources/sounds/Characters/Friend1/Numbers/egale.wav");
        this.soundMap.put("friend1_one", "resources/sounds/Characters/Friend1/Numbers/un.wav");
        this.soundMap.put("friend1_two", "resources/sounds/Characters/Friend1/Numbers/deux.wav");
        this.soundMap.put("friend1_three", "resources/sounds/Characters/Friend1/Numbers/trois.wav");
        this.soundMap.put("friend1_four", "resources/sounds/Characters/Friend1/Numbers/quatre.wav");
        this.soundMap.put("friend1_five", "resources/sounds/Characters/Friend1/Numbers/cinq.wav");
        this.soundMap.put("friend1_six", "resources/sounds/Characters/Friend1/Numbers/six.wav");
        this.soundMap.put("friend1_seven", "resources/sounds/Characters/Friend1/Numbers/sept.wav");
        this.soundMap.put("friend1_eight", "resources/sounds/Characters/Friend1/Numbers/huit.wav");
        this.soundMap.put("friend1_nine", "resources/sounds/Characters/Friend1/Numbers/neuf.wav");
        this.soundMap.put("friend1_ten", "resources/sounds/Characters/Friend1/Numbers/dix.wav");
        this.soundMap.put("friend1_zero", "resources/sounds/Characters/Friend1/Numbers/zero.wav");
        this.soundMap.put("friend1_counting_one", "resources/sounds/Characters/Friend1/Numbers/comptage_un.wav");
        this.soundMap.put("friend1_counting_two", "resources/sounds/Characters/Friend1/Numbers/comptage_deux.wav");
        this.soundMap.put("friend1_counting_three", "resources/sounds/Characters/Friend1/Numbers/comptage_trois.wav");
        this.soundMap.put("friend1_counting_four", "resources/sounds/Characters/Friend1/Numbers/comptage_quatre.wav");
        this.soundMap.put("friend1_counting_five", "resources/sounds/Characters/Friend1/Numbers/comptage_cinq.wav");
        this.soundMap.put("friend1_counting_six", "resources/sounds/Characters/Friend1/Numbers/comptage_six.wav");
        this.soundMap.put("friend1_counting_seven", "resources/sounds/Characters/Friend1/Numbers/comptage_sept.wav");
        this.soundMap.put("friend1_counting_eight", "resources/sounds/Characters/Friend1/Numbers/comptage_huit.wav");
        this.soundMap.put("dolphinClick", "resources/sounds/Characters/Friend1/Noises/dolphinClick.wav");
        this.soundMap.put("dolphinSqueak", "resources/sounds/Characters/Friend1/Noises/dolphinSqueak.wav");
        this.soundMap.put("whale1Bubble", "resources/sounds/Characters/Friend1/Noises/whale1Bubble.wav");
        this.soundMap.put("whale2Bubble", "resources/sounds/Characters/Friend1/Noises/whale2Bubble.wav");
        this.soundMap.put("whale3Bubble", "resources/sounds/Characters/Friend1/Noises/whale3Bubble.wav");
        this.soundMap.put("orcaSplash", "resources/sounds/Characters/Friend1/Noises/orcaSplash.wav");
        this.soundMap.put("enemy1_wellSee", "resources/sounds/Characters/Enemy1/Dialog/onvavoir.wav");
        this.soundMap.put("enemy1_andITake", "resources/sounds/Characters/Enemy1/Dialog/etmoijeprends.wav");
        this.soundMap.put("enemy1_iTake", "resources/sounds/Characters/Enemy1/Dialog/jeprends.wav");
        this.soundMap.put("enemy1_iWentTheFurtherest", "resources/sounds/Characters/Enemy1/Dialog/cestmoiquiaiavanceleplus.wav");
        this.soundMap.put("enemy1_youWentTheFurtherest", "resources/sounds/Characters/Enemy1/Dialog/tuesalleleplusloin.wav");
        this.soundMap.put("enemy1_moveMeForward", "resources/sounds/Characters/Enemy1/Dialog/etmaintenantfaismoiavancer.wav");
        this.soundMap.put("enemy1_youSentMeBack", "resources/sounds/Characters/Enemy1/Dialog/tumefaisreculer.wav");
        this.soundMap.put("enemy1_youHaveToGoBack", "resources/sounds/Characters/Enemy1/Dialog/hahatudoisreculer.wav");
        this.soundMap.put("enemy1_iHaveTheMost", "resources/sounds/Characters/Enemy1/Dialog/cestmoiquiaileplus.wav");
        this.soundMap.put("enemy1_iHaveTheLeast", "resources/sounds/Characters/Enemy1/Dialog/cestmoiquiailemoins.wav");
        this.soundMap.put("enemy1_landedOnTrap", "resources/sounds/Characters/Enemy1/Dialog/horreurpiege.wav");
        this.soundMap.put("enemy1_iTookTheMost", "resources/sounds/Characters/Enemy1/Dialog/hahajaipris.wav");
        this.soundMap.put("enemy1_youreCatchingUp", "resources/sounds/Characters/Enemy1/Dialog/ohlalatumerattrapes.wav");
        this.soundMap.put("enemy1_imStillAhead", "resources/sounds/Characters/Enemy1/Dialog/bonjesuistoujours.wav");
        this.soundMap.put("enemy1_imAhead", "resources/sounds/Characters/Enemy1/Dialog/jesuisentete.wav");
        this.soundMap.put("enemy1_tryToCatchMe", "resources/sounds/Characters/Enemy1/Dialog/essayerattraper.wav");
        this.soundMap.put("enemy1_iveOvertakenYou", "resources/sounds/Characters/Enemy1/Dialog/hahajeprendsavance.wav");
        this.soundMap.put("enemy1_youveOvertakenMe", "resources/sounds/Characters/Enemy1/Dialog/ohlatuprendsavance.wav");
        this.soundMap.put("enemy1_youreStillAhead", "resources/sounds/Characters/Enemy1/Dialog/zuttuestoujours.wav");
        this.soundMap.put("enemy1_imCatchingUp", "resources/sounds/Characters/Enemy1/Dialog/hahajeterattrape.wav");
        this.soundMap.put("enemy1_justBehind", "resources/sounds/Characters/Enemy1/Dialog/justederriere.wav");
        this.soundMap.put("enemy1_gettingBehind", "resources/sounds/Characters/Enemy1/Dialog/prendreretard.wav");
        this.soundMap.put("enemy1_imMilesBehind", "resources/sounds/Characters/Enemy1/Dialog/loinderriere.wav");
        this.soundMap.put("enemy1_crab2Click", "resources/sounds/Characters/Enemy1/Noises/crab2Click.wav");
        this.soundMap.put("crab3Click", "resources/sounds/Characters/Enemy1/Noises/crab3Click.wav");
        this.soundMap.put("puffFish", "resources/sounds/Characters/Enemy1/Noises/puffFish.wav");
        this.soundMap.put("squidSquirt", "resources/sounds/Characters/Enemy1/Noises/squidSquirt.wav");
        this.soundMap.put("enemy1_plus", "resources/sounds/Characters/Enemy1/Numbers/plus.wav");
        this.soundMap.put("enemy1_minus", "resources/sounds/Characters/Enemy1/Numbers/moins.wav");
        this.soundMap.put("enemy1_equals", "resources/sounds/Characters/Enemy1/Numbers/egale.wav");
        this.soundMap.put("enemy1_one", "resources/sounds/Characters/Enemy1/Numbers/un_ennemi.wav");
        this.soundMap.put("enemy1_two", "resources/sounds/Characters/Enemy1/Numbers/deux_ennemi.wav");
        this.soundMap.put("enemy1_three", "resources/sounds/Characters/Enemy1/Numbers/trois_ennemi.wav");
        this.soundMap.put("enemy1_four", "resources/sounds/Characters/Enemy1/Numbers/quatre_ennemi.wav");
        this.soundMap.put("enemy1_five", "resources/sounds/Characters/Enemy1/Numbers/cinq_ennemi.wav");
        this.soundMap.put("enemy1_six", "resources/sounds/Characters/Enemy1/Numbers/six_ennemi.wav");
        this.soundMap.put("enemy1_seven", "resources/sounds/Characters/Enemy1/Numbers/sept_ennemi.wav");
        this.soundMap.put("enemy1_eight", "resources/sounds/Characters/Enemy1/Numbers/huit_ennemi.wav");
        this.soundMap.put("enemy1_nine", "resources/sounds/Characters/Enemy1/Numbers/neuf_ennemi.wav");
        this.soundMap.put("enemy1_ten", "resources/sounds/Characters/Enemy1/Numbers/dix_ennemi.wav");
        this.soundMap.put("enemy1_zero", "resources/sounds/Characters/Enemy1/Numbers/zero_ennemi.wav");
        this.soundMap.put("enemy1_counting_one", "resources/sounds/Characters/Enemy1/Numbers/un_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_two", "resources/sounds/Characters/Enemy1/Numbers/deux_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_three", "resources/sounds/Characters/Enemy1/Numbers/trois_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_four", "resources/sounds/Characters/Enemy1/Numbers/quatre_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_five", "resources/sounds/Characters/Enemy1/Numbers/cinq_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_six", "resources/sounds/Characters/Enemy1/Numbers/six_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_seven", "resources/sounds/Characters/Enemy1/Numbers/sept_comptage_ennemi.wav");
        this.soundMap.put("enemy1_counting_eight", "resources/sounds/Characters/Enemy1/Numbers/huit_comptage_ennemi.wav");
        this.soundMap.put("anemone1", "resources/sounds/Characters/Hazards/anemone1.wav");
        this.soundMap.put("anemone2", "resources/sounds/Characters/Hazards/anemone2.wav");
        this.soundMap.put("anemone3", "resources/sounds/Characters/Hazards/anemone3.wav");
        this.soundMap.put("iconClick", "resources/sounds/Effects/iconClick.wav");
        this.soundMap.put("chestOpen", "resources/sounds/Effects/chestOpen.wav");
        this.soundMap.put("wrong2", "resources/sounds/Effects/wrong2.wav");
        this.soundMap.put("wrong1", "resources/sounds/Effects/wrong1.wav");
        this.soundMap.put("right", "resources/sounds/Effects/right.wav");
        this.soundMap.put("cheer", "resources/sounds/Effects/cheer.wav");
        this.soundMap.put("toContinue", "resources/sounds/Help/pourcontinuer.wav");
        this.soundMap.put("chooseSide", "resources/sounds/Help/choisiscote.wav");
        this.soundMap.put("chooseQuickly", "resources/sounds/Help/choisisvite.wav");
        this.soundMap.put("watchOutNewTraps", "resources/sounds/Help/attentionnouveauxpieges.wav");
        this.soundMap.put("moveYourCharacter", "resources/sounds/Help/faisavancerton.wav");
        this.soundMap.put("chooseCharacter", "resources/sounds/CharacChoiceScreen/choisispersonnage.wav");
        this.soundMap.put("characterLocked", "resources/sounds/CharacChoiceScreen/personnageverrouille.wav");
        this.soundMap.put("winToUnlock", "resources/sounds/CharacChoiceScreen/gagnerdeverrouiller.wav");
        this.soundMap.put("unlockedCharacter", "resources/sounds/CharacChoiceScreen/bravodeverrouille.wav");
        this.soundMap.put("chooseTheme", "resources/sounds/themeChoiceScreen/choisismonde.wav");
        this.soundMap.put("gameOver", "resources/sounds/GameOverScreen/lejeutermine.wav");
        this.soundMap.put("wellDone", "resources/sounds/GameOverScreen/bienjoue.wav");
        this.soundMap.put("badLuck", "resources/sounds/GameOverScreen/pasdechance.wav");
        this.soundMap.put("youHaveWon", "resources/sounds/GameOverScreen/tuasgagne.wav");
        this.soundMap.put("gamesOutOf", "resources/sounds/GameOverScreen/jeuxsur.wav");
        this.soundMap.put("youGetReward", "resources/sounds/GameOverScreen/authorisesauver.wav");
        this.soundMap.put("takeReward", "resources/sounds/RewardScreens/sauveprisonnier.wav");
        this.soundMap.put("hereAreRewards", "resources/sounds/RewardScreens/touslesanimaux.wav");
        this.soundMap.put("instrucsUnderwater", "resources/sounds/InstrucScreen/instrucsUnderwater.wav");
        this.soundMap.put("instrucsJungle", "resources/sounds/InstrucScreen/instrucsJungle.wav");
        this.soundMap.put("introMusic", "resources/sounds/Music/intro.wav");
        this.soundMap.put("background2", "resources/sounds/Music/background2.wav");
        this.soundMap.put("background2LowVol", "resources/sounds/Music/background2LowVol.wav");
        this.soundMap.put("rewardMusic", "resources/sounds/Music/rewardMusic.wav");
        this.soundMap.put("rewardChoice", "resources/sounds/Music/rewardChoice.wav");
    }

    protected class SoundPlayer
    implements Runnable {
        private InputStream source;
        private boolean toBeStopped = false;
        private final boolean loop;

        public SoundPlayer(InputStream source, boolean loop) {
            this.source = source;
            this.loop = loop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SourceDataLine line = (SourceDataLine)SoundManager.this.localLine.get();
            byte[] buffer = (byte[])SoundManager.this.localBuffer.get();
            if (line == null || buffer == null) {
                return;
            }
            Object object = SoundManager.this.pausedLock;
            synchronized (object) {
                if (SoundManager.this.paused) {
                    try {
                        SoundManager.this.pausedLock.wait();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
            }
            try {
                int numBytesRead = 0;
                if (this.loop && this.source != null) {
                    this.source.mark(this.source.available());
                }
                while (numBytesRead != -1 && !this.toBeStopped) {
                    if (this.source != null) {
                        numBytesRead = this.source.read(buffer, 0, buffer.length);
                        if (this.loop && numBytesRead < 0 && !this.toBeStopped) {
                            this.source.reset();
                            numBytesRead = this.source.read(buffer, 0, buffer.length);
                        }
                    } else {
                        numBytesRead = -1;
                    }
                    if (numBytesRead == -1) continue;
                    line.write(buffer, 0, numBytesRead);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            SoundManager soundManager = SoundManager.this;
            soundManager.numSndsCurrPlaying = soundManager.numSndsCurrPlaying - 1;
            if (this.toBeStopped) {
                line.flush();
            }
            SoundManager.this.playersList.remove(this);
        }

        public void setToBeStopped(boolean stopped) {
            this.toBeStopped = stopped;
        }
    }
}

