/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plots.Plot;

public class BoxPlot2D
extends Plot {
    private AbstractMatrix widths;

    public BoxPlot2D(AbstractMatrix XY, AbstractMatrix W, Color c, String n, Base b) {
        super(XY, c, n, b);
        this.widths = W;
        this.base.includeInBounds(new double[]{this.datas.min().get(0, 0) - this.widths.max().get(0, 0), this.datas.min().get(0, 1) - this.widths.max().get(0, 2)});
        this.base.includeInBounds(new double[]{this.datas.max().get(0, 0) + this.widths.max().get(0, 1), this.datas.max().get(0, 1) + this.widths.max().get(0, 3)});
    }

    public void plot(Graphics comp, Color c) {
        Graphics2D comp2D = (Graphics2D)comp;
        comp2D.setColor(c);
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            double[] Xmin = new double[]{this.datas.get(i, 0) - this.widths.get(i, 0), this.datas.get(i, 1)};
            double[] Xmax = new double[]{this.datas.get(i, 0) + this.widths.get(i, 1), this.datas.get(i, 1)};
            double[] Ymin = new double[]{this.datas.get(i, 0), this.datas.get(i, 1) - this.widths.get(i, 2)};
            double[] Ymax = new double[]{this.datas.get(i, 0), this.datas.get(i, 1) + this.widths.get(i, 3)};
            double[] Center = new double[]{this.datas.get(i, 0), this.datas.get(i, 1)};
            this.drawLine(Xmin, Xmax, comp2D);
            this.drawLine(Ymin, Ymax, comp2D);
            this.drawDot(Center, comp2D);
        }
    }

    public void note(Graphics comp) {
        this.plot(comp, Color.black);
    }

    public static void main(String[] args) {
        AbstractMatrix X = Matrix.random(10, 2).mergeColumns(Matrix.random(10, 4).divide(10.0));
        new FrameView(new Plot2DPanel(X, "Box Plot 2D", "BOX"));
    }
}

