/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jmat.gui.Plot3DPanel;
import org.jmat.gui.PlotPanel;

public class PlotToolBar
extends JToolBar {
    protected ButtonGroup buttonGroup;
    protected JToggleButton buttonCenter;
    protected JToggleButton buttonZoom;
    protected JToggleButton buttonRotate;
    protected JToggleButton buttonViewCoords;
    protected JButton buttonSetScales;
    protected JButton buttonDatas;
    protected JButton buttonSaveGraphic;
    protected JButton buttonReset;
    private boolean denySaveSecurity;
    private JFileChooser fileChooser;
    private PlotPanel plotPanel;
    static /* synthetic */ Class class$org$jmat$gui$PlotPanel;

    public PlotToolBar(PlotPanel pp) {
        this.plotPanel = pp;
        try {
            this.fileChooser = new JFileChooser();
        }
        catch (AccessControlException ace) {
            this.denySaveSecurity = true;
        }
        this.buttonGroup = new ButtonGroup();
        this.buttonCenter = new JToggleButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/center.png")));
        this.buttonCenter.setToolTipText("Center axes");
        this.buttonZoom = new JToggleButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/zoom.png")));
        this.buttonZoom.setToolTipText("Zoom");
        this.buttonViewCoords = new JToggleButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/position.png")));
        this.buttonViewCoords.setToolTipText("View coordinates / View entire plot");
        this.buttonSetScales = new JButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/scale.png")));
        this.buttonSetScales.setToolTipText("Set scales");
        this.buttonDatas = new JButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/data.png")));
        this.buttonDatas.setToolTipText("Get datas");
        this.buttonSaveGraphic = new JButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/tofile.png")));
        this.buttonSaveGraphic.setToolTipText("Save graphics in a .PNG File");
        this.buttonReset = new JButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/back.png")));
        this.buttonReset.setToolTipText("Reset axes");
        this.buttonZoom.setSelected(true);
        this.buttonZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PlotToolBar)PlotToolBar.this).plotPanel.ActionMode = 0;
            }
        });
        this.buttonCenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PlotToolBar)PlotToolBar.this).plotPanel.ActionMode = 1;
            }
        });
        this.buttonViewCoords.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotPanel.setNoteCoords(PlotToolBar.this.buttonViewCoords.isSelected());
            }
        });
        this.buttonSetScales.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotPanel.displaySetScalesFrame();
            }
        });
        this.buttonDatas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotPanel.displayDatasFrame();
            }
        });
        this.buttonSaveGraphic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.chooseFile();
            }
        });
        this.buttonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotToolBar.this.plotPanel.resetBase();
            }
        });
        this.buttonGroup.add(this.buttonCenter);
        this.buttonGroup.add(this.buttonZoom);
        this.add((Component)this.buttonCenter, null);
        this.add((Component)this.buttonZoom, null);
        this.add((Component)this.buttonViewCoords, null);
        this.add((Component)this.buttonSetScales, null);
        this.add((Component)this.buttonSaveGraphic, null);
        this.add((Component)this.buttonDatas, null);
        this.add((Component)this.buttonReset, null);
        if (!this.denySaveSecurity) {
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotToolBar.this.saveFile();
                }
            });
        } else {
            this.buttonSaveGraphic.setEnabled(false);
        }
        if (this.plotPanel instanceof Plot3DPanel) {
            if (this.buttonRotate == null) {
                this.buttonRotate = new JToggleButton(new ImageIcon((class$org$jmat$gui$PlotPanel == null ? (class$org$jmat$gui$PlotPanel = PlotToolBar.class$("org.jmat.gui.PlotPanel")) : class$org$jmat$gui$PlotPanel).getResource("icons/rotation.png")));
                this.buttonRotate.setToolTipText("Rotate axes");
                this.buttonRotate.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ((PlotToolBar)PlotToolBar.this).plotPanel.ActionMode = 2;
                    }
                });
                this.buttonGroup.add(this.buttonRotate);
                this.add(this.buttonRotate, null, 2);
            } else {
                this.buttonRotate.setEnabled(true);
            }
        } else if (this.buttonRotate != null) {
            if (this.plotPanel.ActionMode == 2) {
                this.plotPanel.ActionMode = 0;
            }
            this.buttonRotate.setEnabled(false);
        }
    }

    public int getActionMode() {
        return this.plotPanel.ActionMode;
    }

    public PlotPanel getPlotPanel() {
        return this.plotPanel;
    }

    void chooseFile() {
        this.fileChooser.showSaveDialog(this);
    }

    void saveFile() {
        File file = this.fileChooser.getSelectedFile();
        this.plotPanel.toGraphicFile(file);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

