/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.Color;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.FrameView;
import org.jmat.gui.PlotPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.Base2D;
import org.jmat.gui.plotObjects.Grid;
import org.jmat.gui.plots.BarPlot;
import org.jmat.gui.plots.BoxPlot2D;
import org.jmat.gui.plots.HistogramPlot2D;
import org.jmat.gui.plots.LinePlot;
import org.jmat.gui.plots.Plot;
import org.jmat.gui.plots.ScatterPlot;
import org.jmat.gui.plots.StaircasePlot;

public class Plot2DPanel
extends PlotPanel {
    public Plot2DPanel() {
    }

    public Plot2DPanel(double[] min, double[] max, int[] axesScales, String[] axesLabels) {
        super(min, max, axesScales, axesLabels);
    }

    public Plot2DPanel(AbstractMatrix xy, String name, String type) {
        super(xy.min().getColumns(0, 1).toDoubleArray(), xy.max().getColumns(0, 1).toDoubleArray());
        this.addPlot(xy, name, type);
    }

    public void initBasenGrid(double[] min, double[] max, int[] axesScales, String[] axesLabels) {
        this.base = new Base2D(min, max, PlotPanel.panelSize, axesScales, Base.DEFAULT_BORDER);
        this.grid = new Grid(this.base, axesLabels);
    }

    public void initBasenGrid(double[] min, double[] max) {
        this.initBasenGrid(min, max, new int[]{0, 0}, new String[]{"X", "Y"});
    }

    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0}, new double[]{1.0, 1.0});
    }

    public void setAxesLabels(String Xlabel, String Ylabel) {
        this.setAxesLabels(new String[]{Xlabel, Ylabel});
    }

    public void addPlot(AbstractMatrix XY, String name, String type, Color c) {
        Plot newPlot = null;
        if (type.equals("SCATTER")) {
            XY.checkColumnDimension(2);
            newPlot = new ScatterPlot(XY, c, name, this.base);
        } else if (type.equals("LINE")) {
            XY.checkColumnDimension(2);
            newPlot = new LinePlot(XY, c, name, this.base);
        } else if (type.equals("BAR")) {
            XY.checkColumnDimension(2);
            newPlot = new BarPlot(XY, c, name, this.base);
        } else if (type.equals("HISTOGRAM")) {
            XY.checkColumnDimension(3);
            newPlot = new HistogramPlot2D((Matrix)XY.getColumns(0, 1), (Matrix)XY.getColumn(2), c, name, this.base);
        } else if (type.equals("BOX")) {
            XY.checkColumnDimension(6);
            newPlot = new BoxPlot2D((Matrix)XY.getColumns(0, 1), (Matrix)XY.getColumns(2, 5), c, name, this.base);
        } else if (type.equals("STAIRCASE")) {
            XY.checkColumnDimension(2);
            newPlot = new StaircasePlot(XY, c, name, this.base);
        } else {
            throw new IllegalArgumentException("Plot type is unknown : ".concat(String.valueOf(String.valueOf(type))));
        }
        this.addPlot(newPlot);
    }

    public static void main(String[] args) {
        Plot2DPanel p2d = new Plot2DPanel(Matrix.random(10, 2), "plot 1", "SCATTER");
        new FrameView(p2d);
    }
}

