/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.function;

import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.function.DoubleFunction;

public class DoubleFunctionInterpolation
extends DoubleFunction {
    private AbstractMatrix X;
    private AbstractMatrix Y;

    public DoubleFunctionInterpolation(AbstractMatrix x, AbstractMatrix y) {
        if (x.getRowDimension() != y.getRowDimension()) {
            throw new IllegalArgumentException("Interpolation needs in = Matrix(m,n) and out = Matrix(m,1)");
        }
        this.argNumber = x.getColumnDimension();
        this.X = x;
        this.Y = y;
    }

    public double eval(AbstractMatrix values) {
        this.checkArgNumber(values.getColumnDimension());
        return this.interpolate(values);
    }

    public double eval(double value) {
        this.checkArgNumber(1);
        Matrix values = new Matrix(1, 1);
        values.set(0, 0, value);
        return this.interpolate(values);
    }

    private double interpolate(AbstractMatrix x) {
        int[] close = this.closest(x, this.argNumber + 1);
        AbstractMatrix Xc = this.X.getRows(close);
        AbstractMatrix Yc = this.Y.getRows(close);
        AbstractMatrix W = Xc.solve(Yc);
        AbstractMatrix y = x.times(W);
        return y.toDouble();
    }

    private int[] closest(AbstractMatrix x, int num) {
        double[] d = new double[this.X.getRowDimension()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.dist(x.toDoubleRowArray(0), this.X.toDoubleRowArray(i));
        }
        int[] c = new int[num];
        for (int j = 0; j < num; ++j) {
            double dMin = Double.MAX_VALUE;
            for (int i = 0; i < this.X.getRowDimension(); ++i) {
                if (!(d[i] < dMin)) continue;
                dMin = d[i];
                c[j] = i;
            }
            d[c[j]] = Double.MAX_VALUE;
        }
        return c;
    }

    private double dist(double[] x, double[] y) {
        double d = 0.0;
        for (int i = 0; i < x.length; ++i) {
            d += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return d;
    }

    public String toString() {
        String s = new String(String.valueOf(String.valueOf(new StringBuffer("Y0 = ").append(this.Y.toString()).append("\nX0 = ").append(this.X.toString()))));
        return s;
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Function ").append(title).append(" ").append(this.toString()))));
    }
}

