/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.function;

import org.jmat.data.AbstractMatrix;
import org.jmat.function.DoubleFunction;
import org.jmat.function.expressionParser.Evaluator;

public class DoubleFunctionExpression
extends DoubleFunction {
    private String expression;
    private String[] variables;
    private Evaluator E = new Evaluator();

    public DoubleFunctionExpression(String exp, String[] vars) {
        this.argNumber = vars.length;
        this.setFunction(exp, vars);
    }

    public DoubleFunctionExpression(String exp, String vars) {
        this.argNumber = 1;
        String[] variable = new String[]{vars};
        this.setFunction(exp, variable);
    }

    private void setFunction(String exp, String[] vars) {
        this.expression = exp;
        this.variables = vars;
    }

    private void setVariableValues(double value) {
        this.E.addVariable(this.variables[0], value);
        this.E.setExpression(this.expression);
    }

    private void setVariableValues(AbstractMatrix values) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.E.addVariable(this.variables[i], values.get(0, i));
        }
        this.E.setExpression(this.expression);
    }

    public double eval(double value) {
        this.checkArgNumber(1);
        this.setVariableValues(value);
        return (Double)this.E.getValue();
    }

    public double eval(AbstractMatrix values) {
        this.checkArgNumber(values.getColumnDimension());
        this.setVariableValues(values);
        return (Double)this.E.getValue();
    }

    public String toString() {
        String s = new String("y(".concat(String.valueOf(String.valueOf(this.variables[0]))));
        for (int i = 1; i < this.variables.length; ++i) {
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.variables[i]))))));
        }
        s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(") = ".concat(String.valueOf(String.valueOf(this.expression))))));
        return s;
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Function ").append(title).append(" ").append(this.toString()))));
    }
}

