/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.function;

import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.function.Function;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.Plot3DPanel;

public abstract class DoubleFunction
extends Function {
    public abstract double eval(AbstractMatrix var1);

    public Plot2DPanel toPlot2DPanel(double Xmin, double Xmax, String name, String type) {
        int numOfDots = 100;
        this.checkArgNumber(1);
        Matrix X = new Matrix(numOfDots, this.argNumber);
        Matrix Y = new Matrix(numOfDots, 1);
        for (int i = 0; i < numOfDots; ++i) {
            X.set(i, 0, Xmin + (double)i / (double)(numOfDots - 1) * (Xmax - Xmin));
            Y.set(i, 0, this.eval(X.getRow(i)));
        }
        return new Plot2DPanel(X.mergeColumns(Y), name, type);
    }

    public void toPlot2DPanel(Plot2DPanel p2d, double Xmin, double Xmax, String name, String type) {
        int numOfDots = 100;
        this.checkArgNumber(1);
        Matrix X = new Matrix(numOfDots, this.argNumber);
        Matrix Y = new Matrix(numOfDots, 1);
        for (int i = 0; i < numOfDots; ++i) {
            X.set(i, 0, Xmin + (double)i / (double)(numOfDots - 1) * (Xmax - Xmin));
            Y.set(i, 0, this.eval(X.getRow(i)));
        }
        p2d.addPlot(X.mergeColumns(Y), name, type);
    }

    public Plot3DPanel toPlot3DPanel(double[] Xmin, double[] Xmax, String name, String type) {
        int numOfDotsX = 20;
        int numOfDotsY = 20;
        this.checkArgNumber(2);
        Matrix X = new Matrix(numOfDotsX * numOfDotsY, this.argNumber);
        Matrix Y = new Matrix(numOfDotsX * numOfDotsY, 1);
        double pasX = (Xmax[0] - Xmin[0]) / (double)(numOfDotsX - 1);
        double pasY = (Xmax[1] - Xmin[1]) / (double)(numOfDotsY - 1);
        int n = 0;
        for (int i = 0; i < numOfDotsX; ++i) {
            for (int j = 0; j < numOfDotsY; ++j) {
                X.set(n, 0, Xmin[0] + (double)i * pasX);
                X.set(n, 1, Xmin[1] + (double)j * pasY);
                Y.set(n, 0, this.eval(X.getRow(i)));
                ++n;
            }
        }
        return new Plot3DPanel(X.mergeColumns(Y), name, type);
    }

    public void toPlot3DPanel(Plot3DPanel p3d, double[] Xmin, double[] Xmax, String name, String type) {
        int numOfDotsX = 20;
        int numOfDotsY = 20;
        this.checkArgNumber(2);
        Matrix X = new Matrix(numOfDotsX * numOfDotsY, this.argNumber);
        Matrix Y = new Matrix(numOfDotsX * numOfDotsY, 1);
        double pasX = (Xmax[0] - Xmin[0]) / (double)(numOfDotsX - 1);
        double pasY = (Xmax[1] - Xmin[1]) / (double)(numOfDotsY - 1);
        int n = 0;
        for (int i = 0; i < numOfDotsX; ++i) {
            for (int j = 0; j < numOfDotsY; ++j) {
                X.set(n, 0, Xmin[0] + (double)i * pasX);
                X.set(n, 1, Xmin[1] + (double)j * pasY);
                Y.set(n, 0, this.eval(X.getRow(i)));
                ++n;
            }
        }
        p3d.addPlot(X.mergeColumns(Y), name, type);
    }
}

