/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;
import org.jmat.data.matrixDecompositions.CholeskyDecomposition;
import org.jmat.data.matrixDecompositions.EigenvalueDecomposition;
import org.jmat.data.matrixDecompositions.LUDecomposition;
import org.jmat.data.matrixDecompositions.Mathfun;
import org.jmat.data.matrixDecompositions.QRDecomposition;
import org.jmat.data.matrixDecompositions.SingularValueDecomposition;
import org.jmat.data.matrixTools.Finding;
import org.jmat.data.matrixTools.Slicing;
import org.jmat.data.matrixTools.Sorting;
import org.jmat.function.DoubleFunction;
import org.jmat.gui.MatrixTablePanel;
import org.jmat.gui.Plot2DPanel;
import org.jmat.gui.Plot3DPanel;
import org.jmat.io.ClipBoardPrintable;
import org.jmat.io.CommandLinePrintable;
import org.jmat.io.FilePrintable;
import org.jmat.io.MatrixMathML;
import org.jmat.io.MatrixString;
import org.jmat.io.StringPrintable;
import org.jmat.io.XMLPrintable;
import org.jmat.io.files.ASCIIFile;

public abstract class AbstractMatrix
extends AbstractDoubleArray
implements CommandLinePrintable,
StringPrintable,
XMLPrintable,
FilePrintable,
ClipBoardPrintable {
    public AbstractMatrix(int _m, int _n) {
        super(_m, _n);
    }

    public abstract AbstractMatrix getInstance(int var1, int var2);

    public AbstractMatrix getInstanceCopyOf(AbstractMatrix M) {
        AbstractMatrix X = this.getInstance(M.m, M.n);
        for (int i = 0; i < M.m; ++i) {
            for (int j = 0; j < M.n; ++j) {
                X.set(i, j, M.get(i, j));
            }
        }
        return X;
    }

    public AbstractDoubleArray getDoubleArrayCopy() {
        return this.getInstanceCopyOf(this);
    }

    public AbstractMatrix copy() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        return X;
    }

    public AbstractMatrix getSubMatrix(int i0, int i1, int j0, int j1) {
        AbstractMatrix X = this.getInstance(i1 - i0 + 1, j1 - j0 + 1);
        super.putSubMatrixIn(i0, i1, j0, j1, X);
        return X;
    }

    public AbstractMatrix getRow(int i) {
        AbstractMatrix X = this.getInstance(1, this.n);
        super.putRowIn(i, X);
        return X;
    }

    public AbstractMatrix getRows(int[] I) {
        AbstractMatrix X = this.getInstance(I.length, this.n);
        super.putRowsIn(I, X);
        return X;
    }

    public AbstractMatrix getRows(int i0, int i1) {
        AbstractMatrix X = this.getInstance(i1 - i0 + 1, this.n);
        super.putRowsIn(i0, i1, X);
        return X;
    }

    public AbstractMatrix getColumn(int j) {
        AbstractMatrix X = this.getInstance(this.m, 1);
        super.putColumnIn(j, X);
        return X;
    }

    public AbstractMatrix getColumns(int[] J) {
        AbstractMatrix X = this.getInstance(this.m, J.length);
        super.putColumnsIn(J, X);
        return X;
    }

    public AbstractMatrix getColumns(int j0, int j1) {
        AbstractMatrix X = this.getInstance(this.m, j1 - j0 + 1);
        super.putColumnsIn(j0, j1, X);
        return X;
    }

    public AbstractMatrix getDiagonal() {
        int d = Math.min(this.m, this.n);
        AbstractMatrix X = this.getInstance(d, 1);
        super.putDiagonalIn(X);
        return X;
    }

    public AbstractMatrix getDiagonal(int num) {
        int l = 0;
        l = this.n < this.m ? (num >= 0 ? this.n - num : (num < this.n - this.m ? this.m + num : this.n)) : (num <= 0 ? this.m + num : (num > this.n - this.m ? this.n - num : this.m));
        AbstractMatrix X = this.getInstance(l, 1);
        super.putDiagonalIn(num, X);
        return X;
    }

    public AbstractMatrix resize(int m2, int n2) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.resizeEquals(m2, n2);
        return X;
    }

    public AbstractMatrix reshapeRows(int m2, int n2) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.reshapeRowsEquals(m2, n2);
        return X;
    }

    public AbstractMatrix reshapeColumns(int m2, int n2) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.reshapeColumnsEquals(m2, n2);
        return X;
    }

    public AbstractMatrix mergeRows(AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.mergeRowsEquals(B);
        return X;
    }

    public AbstractMatrix mergeColumns(AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.mergeColumnsEquals(B);
        return X;
    }

    public AbstractMatrix insertRows(int I, AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.insertRowsEquals(I, B);
        return X;
    }

    public AbstractMatrix insertColumns(int J, AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.insertColumnsEquals(J, B);
        return X;
    }

    public AbstractMatrix deleteRow(int I) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteRowEquals(I);
        return X;
    }

    public AbstractMatrix deleteColumn(int J) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteColumnEquals(J);
        return X;
    }

    public AbstractMatrix deleteRows(int[] I) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteRowsEquals(I);
        return X;
    }

    public AbstractMatrix deleteRows(int i0, int i1) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteRowsEquals(i0, i1);
        return X;
    }

    public AbstractMatrix deleteColumns(int[] J) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteColumnsEquals(J);
        return X;
    }

    public AbstractMatrix deleteColumns(int j0, int j1) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.deleteColumnsEquals(j0, j1);
        return X;
    }

    public double norm1() {
        double f = 0.0;
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.m; ++i) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double norm2() {
        return this.svd().norm2();
    }

    public double normInfinity() {
        double f = 0.0;
        for (int i = 0; i < this.m; ++i) {
            double s = 0.0;
            for (int j = 0; j < this.n; ++j) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double normFrobenius() {
        double f = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                f = Mathfun.hypot(f, this.get(i, j));
            }
        }
        return f;
    }

    public double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            t += this.get(i, i);
        }
        return t;
    }

    public double determinant() {
        return this.lu().det();
    }

    public int rank() {
        return this.svd().rank();
    }

    public double condition() {
        return this.svd().cond();
    }

    public AbstractMatrix min() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double minval = this.get(0, j);
            for (int i = 0; i < this.m; ++i) {
                minval = Math.min(minval, this.get(i, j));
            }
            X.set(0, j, minval);
        }
        return X;
    }

    public AbstractMatrix max() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double maxval = this.get(0, j);
            for (int i = 0; i < this.m; ++i) {
                maxval = Math.max(maxval, this.get(i, j));
            }
            X.set(0, j, maxval);
        }
        return X;
    }

    public AbstractMatrix sum() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.m; ++i) {
                s += this.get(i, j);
            }
            X.set(0, j, s);
        }
        return X;
    }

    public AbstractMatrix cumSum() {
        AbstractMatrix X = this.getInstance(this.m, this.n);
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.m; ++i) {
                X.set(i, j, s += this.get(i, j));
            }
        }
        return X;
    }

    public AbstractMatrix product() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double p = 1.0;
            for (int i = 0; i < this.m; ++i) {
                p *= this.get(i, j);
            }
            X.set(0, j, p);
        }
        return X;
    }

    public AbstractMatrix cumProduct() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double p = 1.0;
            for (int i = 0; i < this.m; ++i) {
                X.set(i, j, p *= this.get(i, j));
            }
        }
        return X;
    }

    public AbstractMatrix distance(AbstractDoubleArray B, double pow) {
        this.checkColumnDimension(B);
        AbstractMatrix X = this.getInstance(this.m, B.m);
        for (int i = 0; i < this.m; ++i) {
            for (int k = 0; k < B.m; ++k) {
                double s = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    s += Math.pow(this.get(i, j) - B.get(k, j), pow);
                }
                X.set(i, k, Math.pow(s, 1.0 / pow));
            }
        }
        return X;
    }

    public AbstractMatrix mean() {
        AbstractMatrix X = this.getInstance(1, this.n);
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int k = 0; k < this.m; ++k) {
                s += this.get(k, j);
            }
            X.set(0, j, s / (double)this.m);
        }
        return X;
    }

    public AbstractMatrix covariance() {
        AbstractMatrix X = this.getInstance(this.n, this.n);
        int degrees = this.m - 1;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < this.m; ++k) {
                    s1 += this.get(k, i);
                    s2 += this.get(k, j);
                }
                s1 /= (double)this.m;
                s2 /= (double)this.m;
                for (k = 0; k < this.m; ++k) {
                    c += (this.get(k, i) - s1) * (this.get(k, j) - s2);
                }
                X.set(i, j, c / (double)degrees);
            }
        }
        return X;
    }

    public AbstractMatrix correlation() {
        int j;
        int i;
        AbstractMatrix X = this.getInstance(this.n, this.n);
        int degrees = this.m - 1;
        Matrix V = new Matrix(this.n, this.n);
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < this.m; ++k) {
                    s1 += this.get(k, i);
                    s2 += this.get(k, j);
                }
                s1 /= (double)this.m;
                s2 /= (double)this.m;
                for (k = 0; k < this.m; ++k) {
                    c += (this.get(k, i) - s1) * (this.get(k, j) - s2);
                }
                V.set(i, j, c / (double)degrees);
            }
        }
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                X.set(i, j, V.get(i, j) / Math.sqrt(V.get(i, i) * V.get(j, j)));
            }
        }
        return X;
    }

    public AbstractMatrix variance() {
        AbstractMatrix X = this.getInstance(1, this.n);
        int degrees = this.m - 1;
        for (int j = 0; j < this.n; ++j) {
            int k;
            double c = 0.0;
            double s = 0.0;
            for (k = 0; k < this.m; ++k) {
                s += this.get(k, j);
            }
            s /= (double)this.m;
            for (k = 0; k < this.m; ++k) {
                c += (this.get(k, j) - s) * (this.get(k, j) - s);
            }
            X.set(0, j, c / (double)degrees);
        }
        return X;
    }

    public AbstractMatrix transpose() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.transposeEquals();
        return X;
    }

    public AbstractMatrix uminus() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.uminusEquals();
        return X;
    }

    public AbstractMatrix plus(double s) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.plusEquals(s);
        return X;
    }

    public AbstractMatrix plus(AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.plusEquals(B);
        return X;
    }

    public AbstractMatrix minus(double s) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.minusEquals(s);
        return X;
    }

    public AbstractMatrix minus(AbstractDoubleArray B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.minusEquals(B);
        return X;
    }

    public AbstractMatrix times(double s) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.timesEquals(s);
        return X;
    }

    public AbstractMatrix times(AbstractDoubleArray B) {
        B.checkRowDimension(this.n);
        AbstractMatrix X = this.getInstance(this.m, B.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < B.getColumnDimension(); ++j) {
                double element = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    element += this.get(i, k) * B.get(k, j);
                }
                X.set(i, j, element);
            }
        }
        return X;
    }

    public AbstractMatrix divide(double s) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.divideEquals(s);
        return X;
    }

    public AbstractMatrix divide(AbstractMatrix B) {
        B.checkRowDimension(this.n);
        return this.times(B.inverse());
    }

    public AbstractMatrix solve(AbstractMatrix B) {
        return this.qr().solve(B);
    }

    public AbstractMatrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public void transposeEquals() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        this.reset(this.n, this.m);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, X.get(j, i));
            }
        }
    }

    public void uminusEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, -this.get(i, j));
            }
        }
    }

    public void plusEquals(double s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) + s);
            }
        }
    }

    public void plusEquals(AbstractDoubleArray B) {
        this.checkDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) + B.get(i, j));
            }
        }
    }

    public void minusEquals(double s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) - s);
            }
        }
    }

    public void minusEquals(AbstractDoubleArray B) {
        this.checkDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) - B.get(i, j));
            }
        }
    }

    public void timesEquals(double s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, s * this.get(i, j));
            }
        }
    }

    public void divideEquals(double s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) / s);
            }
        }
    }

    public AbstractMatrix ebeTimes(AbstractMatrix B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeTimesEquals(B);
        return X;
    }

    public AbstractMatrix ebeDivide(AbstractMatrix B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeDivideEquals(B);
        return X;
    }

    public AbstractMatrix ebeCos() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeCosEquals();
        return X;
    }

    public AbstractMatrix ebeSin() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeSinEquals();
        return X;
    }

    public AbstractMatrix ebeExp() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeExpEquals();
        return X;
    }

    public AbstractMatrix ebePower(double p) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebePowerEquals(p);
        return X;
    }

    public AbstractMatrix ebePower(Matrix B) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebePowerEquals(B);
        return X;
    }

    public AbstractMatrix ebeLog() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeLogEquals();
        return X;
    }

    public AbstractMatrix ebeInverse() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeInverseEquals();
        return X;
    }

    public AbstractMatrix ebeSqrt() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeSqrtEquals();
        return X;
    }

    public AbstractMatrix ebeAbs() {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeAbsEquals();
        return X;
    }

    public AbstractMatrix ebeFunction(DoubleFunction fun) {
        AbstractMatrix X = this.getInstanceCopyOf(this);
        X.ebeFunctionEquals(fun);
        return X;
    }

    public void ebeTimesEquals(AbstractMatrix B) {
        this.checkDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) * B.get(i, j));
            }
        }
    }

    public void ebeDivideEquals(AbstractMatrix B) {
        this.checkDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) / B.get(i, j));
            }
        }
    }

    public void ebeCosEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.cos(this.get(i, j)));
            }
        }
    }

    public void ebeSinEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.sin(this.get(i, j)));
            }
        }
    }

    public void ebeExpEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.sin(this.get(i, j)));
            }
        }
    }

    public void ebePowerEquals(double p) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.pow(this.get(i, j), p));
            }
        }
    }

    public void ebePowerEquals(AbstractMatrix B) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.pow(this.get(i, j), B.get(i, j)));
            }
        }
    }

    public void ebeLogEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.log(this.get(i, j)));
            }
        }
    }

    public void ebeInverseEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.pow(this.get(i, j), -1.0));
            }
        }
    }

    public void ebeSqrtEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.sqrt(this.get(i, j)));
            }
        }
    }

    public void ebeAbsEquals() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, Math.abs(this.get(i, j)));
            }
        }
    }

    public void ebeFunctionEquals(DoubleFunction fun) {
        fun.checkArgNumber(1);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, fun.eval(new Matrix(1, 1, this.get(i, j))));
            }
        }
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition cholesky() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public AbstractMatrix sort(int j) {
        return Sorting.MatrixRows(this, j);
    }

    public Finding find(double min, double max) {
        return new Finding(this, min, max);
    }

    public Finding find(String test, double val) {
        return new Finding(this, test, val);
    }

    public AbstractMatrix slice(int[] N) {
        return Slicing.UniformBounds(this, N);
    }

    public AbstractMatrix slice(int _n) {
        int[] N = new int[this.getColumnDimension()];
        for (int i = 0; i < this.getColumnDimension(); ++i) {
            N[i] = _n;
        }
        return Slicing.UniformBounds(this, N);
    }

    public String toString() {
        String s = MatrixString.printMatrix(this);
        return s;
    }

    public void toClipBoard() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.toString()), null);
    }

    public Element toXMLElement() {
        Element e = MatrixMathML.printMatrix(this);
        return e;
    }

    public void toASCIIFile(File file) {
        ASCIIFile.write(file, MatrixString.printMatrix(this));
    }

    public void toCommandLine(String title) {
        System.out.println(String.valueOf(String.valueOf(title)).concat(" ="));
        System.out.println(this.toString());
    }

    public MatrixTablePanel toTablePanel() {
        return new MatrixTablePanel(this);
    }

    public Plot2DPanel toPlot2DPanel(String name, String type) {
        return new Plot2DPanel(this, name, type);
    }

    public Plot3DPanel toPlot3DPanel(String name, String type) {
        return new Plot3DPanel(this, name, type);
    }

    public void toPlot2DPanel(Plot2DPanel panel, String name, String type) {
        panel.addPlot(this, name, type);
    }

    public void toPlot3DPanel(Plot3DPanel panel, String name, String type) {
        panel.addPlot(this, name, type);
    }

    public Plot2DPanel toHist2DPanel(String name, int num) {
        return new Plot2DPanel(this.slice(num), name, "HISTOGRAM");
    }

    public Plot3DPanel toHist3DPanel(String name, int num) {
        return new Plot3DPanel(this.slice(num), name, "HISTOGRAM");
    }

    public void toHist2DPanel(Plot2DPanel panel, String name, int num) {
        panel.addPlot(this.slice(num), name, "HISTOGRAM");
    }

    public void toHist3DPanel(Plot3DPanel panel, String name, int num) {
        panel.addPlot(this.slice(num), name, "HISTOGRAM");
    }

    public static AbstractMatrix fromASCIIFile(File file) {
        Matrix _m = MatrixString.readString(ASCIIFile.read(file));
        return _m;
    }

    public static AbstractMatrix fromString(String s) {
        Matrix _m = MatrixString.readString(s);
        return _m;
    }

    public static AbstractMatrix fromClipBoard() throws UnsupportedFlavorException, IOException {
        String s = "";
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            s = (String)t.getTransferData(DataFlavor.stringFlavor);
        }
        Matrix _m = MatrixString.readString(s);
        return _m;
    }

    public static AbstractMatrix fromXMLElement(Element e) {
        Matrix _m = MatrixMathML.readMMLElement(e);
        return _m;
    }
}

