/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.Game;
import graphics.screens.Screen;
import graphics.sprites.GifSprite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Random;
import util.Utilities;

public class RewardSprite
extends GifSprite {
    private Game game;
    private Screen rewardScreen;
    private int rewardType;
    private int minx;
    private int maxx;
    private int miny;
    private int maxy;
    private static Random randomNumberGenerator = new Random(System.currentTimeMillis());
    int side;
    private static final int MIN_VELOCITY = 8;
    private static final int MAX_VELOCITY = 15;

    public RewardSprite(Game game, Screen rewardScreen, Point location, String[] fileNames, int rewardType, int minx, int maxx, int miny, int maxy) {
        super(location.x, location.y, fileNames, rewardScreen);
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.setVisible(false);
        this.setActive(false);
        this.setSuspended(false);
        this.rewardScreen = rewardScreen;
        this.rewardType = rewardType;
        this.game = game;
        this.setPosition(location.x, location.y);
        this.side = randomNumberGenerator.nextInt(2);
        if (this.side == 0) {
            this.setDestination(new Point(minx, randomNumberGenerator.nextInt(maxy - miny) + miny));
        } else if (this.side == 1) {
            this.setDestination(new Point(maxx, randomNumberGenerator.nextInt(maxy - miny) + miny));
            this.switchImage();
        }
        int newVelocity = randomNumberGenerator.nextInt(7);
        this.setVelocity(newVelocity, newVelocity);
    }

    @Override
    public void load() {
        super.load();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        super.unload();
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive() && !this.suspended) {
            float xLocation = this.getX();
            float yLocation = this.getY();
            if (this.destinationX == (float)this.minx && xLocation <= (float)(this.minx + this.width / 2) || this.destinationX == (float)this.maxx && xLocation >= (float)(this.maxx - this.width / 2)) {
                this.switchImage();
                this.side = Utilities.oppositeSide(this.side);
                if (this.side == 0) {
                    this.setDestination(new Point(this.minx, (int)this.destinationY));
                } else if (this.side == 1) {
                    this.setDestination(new Point(this.maxx, (int)this.destinationY));
                }
            } else {
                if (xLocation < this.destinationX) {
                    xLocation = (int)(xLocation + Math.min(this.vX, this.destinationX - xLocation));
                } else if (xLocation > this.destinationX) {
                    xLocation = (int)(xLocation + Math.max(-1.0f * this.vX, this.destinationX - xLocation));
                }
                if (yLocation < this.destinationY) {
                    yLocation = (int)(yLocation + Math.min(this.vY, this.destinationY - yLocation));
                } else if (yLocation > this.destinationY) {
                    yLocation = (int)(yLocation + Math.max(-1.0f * this.vY, this.destinationY - yLocation));
                }
                this.setPosition(xLocation, yLocation);
            }
            this.setDestination(new Point((int)this.destinationX, randomNumberGenerator.nextInt(this.maxy - this.miny) + this.miny));
            int newVelocity = randomNumberGenerator.nextInt(7);
            this.setVelocity(newVelocity, newVelocity);
            this.update();
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.images[this.currentImage], (int)(this.x - (float)(this.width / 2)), (int)(this.y - (float)(this.height / 2)), this.width, this.height, null);
        }
    }

    public void selected() {
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }

    public void reset() {
        this.setVisible(false);
        this.setImageActive(false);
        this.setActive(false);
        this.setSuspended(false);
        this.animationCycleCount = 0;
        this.update();
    }

    @Override
    public void update() {
        if (this.isReady()) {
            this.rewardScreen.setRendered(false);
        }
    }

    public int getRewardType() {
        return this.rewardType;
    }

    @Override
    public void setSuspended(boolean state) {
        this.suspended = state;
    }
}

