/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.GifSprite;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class PlayerSprite
extends GifSprite {
    public byte playerID;
    public int characterID;
    private String playerSpriteType;
    protected BoardScreen boardScreen;
    protected ChoiceScreen choiceScreen;
    protected Point originalLocation;
    public boolean characterSet = false;
    protected String noise;

    public PlayerSprite(BoardScreen boardScreen, ChoiceScreen choiceScreen, Point location, byte playerID, int characterID, String playerSpriteType) {
        super(location.x, location.y, boardScreen, (byte)2);
        this.setVisible(false);
        this.setActive(false);
        this.setSuspended(false);
        this.boardScreen = boardScreen;
        this.choiceScreen = choiceScreen;
        this.playerID = playerID;
        this.characterID = characterID;
        this.playerSpriteType = playerSpriteType;
        this.setDestination(new Point(location.x, location.y));
        this.setPosition(location.x, location.y);
        this.originalLocation = new Point(location.x, location.y);
        this.setCharacter(characterID);
        this.animationCycleDelay = 200;
    }

    @Override
    public void load() {
        if (this.characterSet) {
            super.load();
            this.setReady(true);
        }
    }

    @Override
    public void unload() {
        this.setReady(false);
        super.unload();
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.images[this.currentImage], (int)(this.x - (float)(this.getWidth() / 2)), (int)(this.y - (float)(this.getWidth() / 2)), this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public void animate() {
        this.moved = false;
        if (this.isActive() && !this.suspended) {
            this.adjustSpeed();
            float xLocation = this.getX();
            float yLocation = this.getY();
            if (xLocation != this.destinationX || yLocation != this.destinationY) {
                this.moved = true;
                if (xLocation < this.destinationX) {
                    xLocation += Math.min(this.vX, this.destinationX - xLocation);
                } else if (xLocation > this.destinationX) {
                    xLocation += Math.max(this.vX, this.destinationX - xLocation);
                }
                if (yLocation < this.destinationY) {
                    yLocation += Math.min(this.vY, this.destinationY - yLocation);
                } else if (yLocation > this.destinationY) {
                    yLocation += Math.max(this.vY, this.destinationY - yLocation);
                }
                this.setPosition(xLocation, yLocation);
            }
        }
    }

    public void speak(int timeInterval) {
        this.numAnimationCycles = timeInterval / this.animationCycleDelay;
        this.setImageActive(true);
        this.setImageSuspended(false);
    }

    @Override
    public void animateImage(Screen screen) {
        this.changedImage = false;
        if (!this.imageSuspended) {
            this.switchImage();
            this.changedImage = true;
            this.setImageSuspended(true);
            if (this.playerSpriteType == "PlayerIcon") {
                this.choiceScreen.game.delay(this.animationCycleDelay, "choiceScreen.playerIcons[" + this.playerID + "].setImageSuspended(false)");
            }
            if (this.playerSpriteType == "PlayerPiece") {
                this.choiceScreen.game.delay(this.animationCycleDelay, "boardScreen.players[" + this.playerID + "].setImageSuspended(false)");
            }
            ++this.animationCycleCount;
            if (this.animationCycleCount >= this.numAnimationCycles) {
                this.setImageActive(false);
                this.setImageSuspended(false);
                if (this.currentImage != 0) {
                    this.switchImage();
                }
            }
        }
    }

    public void setCharacter(int characID) {
        this.characterID = characID;
        if (this.playerID == 0) {
            this.fileNames[0] = this.choiceScreen.game.themeVars.player1CharacterFiles[characID][0];
            this.fileNames[1] = this.choiceScreen.game.themeVars.player1CharacterFiles[characID][1];
            this.noise = this.choiceScreen.game.themeVars.player1CharacNoises[characID];
        }
        if (this.playerID == 1) {
            this.fileNames[0] = this.choiceScreen.game.themeVars.player2CharacterFiles[characID][0];
            this.fileNames[1] = this.choiceScreen.game.themeVars.player2CharacterFiles[characID][1];
            this.noise = this.choiceScreen.game.themeVars.player2CharacNoises[characID];
        }
        this.characterSet = true;
        if (this.isReady()) {
            this.reload();
        }
        this.update();
    }

    public void themeChanged() {
        this.setCharacter(this.characterID);
    }

    @Override
    public void setSuspended(boolean state) {
        super.setSuspended(state);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void update() {
    }
}

