/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.screens.Screen;
import graphics.sprites.Sprite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import util.ImageFactory;

public abstract class GifSprite
extends Sprite {
    public Screen screen;
    protected BufferedImage[] images;
    protected String[] fileNames;
    public byte numImages;
    boolean loaded = false;
    protected byte currentImage = 0;
    static final byte IMAGE_A = 0;
    static final byte IMAGE_B = 1;
    protected boolean imageSuspended = false;
    protected int numAnimationCycles = 0;
    protected int animationCycleCount = 0;
    protected int animationCycleDelay = 0;

    public GifSprite(int x, int y, String[] fileNames, Screen screen) {
        this.x = x;
        this.y = y;
        this.screen = screen;
        this.fileNames = fileNames;
        this.numImages = (byte)fileNames.length;
        this.setDestination(new Point(x, y));
    }

    public GifSprite(int x, int y, String fileName, Screen screen) {
        this.x = x;
        this.y = y;
        this.screen = screen;
        this.fileNames = new String[1];
        this.numImages = 1;
        this.fileNames[0] = fileName;
        this.setDestination(new Point(x, y));
    }

    public GifSprite(int x, int y, Screen screen, byte numImages) {
        this.x = x;
        this.y = y;
        this.screen = screen;
        this.numImages = numImages;
        this.fileNames = new String[numImages];
        this.setDestination(new Point(x, y));
    }

    @Override
    public void load() {
        if (!this.loaded && this.fileNames != null) {
            this.loaded = true;
            this.images = new BufferedImage[this.numImages];
            this.reload();
        }
    }

    protected void reload() {
        int i = 0;
        while (i < this.numImages) {
            this.images[i] = ImageFactory.getCompatibleImage(this.fileNames[i], this.screen.gc, 2);
            ++i;
        }
        this.setSize(this.images[0].getWidth(), this.images[0].getHeight());
    }

    @Override
    public void unload() {
        int i = 0;
        while (i < 2) {
            if (this.images.length >= i + 1) {
                this.images[i] = null;
            }
            ++i;
        }
        this.loaded = false;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render() {
        this.setRendered(true);
    }

    @Override
    public void paint(Graphics2D g) {
    }

    public void setImageSuspended(boolean state) {
        this.imageSuspended = state;
    }

    public boolean getImageSuspended() {
        return this.imageSuspended;
    }

    public void switchImage() {
        if (this.numImages > 1) {
            this.currentImage = this.currentImage < this.numImages - 1 ? (byte)(this.currentImage + 1) : (byte)0;
        }
        this.update();
    }

    @Override
    public void animate() {
        super.animate();
    }
}

