/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.managers.DotManager;
import graphics.others.DotArray;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.Sprite;
import java.awt.Color;
import java.awt.Graphics2D;

public class DotSprite
extends Sprite {
    private DotArray dotArray;
    private ChoiceScreen choiceScreen;
    private BoardScreen boardScreen;
    private DotManager dotManager;
    private float xDotContainer;
    private float yDotContainer;
    private float xScreen;
    private float yScreen;
    private int trackSquare;
    private boolean border;
    private Color dotColor;
    private static Color borderColor = new Color(0, 0, 0);
    private static int borderSize = 2;
    private byte id;

    public DotSprite(DotArray dotArray, byte id) {
        this.dotArray = dotArray;
        this.choiceScreen = dotArray.choiceScreen;
        this.boardScreen = dotArray.choiceScreen.boardScreen;
        this.id = id;
        this.setActive(false);
        this.setVisible(false);
        this.setWidth(5);
        this.setHeight(5);
        this.trackSquare = 0;
        this.border = true;
        this.dotColor = this.choiceScreen.game.themeVars.dotColor;
    }

    @Override
    public void load() {
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
    }

    public void loadSpriteImage() {
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive()) {
            this.adjustSpeed();
            float xLocation = this.getXScreen();
            float yLocation = this.getYScreen();
            if (xLocation < this.destinationX) {
                xLocation += Math.min(this.vX, this.destinationX - xLocation);
            } else if (xLocation > this.destinationX) {
                xLocation += Math.max(this.vX, this.destinationX - xLocation);
            }
            if (yLocation < this.destinationY) {
                yLocation += Math.min(this.vY, this.destinationY - yLocation);
            } else if (yLocation > this.destinationY) {
                yLocation += Math.max(this.vY, this.destinationY - yLocation);
            }
            this.setPositionRelativeToScreen(xLocation, yLocation);
            if ((int)this.getXScreen() == (int)this.destinationX && (int)this.getYScreen() == (int)this.destinationY) {
                this.setActive(false);
            }
            this.dotManager.update();
        }
    }

    @Override
    public void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
        }
    }

    @Override
    public void paint(Graphics2D g) {
    }

    public void paint(Graphics2D g, String commandFrom) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            int halfWidth = this.width >> 1;
            int halfHeight = this.height >> 1;
            int twiceBorderSize = borderSize << 1;
            g.setColor(borderColor);
            if (commandFrom == "DotArray") {
                g.fillOval((int)(this.xDotContainer - (float)halfWidth), (int)(this.yDotContainer - (float)halfHeight), this.width, this.height);
                g.setColor(this.dotColor);
                g.fillOval((int)(this.xDotContainer - (float)halfWidth + (float)borderSize), (int)(this.yDotContainer - (float)halfHeight + (float)borderSize), this.width - twiceBorderSize, this.height - twiceBorderSize);
            } else if (commandFrom == "ChoiceScreen" || commandFrom == "BoardScreen") {
                g.fillOval((int)(this.xScreen - (float)halfWidth), (int)(this.yScreen - (float)halfHeight), this.width, this.height);
                g.setColor(this.dotColor);
                g.fillOval((int)(this.xScreen - (float)halfWidth + (float)borderSize), (int)(this.yScreen - (float)halfHeight + (float)borderSize), this.width - twiceBorderSize, this.height - twiceBorderSize);
            }
        }
    }

    public void setDotColor(Color dotColor) {
        this.dotColor = dotColor;
        this.update();
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.xDotContainer = this.dotArray.getX() + x;
        this.yDotContainer = this.dotArray.getY() + y;
        this.xScreen = this.dotArray.dotContainer.getX() + this.dotArray.getX() + x;
        this.yScreen = this.dotArray.dotContainer.getY() + this.dotArray.getY() + y;
    }

    public void setSize(int width, int height) {
        this.setHeight(height + borderSize * 2);
        this.setWidth(width + borderSize * 2);
        this.loadSpriteImage();
    }

    public void setPositionRelativeToScreen(float x, float y) {
        this.xScreen = x;
        this.yScreen = y;
    }

    public void setSquare(int square) {
        this.trackSquare = square;
    }

    public void setDotMover(DotManager dotMover) {
        this.dotManager = dotMover;
    }

    public void reset() {
        this.setDotColor(this.choiceScreen.game.themeVars.dotColor);
        this.dotManager = null;
        this.update();
    }

    @Override
    public void update() {
        this.setRendered(false);
        if (this.dotManager != null) {
            this.dotManager.update();
        }
    }

    public void themeChanged() {
        this.reset();
    }

    @Override
    protected float calculateDistanceX() {
        float _x = this.destinationX - this.getXScreen();
        return _x;
    }

    @Override
    protected float calculateDistanceY() {
        float _y = this.destinationY - this.getYScreen();
        return _y;
    }

    public void setXScreen(float xPos) {
        this.xScreen = xPos;
    }

    public void setYScreen(float yPos) {
        this.yScreen = yPos;
    }

    public float getYScreen() {
        return this.yScreen;
    }

    public float getXScreen() {
        return this.xScreen;
    }
}

