/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.Sprite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import util.Utilities;

public class Button
extends Sprite {
    public ChoiceScreen choiceScreen;
    protected Image offScreenImage;
    String text;

    public Button(ChoiceScreen choiceScreen, int x, int y, int width, int height, String text) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.choiceScreen = choiceScreen;
        this.text = text;
        this.setReady(false);
        this.setVisible(true);
        this.setActive(false);
        this.setVelocity(0.0f, 0.0f);
        this.setDestination(new Point(x, y));
    }

    @Override
    public void load() {
        this.createImage();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        this.offScreenImage = null;
    }

    private boolean createImage() {
        this.offScreenImage = Utilities.createImage(this.choiceScreen, this.width, this.height);
        Graphics2D g2D = (Graphics2D)this.offScreenImage.getGraphics();
        g2D.setColor(this.choiceScreen.game.themeVars.screenColor);
        g2D.fillRect(0, 0, this.width, this.height);
        g2D.setColor(this.choiceScreen.game.themeVars.screenColor);
        g2D.fill(new RoundRectangle2D.Double(0.0, 0.0, this.width, this.height, 20.0, 20.0));
        g2D.setColor(this.choiceScreen.game.themeVars.textColor);
        g2D.setFont(this.choiceScreen.game.themeVars.buttonTextFont);
        Utilities.drawFromPoint(this.text, this.width / 2, this.height / 2, 0, 0, g2D);
        g2D.dispose();
        return true;
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
    }

    public void selected() {
        this.choiceScreen.game.soundManager.play("iconClick");
    }

    @Override
    public void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            g.drawImage(this.offScreenImage, (int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void setImageActive(boolean state) {
    }
}

