/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.screens.Screen;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TitleScreen
extends Screen {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 0, 0);
    public boolean timeToSwitchImage = false;
    private Point mousePoint = new Point();

    public TitleScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[8];
        this.backgroundImageFiles[0] = "/resources/images/common/titlePages/mainPage.gif";
        this.backgroundImageFiles[1] = "/resources/images/common/titlePages/mainPage1.gif";
        this.backgroundImageFiles[2] = "/resources/images/common/titlePages/mainPage2.gif";
        this.backgroundImageFiles[3] = "/resources/images/common/titlePages/mainPage3.gif";
        this.backgroundImageFiles[4] = "/resources/images/common/titlePages/mainPage4.gif";
        this.backgroundImageFiles[5] = "/resources/images/common/titlePages/mainPage5.gif";
        this.backgroundImageFiles[6] = "/resources/images/common/titlePages/mainPage6.gif";
        this.backgroundImageFiles[7] = "/resources/images/common/titlePages/mainPage7.gif";
        this.hasSounds = true;
        this.backgroundSoundtrack = "introMusic";
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
    }

    @Override
    public void load() {
        super.load();
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.delay(2400, "game.titleScreen.timeToSwitchImage=true");
        if (this.backgroundSoundtrack != null) {
            this.game.soundManager.play(this.backgroundSoundtrack, true);
        }
        super.start();
    }

    @Override
    public void process() {
        if (this.readyToProcess && this.timeToSwitchImage) {
            this.timeToSwitchImage = false;
            this.switchBackgroundImage();
            this.game.delay(2400, "game.titleScreen.timeToSwitchImage=true");
        }
    }

    public void switchBackgroundImage() {
        if (this.currentBackgroundImage == this.backgroundImageFiles.length - 1) {
            this.setCurrentBgImage(1);
        } else {
            this.setCurrentBgImage(this.currentBackgroundImage + 1);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            this.respondOnEvent = false;
            this.game.soundManager.play("iconClick");
            this.game.delay(1000, "game.changeCurrentScreen(game.regScreen)");
        }
    }
}

