/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.RewardSprite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Random;

public class RewardScreen
extends Screen {
    public Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    private int reward_id = 0;
    public RewardSprite rewardSprite;
    private Random randomNumber;
    public static final int NUMBER_POSS_REWARDS = 7;

    public RewardScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[1];
        this.backgroundImageFiles[0] = game.themeVars.rewardScreenBkgrd;
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.backgroundSoundtrack = "rewardMusic";
        this.randomNumber = new Random(System.currentTimeMillis());
        this.hasAnimations = true;
    }

    @Override
    public void load() {
        super.load();
        this.pickReward();
        this.animationList.add(this.rewardSprite);
        this.rewardSprite.setActive(true);
        this.rewardSprite.setVisible(true);
        this.loadingEnd();
    }

    public void pickReward() {
        int rewardChosen = this.game.dataFileHandler.currentStudent.getNextRewardEasy(this.game.getTheme());
        String[] rewardFiles = new String[2];
        if (rewardChosen == 0) {
            rewardFiles = this.game.themeVars.reward1;
        } else if (rewardChosen == 1) {
            rewardFiles = this.game.themeVars.reward2;
        } else if (rewardChosen == 2) {
            rewardFiles = this.game.themeVars.reward3;
        } else if (rewardChosen == 3) {
            rewardFiles = this.game.themeVars.reward4;
        } else if (rewardChosen == 4) {
            rewardFiles = this.game.themeVars.reward5;
        } else if (rewardChosen == 5) {
            rewardFiles = this.game.themeVars.reward6;
        } else if (rewardChosen == 6) {
            rewardFiles = this.game.themeVars.reward7;
        }
        Point rewardLocation = new Point(this.randomNumber.nextInt(400) + 250, this.randomNumber.nextInt(250) + 350);
        this.rewardSprite = new RewardSprite(this.game, this, rewardLocation, rewardFiles, rewardChosen, 250, 650, 350, 600);
        this.rewardSprite.load();
    }

    @Override
    public void start() {
        this.game.delay(1000, "game.soundManager.play(\"takeReward\")");
        this.game.soundManager.play(this.backgroundSoundtrack, true);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.readyToProcess) {
            AnimatedObject animation = null;
            List list = this.animationList;
            synchronized (list) {
                int i = 0;
                while (i < this.animationList.size()) {
                    animation = (AnimatedObject)this.animationList.get(i);
                    if (animation.isActive()) {
                        animation.animate(this);
                    }
                    ++i;
                }
            }
            this.setRendered(false);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                this.rewardSprite.paint(g2D);
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.backgroundImageFiles[0] = this.game.themeVars.rewardScreenBkgrd;
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.rewardSprite = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            if (this.rewardSprite.isPointInBounds(this.mousePoint)) {
                this.respondOnEvent = false;
                this.game.currentStudent.addReward(this.rewardSprite.getRewardType(), this.game.getTheme());
                this.game.dataFileHandler.saveGame();
                this.game.soundManager.play("iconClick");
                this.game.delay(500, "game.soundManager.stopAllSounds()");
                this.game.delay(1000, "game.changeCurrentScreen(game.rewardViewScreen)");
            }
        }
    }
}

