/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import data.Student;
import graphics.Game;
import graphics.screens.CharacChoiceScreen;
import graphics.screens.Screen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lang.LangVars;

public class RegScreen
extends Screen
implements ActionListener,
ListSelectionListener {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public final Color BUTTON_COLOR = new Color(135, 254, 154);
    public final Color BUTTON_TEXT_COLOR = Color.BLACK;
    private boolean newStudent = false;
    private boolean modifying = false;
    private boolean modified = false;
    private int timesProcessed = 0;
    JLabel titleLabel;
    JLabel lastNameLabel;
    JLabel firstNameLabel;
    JLabel ageLabel;
    JLabel classLabel;
    JLabel sexLabel;
    JLabel startLevelLabel;
    JLabel lastSessionLabel;
    JButton quitButton;
    JButton modifyButton;
    JButton newStudentButton;
    JButton nextSessionButton;
    JButton enterButton;
    JButton cancelButton;
    JButton deleteButton;
    JTextField textFieldLastName;
    JTextField textFieldFirstName;
    JTextField textFieldAge;
    JTextField textFieldClass;
    JTextField textFieldSex;
    JTextField textFieldStartLevel;
    JList studentList;
    JScrollPane studentListScrollPane;
    JInternalFrame messagePane;
    public Vector studentListData;

    public RegScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = false;
        this.hasSounds = false;
        this.createGUIComponents();
    }

    @Override
    public void load() {
        super.load();
        this.studentListData = new Vector();
        this.game.dataFileHandler.createAllStudentList();
        this.loadStudentData();
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.setDataEntryCompntsActive(false);
        this.setSelectionCompntsActive(true);
        this.studentList.setSelectedIndex(0);
        super.start();
    }

    @Override
    public void process() {
        if (this.readyToProcess) {
            ++this.timesProcessed;
            this.setRendered(false);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            this.setRendered(true);
            Graphics2D g2D = (Graphics2D)g;
            if (!this.loading) {
                g2D.setColor(this.DEFAULT_SCREEN_COLOR);
                g2D.fill(this.getBounds());
                this.setPainted(false);
            } else if (this.loading) {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    @Override
    public void unload() {
        this.game.dataFileHandler.saveAllStudentList(this.studentListData);
        super.unload();
        this.game.soundManager.stopAllSounds();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.studentList) {
            this.transferSelectedStudentInfo();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quitButton) {
            this.game.endGame();
        } else if (e.getSource() == this.modifyButton) {
            if (this.studentList.getSelectedValue() != null) {
                this.modifying = true;
                this.setDataEntryCompntsActive(true);
                this.setSelectionCompntsActive(false);
            } else {
                Object[] options = new Object[]{"OK"};
                final JOptionPane optionPane = new JOptionPane("Bisogna selezionare un giocatore per modificare i dati", 0, -1, null, options);
                this.messagePane = new JInternalFrame("", true, false);
                this.messagePane.setContentPane(optionPane);
                this.messagePane.pack();
                this.add((Component)this.messagePane, 0);
                this.messagePane.setVisible(true);
                this.messagePane.setLocation(512, 384);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if (RegScreen.this.messagePane.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                            RegScreen.this.messagePane.setVisible(false);
                            RegScreen.this.game.regScreen.remove(RegScreen.this.messagePane);
                        }
                    }
                });
            }
        } else if (e.getSource() == this.newStudentButton) {
            this.studentList.clearSelection();
            this.newStudent = true;
            this.setDataEntryCompntsActive(true);
            this.setSelectionCompntsActive(false);
            this.textFieldStartLevel.setText("1");
        } else if (e.getSource() == this.nextSessionButton) {
            Student tmpStudent = (Student)this.studentList.getSelectedValue();
            if (tmpStudent != null) {
                this.studentListData.set(this.studentList.getSelectedIndex(), tmpStudent);
                this.game.dataFileHandler.setStudent(tmpStudent);
                this.game.delay(1000, "game.changeCurrentScreen(game.themeChoiceScreen)");
            } else {
                Object[] options = new Object[]{"OK"};
                final JOptionPane optionPane = new JOptionPane("Bisogna selezionare un giocatore per iniziare la sessione di gioco", 0, -1, null, options);
                this.messagePane = new JInternalFrame("", true, false);
                this.messagePane.setContentPane(optionPane);
                this.messagePane.pack();
                this.add((Component)this.messagePane, 0);
                this.messagePane.setVisible(true);
                this.messagePane.setLocation(512, 384);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if (RegScreen.this.messagePane.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                            RegScreen.this.messagePane.setVisible(false);
                            RegScreen.this.game.regScreen.remove(RegScreen.this.messagePane);
                        }
                    }
                });
            }
        } else if (e.getSource() == this.enterButton) {
            boolean allInfoEntered = true;
            if (this.textFieldLastName.getText() == "") {
                allInfoEntered = false;
            } else if (this.textFieldFirstName.getText() == "") {
                allInfoEntered = false;
            } else if (this.textFieldAge.getText() == "") {
                allInfoEntered = false;
            } else if (this.textFieldClass.getText() == "") {
                allInfoEntered = false;
            } else if (this.textFieldSex.getText() == "") {
                allInfoEntered = false;
            } else if (this.newStudent & this.textFieldStartLevel.getText() == "") {
                allInfoEntered = false;
            } else if (this.newStudent & (Integer.parseInt(this.textFieldStartLevel.getText()) <= 0 | Integer.parseInt(this.textFieldStartLevel.getText()) >= 15)) {
                allInfoEntered = false;
            }
            if (!allInfoEntered) {
                Object[] options = new Object[]{"OK"};
                final JOptionPane optionPane = new JOptionPane("Riempire tutti i campi richiesti per procedere. Verificare il livello di partenza.", 0, -1, null, options);
                this.messagePane = new JInternalFrame("", true, false);
                this.messagePane.setContentPane(optionPane);
                this.messagePane.pack();
                this.add((Component)this.messagePane, 0);
                this.messagePane.setVisible(true);
                this.messagePane.setLocation(512, 384);
                optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        String prop = e.getPropertyName();
                        if (RegScreen.this.messagePane.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                            RegScreen.this.messagePane.setVisible(false);
                            RegScreen.this.game.regScreen.remove(RegScreen.this.messagePane);
                        }
                    }
                });
            } else {
                Student tmpStudent;
                boolean duplicateStudentExists = false;
                String lastName = this.textFieldLastName.getText();
                String firstName = this.textFieldFirstName.getText();
                int i = 0;
                while (i < this.studentListData.size()) {
                    tmpStudent = (Student)this.studentListData.elementAt(i);
                    if (tmpStudent.getLastName().matches(lastName) & tmpStudent.getFirstName().matches(firstName)) {
                        duplicateStudentExists = true;
                    }
                    ++i;
                }
                if (duplicateStudentExists) {
                    Object[] options = new Object[]{"OK"};
                    final JOptionPane optionPane = new JOptionPane("Esistono gi\u00e0 dei dati per questo giocatore", 0, -1, null, options);
                    this.messagePane = new JInternalFrame("", true, false);
                    this.messagePane.setContentPane(optionPane);
                    this.messagePane.pack();
                    this.add((Component)this.messagePane, 0);
                    this.messagePane.setVisible(true);
                    this.messagePane.setLocation(512, 384);
                    optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            String prop = e.getPropertyName();
                            if (RegScreen.this.messagePane.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                                RegScreen.this.messagePane.setVisible(false);
                                RegScreen.this.game.regScreen.remove(RegScreen.this.messagePane);
                            }
                        }
                    });
                } else {
                    if (this.modifying) {
                        tmpStudent = (Student)this.studentList.getSelectedValue();
                        tmpStudent.setLastName(this.textFieldLastName.getText());
                        tmpStudent.setfirstName(this.textFieldFirstName.getText());
                        tmpStudent.setAge(Integer.parseInt(this.textFieldAge.getText()));
                        tmpStudent.setClassLevel(this.textFieldClass.getText());
                        tmpStudent.setSex(this.textFieldSex.getText());
                        this.studentListData.set(this.studentList.getSelectedIndex(), tmpStudent);
                    } else {
                        boolean[][] characAccess = new boolean[][]{CharacChoiceScreen.DEFAULT_ACCESS_PARAMS, CharacChoiceScreen.DEFAULT_ACCESS_PARAMS};
                        Student newStudent = new Student(this.studentListData.size() + 1, this.textFieldLastName.getText(), this.textFieldFirstName.getText(), Integer.parseInt(this.textFieldAge.getText()), this.textFieldClass.getText(), this.textFieldSex.getText(), Integer.parseInt(this.textFieldStartLevel.getText()), 0, 0, 0, characAccess, new byte[2][7]);
                        this.studentListData.add(newStudent);
                        this.studentList.setListData(this.studentListData);
                    }
                    this.game.dataFileHandler.saveAllStudentList(this.studentListData);
                    this.modifying = false;
                    this.setDataEntryCompntsActive(false);
                    this.setSelectionCompntsActive(true);
                }
            }
        } else if (e.getSource() == this.cancelButton) {
            this.modifying = false;
            this.setDataEntryCompntsActive(false);
            this.setSelectionCompntsActive(true);
        } else if (e.getSource() == this.deleteButton) {
            Object[] options = LangVars.REG_YES_NO_OPTIONS;
            final JOptionPane optionPane = new JOptionPane("Sei sicuro di voler eliminare questo giocatore?", 2, -1, null, options, options[0]);
            this.messagePane = new JInternalFrame("", true, false);
            this.messagePane.setContentPane(optionPane);
            this.messagePane.pack();
            this.add((Component)this.messagePane, 0);
            this.messagePane.setVisible(true);
            this.messagePane.setLocation(512, 384);
            optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (RegScreen.this.messagePane.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                        String value = (String)optionPane.getValue();
                        if (value == LangVars.REG_YES_NO_OPTIONS[1]) {
                            RegScreen.this.studentListData.remove(RegScreen.this.studentList.getSelectedValue());
                            RegScreen.this.modifying = false;
                            RegScreen.this.setDataEntryCompntsActive(false);
                            RegScreen.this.setSelectionCompntsActive(true);
                        } else {
                            String cfr_ignored_0 = LangVars.REG_YES_NO_OPTIONS[0];
                        }
                        RegScreen.this.messagePane.setVisible(false);
                        RegScreen.this.game.regScreen.remove(RegScreen.this.messagePane);
                    }
                }
            });
        }
    }

    private void setDataEntryCompntsActive(boolean active) {
        if (!active) {
            this.textFieldLastName.setEditable(false);
            this.textFieldFirstName.setEditable(false);
            this.textFieldAge.setEditable(false);
            this.textFieldClass.setEditable(false);
            this.textFieldSex.setEditable(false);
            this.textFieldStartLevel.setEditable(false);
            this.enterButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.textFieldLastName.setText("");
            this.textFieldFirstName.setText("");
            this.textFieldAge.setText("");
            this.lastSessionLabel.setText("Ultima sessione:");
            this.textFieldClass.setText("");
            this.textFieldSex.setText("");
            this.textFieldStartLevel.setText("");
        } else {
            this.modified = false;
            this.textFieldLastName.setEditable(true);
            this.textFieldFirstName.setEditable(true);
            this.textFieldAge.setEditable(true);
            this.textFieldClass.setEditable(true);
            this.textFieldSex.setEditable(true);
            if (this.newStudent) {
                this.textFieldStartLevel.setEditable(true);
            }
            this.enterButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void setSelectionCompntsActive(boolean active) {
        if (!active) {
            this.studentList.setEnabled(false);
            this.quitButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.newStudentButton.setEnabled(false);
            this.nextSessionButton.setEnabled(false);
        } else {
            this.studentList.setEnabled(true);
            this.quitButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.newStudentButton.setEnabled(true);
            this.nextSessionButton.setEnabled(true);
        }
    }

    private void transferSelectedStudentInfo() {
        if (this.studentList.getSelectedValue() != null) {
            this.textFieldLastName.setText(((Student)this.studentList.getSelectedValue()).getLastName());
            this.textFieldFirstName.setText(((Student)this.studentList.getSelectedValue()).getFirstName());
            this.textFieldAge.setText(Integer.toString(((Student)this.studentList.getSelectedValue()).getAge()));
            this.textFieldClass.setText(((Student)this.studentList.getSelectedValue()).getClassLevel());
            this.textFieldSex.setText(((Student)this.studentList.getSelectedValue()).getSex());
            this.textFieldStartLevel.setText(((Student)this.studentList.getSelectedValue()).getStartLevelStr());
            this.lastSessionLabel.setText("Ultima sessione:" + ((Student)this.studentList.getSelectedValue()).getSessionNumber());
        } else {
            this.textFieldLastName.setText("");
            this.textFieldFirstName.setText("");
            this.textFieldAge.setText("");
            this.textFieldClass.setText("");
            this.textFieldSex.setText("");
            this.textFieldStartLevel.setText("");
        }
    }

    private boolean loadStudentData() {
        this.game.dataFileHandler.loadAllStudentList(this.studentListData);
        if (this.studentList != null) {
            this.studentList.setListData(this.studentListData);
        }
        return true;
    }

    @Override
    public boolean isFocusOwner() {
        boolean focusOwner = false;
        if (this.readyToProcess) {
            if (this.textFieldLastName.isFocusOwner()) {
                focusOwner = true;
            } else if (this.textFieldFirstName.isFocusOwner()) {
                focusOwner = true;
            } else if (this.textFieldAge.isFocusOwner()) {
                focusOwner = true;
            } else if (this.textFieldClass.isFocusOwner()) {
                focusOwner = true;
            } else if (this.textFieldSex.isFocusOwner()) {
                focusOwner = true;
            } else if (this.textFieldStartLevel.isFocusOwner()) {
                focusOwner = true;
            } else if (this.studentListScrollPane.isFocusOwner()) {
                focusOwner = true;
            }
        }
        return true;
    }

    private boolean createGUIComponents() {
        this.titleLabel = new JLabel("Seleziona un giocatore...");
        this.titleLabel.setFont(this.game.themeVars.regScreenTitleFont);
        this.titleLabel.setSize(832, 64);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setLocation(512 - this.titleLabel.getWidth() / 2, 64 - this.titleLabel.getHeight() / 2);
        this.add(this.titleLabel);
        this.lastNameLabel = new JLabel("Cognome:");
        this.lastNameLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.lastNameLabel.setSize(128, 32);
        this.lastNameLabel.setHorizontalAlignment(2);
        this.lastNameLabel.setLocation(512, 128);
        this.add(this.lastNameLabel);
        this.firstNameLabel = new JLabel("Nome:");
        this.firstNameLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.firstNameLabel.setSize(128, 32);
        this.firstNameLabel.setHorizontalAlignment(2);
        this.firstNameLabel.setLocation(512, 178);
        this.add(this.firstNameLabel);
        this.ageLabel = new JLabel("Et\u00e0 (anni):");
        this.ageLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.ageLabel.setSize(128, 32);
        this.ageLabel.setHorizontalAlignment(2);
        this.ageLabel.setLocation(512, 228);
        this.add(this.ageLabel);
        this.classLabel = new JLabel("Classe:");
        this.classLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.classLabel.setSize(128, 32);
        this.classLabel.setHorizontalAlignment(2);
        this.classLabel.setLocation(512, 278);
        this.add(this.classLabel);
        this.sexLabel = new JLabel("Mas/Fem:");
        this.sexLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.sexLabel.setSize(128, 32);
        this.sexLabel.setHorizontalAlignment(2);
        this.sexLabel.setLocation(512, 328);
        this.add(this.sexLabel);
        this.startLevelLabel = new JLabel("Livello di partenza (1-14):");
        this.startLevelLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.startLevelLabel.setSize(256, 32);
        this.startLevelLabel.setHorizontalAlignment(2);
        this.startLevelLabel.setLocation(512, 378);
        this.add(this.startLevelLabel);
        this.lastSessionLabel = new JLabel("Ultima sessione:");
        this.lastSessionLabel.setFont(this.game.themeVars.regScreenTextFont);
        this.lastSessionLabel.setSize(448, 32);
        this.lastSessionLabel.setHorizontalAlignment(2);
        this.lastSessionLabel.setLocation(512, 428);
        this.add(this.lastSessionLabel);
        this.modifyButton = new JButton("Modifica");
        this.modifyButton.setFont(this.game.themeVars.buttonTextFont);
        this.modifyButton.setBackground(new Color(135, 254, 154));
        this.modifyButton.setForeground(Color.BLACK);
        this.modifyButton.setLocation(96, 544);
        this.modifyButton.setSize(160, 64);
        this.modifyButton.addActionListener(this);
        this.add(this.modifyButton);
        this.nextSessionButton = new JButton("Inizia");
        this.nextSessionButton.setFont(this.game.themeVars.buttonTextFont);
        this.nextSessionButton.setBackground(this.BUTTON_COLOR);
        this.nextSessionButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.nextSessionButton.setLocation(288, 544);
        this.nextSessionButton.setSize(160, 64);
        this.nextSessionButton.addActionListener(this);
        this.add(this.nextSessionButton);
        this.quitButton = new JButton("Esci");
        this.quitButton.setFont(this.game.themeVars.buttonTextFont);
        this.quitButton.setBackground(this.BUTTON_COLOR);
        this.quitButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.quitButton.setLocation(96, 640);
        this.quitButton.setSize(160, 64);
        this.quitButton.addActionListener(this);
        this.add(this.quitButton);
        this.newStudentButton = new JButton("Nuovo Giocatore");
        this.newStudentButton.setFont(this.game.themeVars.buttonTextFont);
        this.newStudentButton.setBackground(this.BUTTON_COLOR);
        this.newStudentButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.newStudentButton.setLocation(288, 640);
        this.newStudentButton.setSize(160, 64);
        this.newStudentButton.addActionListener(this);
        this.add(this.newStudentButton);
        this.enterButton = new JButton("Salva");
        this.enterButton.setFont(this.game.themeVars.buttonTextFont);
        this.enterButton.setBackground(this.BUTTON_COLOR);
        this.enterButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.enterButton.setLocation(512, 544);
        this.enterButton.setSize(160, 64);
        this.enterButton.addActionListener(this);
        this.enterButton.setEnabled(false);
        this.add(this.enterButton);
        this.cancelButton = new JButton("Annulla");
        this.cancelButton.setFont(this.game.themeVars.buttonTextFont);
        this.cancelButton.setBackground(this.BUTTON_COLOR);
        this.cancelButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.cancelButton.setLocation(512, 640);
        this.cancelButton.setSize(160, 64);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(false);
        this.add(this.cancelButton);
        this.deleteButton = new JButton("Cancella");
        this.deleteButton.setFont(this.game.themeVars.buttonTextFont);
        this.deleteButton.setBackground(this.BUTTON_COLOR);
        this.deleteButton.setForeground(this.BUTTON_TEXT_COLOR);
        this.deleteButton.setLocation(768, 544);
        this.deleteButton.setSize(160, 64);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.add(this.deleteButton);
        this.textFieldLastName = new JTextField(20);
        this.textFieldLastName.setLocation(608, 128);
        this.textFieldLastName.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldLastName.setSize(320, 32);
        this.textFieldLastName.addKeyListener(this);
        this.textFieldLastName.setEditable(false);
        this.add(this.textFieldLastName);
        this.textFieldFirstName = new JTextField(20);
        this.textFieldFirstName.setLocation(608, 178);
        this.textFieldFirstName.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldFirstName.setSize(320, 32);
        this.textFieldFirstName.addKeyListener(this);
        this.textFieldFirstName.setEditable(false);
        this.add(this.textFieldFirstName);
        this.textFieldAge = new JTextField(3);
        this.textFieldAge.setLocation(608, 228);
        this.textFieldAge.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldAge.setSize(320, 32);
        this.textFieldAge.addKeyListener(this);
        this.textFieldAge.setEditable(false);
        this.add(this.textFieldAge);
        this.textFieldClass = new JTextField(10);
        this.textFieldClass.setLocation(608, 278);
        this.textFieldClass.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldClass.setSize(320, 32);
        this.textFieldClass.addActionListener(this);
        this.textFieldClass.setEditable(false);
        this.add(this.textFieldClass);
        this.textFieldSex = new JTextField(10);
        this.textFieldSex.setLocation(608, 328);
        this.textFieldSex.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldSex.setSize(320, 32);
        this.textFieldSex.addActionListener(this);
        this.textFieldSex.setEditable(false);
        this.add(this.textFieldSex);
        this.textFieldStartLevel = new JTextField(2);
        this.textFieldStartLevel.setLocation(736, 378);
        this.textFieldStartLevel.setFont(this.game.themeVars.regScreenTextFont);
        this.textFieldStartLevel.setSize(192, 32);
        this.textFieldStartLevel.addActionListener(this);
        this.textFieldStartLevel.setEditable(false);
        this.add(this.textFieldStartLevel);
        this.studentList = new JList();
        this.studentList.setBounds(96, 128, 352, 384);
        this.studentList.setFont(this.game.themeVars.regScreenTextFont);
        this.studentList.addListSelectionListener(this);
        this.studentList.setListData(this.studentListData);
        this.studentListScrollPane = new JScrollPane(20, 31);
        this.studentListScrollPane.setBounds(96, 128, 352, 384);
        this.studentListScrollPane.add(this.studentList);
        this.studentListScrollPane.setViewportView(this.studentList);
        this.add(this.studentListScrollPane);
        return true;
    }

    private void destroyGUIComponents() {
        this.studentList = null;
        this.titleLabel = null;
        this.lastNameLabel = null;
        this.firstNameLabel = null;
        this.ageLabel = null;
        this.classLabel = null;
        this.sexLabel = null;
        this.startLevelLabel = null;
        this.lastSessionLabel = null;
        this.modifyButton = null;
        this.nextSessionButton = null;
        this.quitButton = null;
        this.newStudentButton = null;
        this.enterButton = null;
        this.cancelButton = null;
        this.deleteButton = null;
        this.textFieldLastName = null;
        this.textFieldFirstName = null;
        this.textFieldAge = null;
        this.textFieldClass = null;
        this.textFieldSex = null;
        this.textFieldStartLevel = null;
        this.studentList = null;
        this.studentListData = null;
        this.studentListScrollPane = null;
        this.messagePane = null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (this.respondOnEvent) {
            switch (e.getID()) {
                case 401: {
                    char responseValue = e.getKeyChar();
                    if (e.getSource() == this.textFieldLastName) {
                        this.modified = true;
                        break;
                    }
                    if (e.getSource() == this.textFieldFirstName) {
                        this.modified = true;
                        break;
                    }
                    if (e.getSource() == this.textFieldAge) {
                        this.modified = true;
                        break;
                    }
                    if (e.getSource() == this.textFieldClass) {
                        this.modified = true;
                        break;
                    }
                    if (e.getSource() == this.textFieldSex) {
                        this.modified = true;
                        break;
                    }
                    if (e.getSource() != this.textFieldStartLevel) break;
                    this.modified = true;
                    break;
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

