/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.others.GifButton;
import graphics.screens.Screen;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class InstrucScreen
extends Screen {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public boolean timeToSwitchImage = false;
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    public GifButton screenSwitchButton;

    public InstrucScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[2];
        this.backgroundImageFiles[0] = game.themeVars.instrucScreenBackground;
        this.backgroundImageFiles[1] = game.themeVars.instrucScreenInstrucs;
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.backgroundSoundtrack = "background2";
        String[] fileNames = new String[]{game.themeVars.screenSwitchButton, game.themeVars.screenSwitchButton};
        this.screenSwitchButton = new GifButton((Screen)this, new Point(314, 674), fileNames);
    }

    @Override
    public void load() {
        super.load();
        this.screenSwitchButton.load();
        this.loadingEnd();
    }

    @Override
    public void unload() {
        super.unload();
        this.screenSwitchButton.unload();
    }

    @Override
    public void start() {
        this.game.soundManager.stopAllSounds();
        if (this.game.getTheme() == 0) {
            this.game.delay(2500, "game.soundManager.play(\"instrucsUnderwater\")");
        } else if (this.game.getTheme() == 1) {
            this.game.delay(2500, "game.soundManager.play(\"instrucsJungle\")");
        }
        this.game.delay(2500, "game.instrucScreen.timeToSwitchImage=true");
        if (this.backgroundSoundtrack != null) {
            this.game.soundManager.play(this.backgroundSoundtrack, true);
        }
        super.start();
    }

    @Override
    public void process() {
        if (this.readyToProcess && this.timeToSwitchImage) {
            this.timeToSwitchImage = false;
            this.setCurrentBgImage(this.currentBackgroundImage + 1);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                this.screenSwitchButton.paint(g2D);
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.backgroundImageFiles[0] = this.game.themeVars.instrucScreenBackground;
        this.backgroundImageFiles[1] = this.game.themeVars.instrucScreenInstrucs;
        String[] fileNames = new String[]{this.game.themeVars.screenSwitchButton, this.game.themeVars.screenSwitchButton};
        this.screenSwitchButton = new GifButton((Screen)this, new Point(314, 674), fileNames);
        this.setRendered(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            this.respondOnEvent = false;
            this.game.soundManager.stopAllSounds();
            this.game.removeTasksFromList("soundManager");
            this.screenSwitchButton.selected();
            this.game.delay(1000, "game.changeCurrentScreen(game.characChoiceScreen)");
        }
    }
}

