/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.screens.Screen;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;

public class GameMenuScreen
extends Screen
implements ActionListener {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    Screen originScreen;
    private JLabel titleLabel;
    private JLabel explnLabel;
    private JButton exitSessionButton;
    private JButton exitProgramButton;
    private JButton returnToGameButton;
    private int timesProcessed = 0;

    public GameMenuScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.initializeGUIObjects();
    }

    @Override
    public void load() {
        super.load();
        this.loadingEnd();
    }

    @Override
    public void process() {
        if (this.readyToProcess) {
            ++this.timesProcessed;
            this.setRendered(false);
            this.setPainted(false);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            this.setRendered(true);
            Graphics2D g2D = (Graphics2D)g;
            if (!this.loading) {
                g2D.setColor(this.DEFAULT_SCREEN_COLOR);
                g2D.fill(this.getBounds());
                this.setPainted(false);
            } else if (this.loading) {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
    }

    public void setOriginScreen(Screen originScreen) {
        this.originScreen = originScreen;
    }

    public Screen getOriginScreen() {
        return this.originScreen;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exitSessionButton) {
            this.game.dataFileHandler.exitStudent();
            this.game.unpauseGame();
            this.game.choiceScreen.ncm.endGame();
        } else if (e.getSource() == this.exitProgramButton) {
            this.game.dataFileHandler.saveGame();
            this.game.endGame();
        } else if (e.getSource() == this.returnToGameButton) {
            this.game.returnFromMenu();
        }
    }

    private void initializeGUIObjects() {
        this.titleLabel = new JLabel("MENU");
        this.titleLabel.setFont(new Font("Arial Black", 1, 24));
        this.titleLabel.setSize(300, 25);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setLocation(362, 73);
        this.add(this.titleLabel);
        this.explnLabel = new JLabel("Scegli un'opzione");
        this.explnLabel.setFont(new Font("Arial", 2, 20));
        this.explnLabel.setSize(300, 25);
        this.explnLabel.setHorizontalAlignment(0);
        this.explnLabel.setLocation(362, 116);
        this.add(this.explnLabel);
        this.exitSessionButton = new JButton("Cambio giocatore");
        this.exitSessionButton.setFont(new Font("Arial", 0, 20));
        this.exitSessionButton.setBackground(Color.YELLOW);
        this.exitSessionButton.setForeground(Color.BLACK);
        this.exitSessionButton.setSize(150, 25);
        this.exitSessionButton.setSize(this.exitSessionButton.getPreferredSize());
        this.exitSessionButton.setLocation(512 - this.exitSessionButton.getWidth() / 2, 256 - this.exitSessionButton.getHeight() / 2);
        this.exitSessionButton.addActionListener(this);
        this.add(this.exitSessionButton);
        this.exitProgramButton = new JButton("Uscire dal gioco");
        this.exitProgramButton.setFont(new Font("Arial", 0, 20));
        this.exitProgramButton.setBackground(Color.YELLOW);
        this.exitProgramButton.setForeground(Color.BLACK);
        this.exitProgramButton.setSize(150, 25);
        this.exitProgramButton.setSize(this.exitProgramButton.getPreferredSize());
        this.exitProgramButton.setLocation(512 - this.exitProgramButton.getWidth() / 2, 384 - this.exitProgramButton.getHeight() / 2);
        this.exitProgramButton.addActionListener(this);
        this.add(this.exitProgramButton);
        this.returnToGameButton = new JButton("Tornare al gioco");
        this.returnToGameButton.setFont(new Font("Arial", 0, 20));
        this.returnToGameButton.setBackground(Color.YELLOW);
        this.returnToGameButton.setForeground(Color.BLACK);
        this.returnToGameButton.setSize(150, 25);
        this.returnToGameButton.setSize(this.returnToGameButton.getPreferredSize());
        this.returnToGameButton.setLocation(512 - this.returnToGameButton.getWidth() / 2, 512 - this.returnToGameButton.getHeight() / 2);
        this.returnToGameButton.addActionListener(this);
        this.add(this.returnToGameButton);
    }

    private void destroyGUIComponents() {
        this.titleLabel = null;
        this.explnLabel = null;
        this.exitSessionButton = null;
        this.exitProgramButton = null;
        this.returnToGameButton = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

