/*
 * Decompiled with CFR 0.152.
 */
package graphics.others;

import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import util.ImageFactory;
import util.Utilities;

public class NumberBoard
extends AnimatedObject {
    private BoardScreen boardScreen;
    private int x;
    private int y;
    private int width;
    private int height;
    private Image onscreenBoardImage;
    public static final int ROW_LENGTH = 10;
    public static final int NUM_ROWS = 4;
    public static final int LAST_SQUARE = 40;
    private double squareWidth;
    private double halfSquareWidth;
    private int lineWidth;
    private int arrowSize;
    private int interLineDist;
    private int insideOffset;
    private boolean numbersVisible = false;
    private boolean squareFlashing = false;
    private BufferedImage squareImage;
    private Point squareFlashingLocation;
    private boolean squareOn = false;
    private int numSquareFlashing = 0;
    private int numAnimationCycles = 3;
    private int animationCycleCount = 0;
    private int animationCycleDelay = 300;
    private Color primaryLineColor;
    private Font numberFont;
    private Color numberColor;
    private String[] lblNumbers;
    private int squareResponse = 0;

    public NumberBoard(BoardScreen boardScreen, ChoiceScreen choiceScreen, int x, int y, int width, int height, int squareWidth, int lineWidth, int arrowSize, int interLineDist) {
        this.boardScreen = boardScreen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.squareWidth = squareWidth;
        this.halfSquareWidth = squareWidth >> 1;
        this.lineWidth = lineWidth;
        this.arrowSize = arrowSize;
        this.interLineDist = interLineDist;
        this.insideOffset = width - squareWidth * 10 >> 1;
        this.setVisible(false);
        this.setActive(false);
        this.lblNumbers = new String[40];
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.onscreenBoardImage, this.x, this.y, null);
            if (this.squareFlashing && this.squareOn) {
                g.drawImage((Image)this.squareImage, this.x + 100 + this.squareFlashingLocation.x, this.y + 100 + this.squareFlashingLocation.y, null);
            }
        }
    }

    @Override
    public void load() {
        this.onscreenBoardImage = new BufferedImage(this.width, this.height, 1);
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        this.onscreenBoardImage = null;
        this.squareImage = null;
    }

    protected void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
            Graphics2D g2D = (Graphics2D)this.onscreenBoardImage.getGraphics();
            g2D.setColor(this.boardScreen.game.themeVars.screenColor);
            g2D.fillRect(0, 0, this.width, this.height);
            g2D.setStroke(new BasicStroke(this.lineWidth));
            GeneralPath p = new GeneralPath(1);
            int rightSide = this.width - this.insideOffset;
            int[] xPolyPoints = new int[]{this.insideOffset, rightSide, rightSide + this.arrowSize, rightSide, this.insideOffset, this.insideOffset + this.arrowSize, this.insideOffset};
            int y = 0;
            while (y < 4) {
                int nextY = y + 1;
                double squareWidthY = this.squareWidth * (double)y;
                int interLineDistNextY = this.interLineDist * nextY;
                int yPolyOne = (int)((double)interLineDistNextY + squareWidthY);
                int yPolyTwo = (int)((double)interLineDistNextY + this.squareWidth * ((double)y + 0.5));
                int yPolyThree = (int)((double)interLineDistNextY + this.squareWidth * (double)nextY);
                int[] yPolyPoints = new int[]{yPolyOne, yPolyOne, yPolyTwo, yPolyThree, yPolyThree, yPolyTwo, yPolyOne};
                g2D.setColor(this.boardScreen.game.themeVars.boardColor);
                g2D.fillPolygon(xPolyPoints, yPolyPoints, 7);
                g2D.setColor(this.boardScreen.game.themeVars.boardLineColor);
                g2D.drawPolygon(xPolyPoints, yPolyPoints, 7);
                g2D.setColor(this.boardScreen.game.themeVars.boardLineColor);
                float starty = (float)yPolyOne + 1.0f;
                float lineToY1 = (float)((double)yPolyOne + this.halfSquareWidth);
                float lineToY2 = (float)((double)yPolyOne + this.squareWidth - 2.0);
                int x = 0;
                while (x < 11) {
                    float startx = (float)((double)this.insideOffset + (double)x * this.squareWidth);
                    p.moveTo(startx, starty);
                    p.lineTo(startx + (float)this.arrowSize, lineToY1);
                    p.lineTo(startx, lineToY2);
                    ++x;
                }
                g2D.draw(p);
                ++y;
            }
            if (this.numbersVisible) {
                g2D.setFont(this.boardScreen.game.themeVars.boardNumberFont);
                g2D.setColor(this.numberColor);
                int y2 = 0;
                while (y2 < 4) {
                    int x = 0;
                    while (x < 10) {
                        int i = y2 * 10 + (x + 1);
                        this.lblNumbers[i - 1] = String.valueOf(i);
                        Utilities.drawFromPoint(this.lblNumbers[i - 1], (int)((double)this.insideOffset + this.halfSquareWidth + (double)this.arrowSize + this.squareWidth * (double)x), (int)(this.halfSquareWidth + (double)(this.interLineDist * (y2 + 1)) + this.squareWidth * (double)y2), 0, 0, g2D);
                        ++x;
                    }
                    ++y2;
                }
            }
            BufferedImage startImage = ImageFactory.getCompatibleImage(this.boardScreen.game.themeVars.startMarker, this.boardScreen.gc, 2);
            g2D.drawImage(startImage, 50 - startImage.getWidth() / 2, 55 - (startImage.getHeight() >> 1), startImage.getWidth(), startImage.getHeight(), null);
            BufferedImage finishImage = ImageFactory.getCompatibleImage(this.boardScreen.game.themeVars.finishMarker, this.boardScreen.gc, 2);
            g2D.drawImage(finishImage, 910 - finishImage.getWidth() / 2, 460 - (finishImage.getHeight() >> 1), finishImage.getWidth(), finishImage.getHeight(), null);
            g2D.dispose();
        }
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    public void flashSquare(int squareNumber) {
    }

    public void getScreenPointforSquare(int square, Point location) {
        int modSquare = square % 10;
        if (modSquare == 0) {
            modSquare = 10;
        }
        location.setLocation((double)(this.x + this.arrowSize + this.insideOffset) + this.halfSquareWidth + this.squareWidth * (double)(modSquare - 1), (double)(this.y + this.interLineDist) + this.halfSquareWidth + ((double)this.interLineDist + this.squareWidth) * (double)((square - modSquare) / 10));
    }

    public void getBoardPointforSquare(int square, Point location) {
        int modSquare = square % 10;
        if (modSquare == 0) {
            modSquare = 10;
        }
        location.setLocation((double)(this.arrowSize + this.insideOffset) + this.halfSquareWidth + this.squareWidth * (double)(modSquare - 1), (double)this.interLineDist + this.halfSquareWidth + ((double)this.interLineDist + this.squareWidth) * (double)((square - modSquare) / 10));
    }

    public boolean wasSquareClickedOnBoard(Point mousePoint) {
        this.squareResponse = 0;
        mousePoint.x -= this.x;
        mousePoint.y -= this.y;
        if (mousePoint.x <= this.insideOffset || mousePoint.x >= this.width - this.insideOffset + this.arrowSize || mousePoint.y <= this.interLineDist || mousePoint.y >= this.height - this.interLineDist) {
            return false;
        }
        int y = 0;
        while (y < 4) {
            if ((double)mousePoint.y > (double)(this.interLineDist * (y + 1)) + this.squareWidth * (double)y && (double)mousePoint.y < (double)(this.interLineDist * (y + 1)) + this.squareWidth * (double)(y + 1)) {
                int x = 0;
                while (x < 10) {
                    if ((double)mousePoint.x > (double)this.insideOffset + (double)x * this.squareWidth && (double)mousePoint.x < (double)this.insideOffset + (double)(x + 1) * this.squareWidth) {
                        double tempY;
                        double funcofY;
                        double tempX;
                        this.squareResponse = y * 10 + (x + 1);
                        if ((double)mousePoint.x < (double)this.insideOffset + (double)x * this.squareWidth + (double)this.arrowSize && (tempX = (double)mousePoint.x - ((double)this.insideOffset + (double)x * this.squareWidth)) < (funcofY = -1.0 * Math.abs((tempY = (double)mousePoint.y - ((double)(this.interLineDist * (y + 1)) + this.squareWidth * ((double)y + 0.5))) * ((double)(this.arrowSize * 2) / this.squareWidth)) + (double)this.arrowSize) && this.squareResponse % 10 != 0) {
                            --this.squareResponse;
                            return true;
                        }
                        return true;
                    }
                    ++x;
                }
            }
            ++y;
        }
        return false;
    }

    public void setSquareFlashing(boolean state) {
        this.squareFlashing = state;
    }

    public int getSquareClickedOnBoard() {
        return this.squareResponse;
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive() && this.squareFlashing && !this.suspended) {
            this.squareOn = !this.squareOn;
            this.setSuspended(true);
            this.boardScreen.game.delay(this.animationCycleDelay, "boardScreen.numberBoard.setSuspended(false)");
            ++this.animationCycleCount;
            if (this.animationCycleCount >= this.numAnimationCycles * 2) {
                this.setActive(false);
                this.squareFlashing = false;
                this.setSuspended(false);
            }
            this.update();
        }
    }

    public void themeChanged() {
        this.setRendered(false);
        this.update();
    }

    @Override
    public void update() {
        this.boardScreen.setRendered(false);
    }

    public void resetTurn() {
        this.setActive(false);
        this.update();
    }

    public void setNumbersVisible(boolean state) {
        this.numbersVisible = state;
        this.update();
    }

    public boolean isPointInBounds(Point point) {
        return point.x > this.x && point.x < this.x + this.width && point.y > this.y && point.y < this.y + this.height;
    }

    public void setX(int xPos) {
        this.x = xPos;
    }

    public void setY(int yPos) {
        this.y = yPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }

    @Override
    public void setSuspended(boolean state) {
        this.suspended = state;
    }

    @Override
    public boolean getSuspended(boolean state) {
        return this.suspended;
    }
}

