/*
 * Decompiled with CFR 0.152.
 */
package graphics.others;

import graphics.screens.Screen;
import graphics.sprites.GifSprite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public class GifButton
extends GifSprite {
    ActionListener actionListener;

    public GifButton(Screen screen, Point location, String[] fileNames) {
        super(location.x, location.y, fileNames, screen);
        this.setVisible(true);
        this.setActive(false);
        this.setVelocity(0.0f, 0.0f);
    }

    public GifButton(Screen screen, Point location, String fileNames) {
        super(location.x, location.y, fileNames, screen);
        this.setVisible(true);
        this.setActive(false);
        this.setVelocity(0.0f, 0.0f);
    }

    @Override
    public void load() {
        super.load();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        super.unload();
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
    }

    public void selected() {
        this.screen.game.soundManager.play("iconClick");
    }

    @Override
    public void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            g.drawImage(this.images[this.currentImage], (int)(this.getX() - (float)(this.width >> 1)), (int)(this.getY() - (float)(this.height >> 1)), this.getWidth(), this.getHeight(), null);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public void keyPressed(KeyEvent e) {
        this.screen.keyPressed(e);
    }

    public void mouseEntered() {
        this.currentImage = 1;
    }

    public void mouseExited() {
        this.currentImage = 0;
    }

    public void mouseClick() {
        this.currentImage = (byte)2;
    }

    @Override
    public void update() {
    }

    @Override
    public void setImageActive(boolean state) {
    }
}

