/*
 * Decompiled with CFR 0.152.
 */
package graphics.others;

import graphics.Game;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import util.Utilities;

public class DotCarpet
extends AnimatedObject {
    private Game game;
    public ChoiceScreen choiceScreen;
    public BoardScreen boardScreen;
    private int width;
    private int height;
    private int x;
    private int y;
    private Color backgroundColor;
    private Color foregroundColor;
    private int lineWidth = 5;
    private boolean topDigitVisible = false;
    private boolean bottomDigitVisible = false;
    private int topDigit;
    private int bottomDigit;
    private BufferedImage offScreenDotCarpet;
    private Image offScreenPlainCarpet;
    private int fontSize = 40;
    private Font digitFont = new Font("Arial Black", 0, this.fontSize);
    public Point[] topDotStackPoints = new Point[9];
    public Point[] bottomDotStackPoints = new Point[9];
    private Point topDigitPoint;
    private Point bottomDigitPoint;

    public DotCarpet(Game game, ChoiceScreen choiceScreen, BoardScreen boardScreen) {
        this.game = game;
        this.choiceScreen = choiceScreen;
        this.boardScreen = boardScreen;
        this.setWidth(736);
        this.setHeight(192);
        this.setX(144);
        this.setY(32);
        this.calculatePointLocations();
        this.setVisible(true);
    }

    @Override
    public void load() {
        this.offScreenDotCarpet = new BufferedImage(this.width, this.height, 1);
        this.offScreenPlainCarpet = new BufferedImage(this.width, this.height, 1);
        this.createImages();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        this.offScreenDotCarpet = null;
        this.offScreenPlainCarpet = null;
        this.topDotStackPoints = null;
        this.bottomDotStackPoints = null;
    }

    private void createImages() {
        Graphics2D g2D = (Graphics2D)this.offScreenPlainCarpet.getGraphics();
        g2D.setColor(this.game.themeVars.screenColor);
        g2D.fillRect(0, 0, this.width, this.height);
        g2D.setColor(this.game.themeVars.dotCarpetBackColor);
        g2D.fill(new RoundRectangle2D.Double(0.0, 0.0, this.width, this.height, 30.0, 30.0));
        g2D.setColor(this.game.themeVars.dotCarpetForeColor);
        g2D.setStroke(new BasicStroke(this.lineWidth));
        g2D.draw(new RoundRectangle2D.Double(this.lineWidth >> 1, this.lineWidth >> 1, this.width - this.lineWidth, this.height - this.lineWidth, 30.0, 30.0));
        GeneralPath p = new GeneralPath(1);
        int offset = this.lineWidth >> 1;
        p.moveTo(this.width - offset, this.height >> 1);
        p.lineTo(offset, this.height >> 1);
        p.moveTo(this.width - 96, offset);
        p.lineTo(this.width - 96, (float)this.height - (float)offset);
        p.moveTo(96.0f, offset);
        p.lineTo(96.0f, (float)this.height - (float)offset);
        g2D.draw(p);
        g2D.dispose();
    }

    private void calculatePointLocations() {
        int interDotInterval = 54;
        int i = 0;
        while (i < 9) {
            this.topDotStackPoints[i] = new Point((i + 1) * interDotInterval + this.x + 96, 48 + this.y);
            this.bottomDotStackPoints[i] = new Point((i + 1) * interDotInterval + this.x + 96, 144 + this.y);
            ++i;
        }
        this.topDigitPoint = new Point(this.x + 688, this.y + 48);
        this.bottomDigitPoint = new Point(this.x + 688, this.y + 144);
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    @Override
    public void animate(Screen screen) {
    }

    private void render() {
        this.setRendered(true);
        Graphics2D g2D = (Graphics2D)this.offScreenDotCarpet.getGraphics();
        g2D.drawImage(this.offScreenPlainCarpet, 0, 0, null);
        if (this.topDigitVisible || this.bottomDigitVisible) {
            g2D.setColor(this.game.themeVars.dotCarpetTextColor);
            g2D.setFont(this.digitFont);
        }
        if (this.topDigitVisible) {
            Utilities.drawFromPoint(String.valueOf(this.topDigit), 688, 48, 0, 0, g2D);
        }
        if (this.bottomDigitVisible) {
            Utilities.drawFromPoint(String.valueOf(this.bottomDigit), 688, 144, 0, 0, g2D);
        }
        g2D.dispose();
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.offScreenDotCarpet, this.x, this.y, this.width, this.height, null);
        }
    }

    public void setTopDigit(int newDigit) {
        this.topDigit = newDigit;
        this.update();
    }

    public void setBottomDigit(int newDigit) {
        this.bottomDigit = newDigit;
        this.update();
    }

    public void setTopDigitVisible(boolean state) {
        this.topDigitVisible = state;
        this.update();
    }

    public void setBottomDigitVisible(boolean state) {
        this.bottomDigitVisible = state;
        this.update();
    }

    @Override
    public void update() {
        this.setRendered(false);
        this.choiceScreen.setRendered(false);
    }

    public void reset() {
        this.setActive(false);
        this.topDigit = 0;
        this.topDigitVisible = false;
        this.bottomDigit = 0;
        this.bottomDigitVisible = false;
        this.update();
    }

    public void themeChanged() {
        if (this.isReady()) {
            this.createImages();
            this.update();
        }
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setX(int xPos) {
        this.x = xPos;
    }

    public void setY(int yPos) {
        this.y = yPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

