/*
 * Decompiled with CFR 0.152.
 */
package graphics.managers;

import graphics.Game;
import graphics.others.NumberBoard;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.HazardSprite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Random;

public class HazardManager
extends AnimatedObject {
    private Game game;
    private BoardScreen boardScreen;
    private ChoiceScreen choiceScreen;
    private NumberBoard numberBoard;
    private static final int MAX_NUM_HAZARDS = 20;
    private int numHazards;
    private int numHazardsToAdd;
    private int currentHazardLevel;
    private boolean hazardsPresent;
    public String[][] hazardFiles;
    public HazardSprite[] hazards;
    private Random randomNumberGenerator;

    public HazardManager(BoardScreen boardScreen, ChoiceScreen choiceScreen, Game game, NumberBoard numberBoard) {
        this.setActive(false);
        this.choiceScreen = choiceScreen;
        this.boardScreen = boardScreen;
        this.game = game;
        this.numberBoard = numberBoard;
        this.hazardFiles = game.themeVars.hazardGifs;
        this.numHazards = 0;
    }

    @Override
    public void load() {
        this.randomNumberGenerator = new Random();
        this.randomNumberGenerator.setSeed(System.currentTimeMillis());
        this.createHazards();
        int i = 0;
        while (i < 20) {
            this.hazards[i].load();
            ++i;
        }
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.randomNumberGenerator = null;
        this.hazards = null;
        this.setImageActive(false);
        this.setReady(false);
    }

    private void createHazards() {
        this.hazards = new HazardSprite[20];
        int i = 0;
        while (i < 20) {
            this.hazards[i] = new HazardSprite(this.choiceScreen, this.boardScreen, this, 0, new Point(-100, -100), 90.0, 0, (byte)i);
            ++i;
        }
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            this.setImageActive(true);
            int i = 0;
            while (i < 20) {
                boolean suceeded = false;
                while (!(suceeded = this.hazards[i].start())) {
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean checkForCollisions(int player) {
        boolean hit = false;
        int i = 0;
        while (i < this.numHazards) {
            if (this.boardScreen.players[player].getBoardSquare() == this.hazards[i].boardSquare) {
                this.hazards[i].landedOn((byte)player);
                hit = true;
                break;
            }
            ++i;
        }
        return hit;
    }

    public int movementDueToHazard(int boardSquare) {
        int penalty = 0;
        int i = 0;
        while (i < this.numHazards) {
            if (boardSquare == this.hazards[i].boardSquare) {
                penalty = this.hazards[i].getPenaltyValue();
                break;
            }
            ++i;
        }
        return penalty;
    }

    public void setHazardLevel(boolean state) {
        this.hazardsPresent = state;
        if (state) {
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    public void setHazards(boolean rangeRestriction) {
        if (this.hazardsPresent) {
            this.numHazardsToAdd = (byte)Math.ceil(Math.abs(this.randomNumberGenerator.nextGaussian()));
            if (this.numHazardsToAdd > 3) {
                this.numHazardsToAdd = 3;
            }
            if (this.numHazards + this.numHazardsToAdd > 20) {
                this.numHazardsToAdd = 20 - this.numHazards;
            }
            int[] hazardSquares = new int[this.numHazardsToAdd];
            int[] penaltyValues = new int[this.numHazardsToAdd];
            byte[] hazardTypes = new byte[this.numHazardsToAdd];
            int lowSquare = this.boardScreen.players[0].getBoardSquare();
            int highSquare = rangeRestriction ? Math.min(this.boardScreen.players[0].getBoardSquare() + 5, 40) : Math.min(this.boardScreen.players[0].getBoardSquare() + 9, 40);
            int lastSquare = 40;
            int i = 0;
            block0: while (i < this.numHazardsToAdd) {
                int squarePicked;
                boolean squareOkay;
                int passes = 0;
                do {
                    if (this.boardScreen.players[0].getBoardSquare() == lastSquare - 1 && this.boardScreen.players[1].getBoardSquare() == lastSquare - 1) {
                        this.numHazardsToAdd = 0;
                        break block0;
                    }
                    squarePicked = this.randomNumberGenerator.nextInt(highSquare - lowSquare) + lowSquare + 1;
                    squareOkay = true;
                    if (this.boardScreen.players[0].getBoardSquare() == squarePicked || this.boardScreen.players[1].getBoardSquare() == squarePicked) {
                        squareOkay = false;
                    }
                    int j = 0;
                    while (j < i) {
                        if (hazardSquares[j] - 1 <= squarePicked && hazardSquares[j] + 1 >= squarePicked) {
                            squareOkay = false;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < this.numHazards) {
                        if (this.hazards[j].boardSquare - 1 <= squarePicked && this.hazards[j].boardSquare + 1 >= squarePicked) {
                            squareOkay = false;
                        }
                        ++j;
                    }
                    if (squarePicked == lastSquare || squarePicked == 0 || squarePicked == 1 || squarePicked == 2) {
                        squareOkay = false;
                    }
                    passes = (byte)(passes + 1);
                } while (!squareOkay && passes < 3);
                if (!squareOkay) {
                    this.numHazardsToAdd = (byte)i;
                    break;
                }
                hazardSquares[i] = squarePicked;
                ++i;
            }
            if (this.numHazardsToAdd > 0) {
                if (!this.choiceScreen.ncm.getGameBeginning()) {
                    this.game.soundManager.play("watchOutNewTraps");
                }
                i = 0;
                while (i < this.numHazardsToAdd) {
                    penaltyValues[i] = -1 * (this.randomNumberGenerator.nextInt(3) + 1);
                    ++i;
                }
                i = this.numHazards;
                while (i < this.numHazards + this.numHazardsToAdd) {
                    this.hazards[i].setSquare(hazardSquares[i - this.numHazards]);
                    this.hazards[i].setPenaltyValue(penaltyValues[i - this.numHazards]);
                    this.hazards[i].setVisible(true);
                    ++i;
                }
                this.numHazards += this.numHazardsToAdd;
            }
        }
    }

    protected void render() {
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive()) {
            int i = 0;
            while (i < this.numHazards) {
                this.hazards[i].animate(screen);
                ++i;
            }
        }
    }

    @Override
    public void animateImage(Screen screen) {
        int i = 0;
        while (i < this.numHazards) {
            if (this.hazards[i].isImageActive()) {
                this.hazards[i].animateImage(screen);
            }
            ++i;
        }
    }

    public void themeChanged() {
        this.hazardFiles = this.game.themeVars.hazardGifs;
        int i = 0;
        while (i < this.numHazards) {
            this.hazards[i].themeChanged();
            ++i;
        }
        this.update();
    }

    public void resetGame() {
        int i = 0;
        while (i < 20) {
            if (i < this.numHazards) {
                this.hazards[i].reset();
            }
            ++i;
        }
        this.numHazards = 0;
        this.update();
    }

    public void resetTurn() {
    }

    @Override
    public void update() {
        this.boardScreen.setRendered(false);
    }

    @Override
    public void paint(Graphics2D g2D) {
        if (this.isReady()) {
            int i = 0;
            while (i < this.numHazards) {
                if (this.hazards[i].getVisible()) {
                    this.hazards[i].paint(g2D);
                }
                ++i;
            }
        }
    }

    public String getHazardPositionsCommaDelim() {
        String hazPos = new String("");
        int i = 0;
        while (i < 40) {
            boolean hazardPresent = false;
            int hazardValue = 0;
            int j = 0;
            while (j < this.numHazards) {
                if (this.hazards[j].boardSquare == i + 1) {
                    hazardValue = this.hazards[j].getPenaltyValue();
                }
                ++j;
            }
            hazPos = String.valueOf(hazPos) + hazardValue + ",";
            ++i;
        }
        return hazPos;
    }

    public String getHazardHeadersCommaDelim() {
        String hazHeadr = new String("");
        int i = 0;
        while (i < 40) {
            hazHeadr = String.valueOf(hazHeadr) + "hazSq" + (i + 1) + ",";
            ++i;
        }
        return hazHeadr;
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

