/*
 * Decompiled with CFR 0.152.
 */
package graphics.managers;

import algorithms.GameTurn;
import graphics.Game;
import graphics.others.DotContainer;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.DotSprite;
import graphics.sprites.PlayerPiece;
import java.awt.Graphics2D;
import java.awt.Point;
import util.Utilities;

public class DotManager
extends AnimatedObject {
    private Game game;
    private ChoiceScreen choiceScreen;
    private BoardScreen boardScreen;
    private PlayerPiece player;
    public DotContainer dotContainer;
    private DotSprite[] dotList;
    static final byte CHOICE_SCREEN = 0;
    static final byte BOARD_SCREEN = 1;
    static final byte NOWHERE = 0;
    static final byte WHOLE_SCREEN = 1;
    static final byte NOT_MOVING = 0;
    static final byte LINING_UP_ON_CARPET = 1;
    static final byte SUBTRACTING = 2;
    static final byte MOVING_TO_BOARD = 3;
    static final byte CLICKING_TO_BOARD = 4;
    public boolean responseHandled = false;
    private byte drawDotsTo = 0;
    private byte screenDrawingTo = 0;
    private Point dotHeapStartPt;
    private int numberClickedDots;
    private boolean allDotsClicked;
    private int numberDots;
    private int numberToSubtract;
    private int numberRemaining;
    private int numberWithSpace;
    private boolean addition;
    private boolean subtraction;
    private int currentMovingDot;
    public byte movementMode = 0;
    private boolean moveSeveralDotsAtOnce = false;
    private boolean playedName = false;

    public DotManager(Game game, ChoiceScreen choiceScreen, BoardScreen boardScreen, PlayerPiece playingPiece) {
        this.setActive(false);
        this.game = game;
        this.choiceScreen = choiceScreen;
        this.boardScreen = boardScreen;
        this.player = playingPiece;
    }

    @Override
    public void load() {
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            this.playedName = false;
            this.drawDotsTo = 1;
            this.dotContainer.mainDotArray.setDrawDotsToDotArray(false);
            this.dotContainer.subDotArrays[0].setDrawDotsToDotArray(false);
            this.dotContainer.subDotArrays[1].setDrawDotsToDotArray(false);
            this.dotContainer.update();
            return true;
        }
        return false;
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }

    @Override
    public void animate(Screen screen) {
        if (this.isActive()) {
            if (this.moveSeveralDotsAtOnce) {
                int i;
                if (this.screenDrawingTo == 0) {
                    i = 0;
                    while (i < this.numberDots) {
                        this.dotList[i].animate(this.choiceScreen);
                        ++i;
                    }
                } else if (this.screenDrawingTo == 1) {
                    i = 0;
                    while (i < this.numberDots) {
                        this.dotList[i].animate(this.boardScreen);
                        ++i;
                    }
                }
                if (this.movementMode == 3 || this.movementMode == 1 || this.movementMode == 2) {
                    boolean stillMoving = false;
                    int i2 = 0;
                    while (i2 < this.dotList.length) {
                        if (this.dotList[i2].isActive()) {
                            stillMoving = true;
                        }
                        ++i2;
                    }
                    if (!stillMoving) {
                        if (this.movementMode == 1) {
                            if (this.player.playerID == 0) {
                                this.choiceScreen.dotCarpet.setTopDigitVisible(true);
                            } else if (this.player.playerID == 1) {
                                this.choiceScreen.dotCarpet.setBottomDigitVisible(true);
                            }
                        }
                        if (this.movementMode == 3) {
                            if (this.allDotsClicked) {
                                this.game.delay(500, "game.nextTaskInQueue(\"DotManager.animate\")");
                                this.setActive(false);
                            } else {
                                this.movementMode = (byte)4;
                                this.setActive(false);
                            }
                        } else {
                            this.game.delay(500, "game.nextTaskInQueue(\"DotManager.animate\")");
                            this.setActive(false);
                        }
                    }
                }
            } else if (!this.moveSeveralDotsAtOnce) {
                if (this.screenDrawingTo == 0) {
                    this.dotList[this.currentMovingDot].animate(this.choiceScreen);
                } else if (this.screenDrawingTo == 1) {
                    this.dotList[this.currentMovingDot].animate(this.boardScreen);
                }
                if (!this.dotList[this.currentMovingDot].isActive()) {
                    this.switchDotPointer();
                }
            }
        }
    }

    protected void render() {
        if (!this.isRendered()) {
            this.setRendered(true);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        block5: {
            block6: {
                if (!this.isReady() || this.drawDotsTo == 0 || !this.dotContainer.mainDotArray.getDotsVisible()) break block5;
                if (this.screenDrawingTo != 0) break block6;
                int i = 0;
                while (i < this.dotList.length) {
                    this.dotList[i].paint(g, "ChoiceScreen");
                    ++i;
                }
                break block5;
            }
            if (this.screenDrawingTo != 1) break block5;
            if (!this.dotContainer.getSubtraction()) {
                int i = 0;
                while (i < this.dotList.length) {
                    this.dotList[i].paint(g, "BoardScreen");
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.numberDots - this.numberToSubtract) {
                    this.dotList[i].paint(g, "BoardScreen");
                    ++i;
                }
            }
        }
    }

    @Override
    public void update() {
        if (this.drawDotsTo == 1) {
            if (this.screenDrawingTo == 0) {
                this.choiceScreen.setRendered(false);
            }
            if (this.screenDrawingTo == 1) {
                this.boardScreen.setRendered(false);
            }
        }
    }

    public void updateDotList() {
        int i = 0;
        while (i < this.dotList.length) {
            this.dotList[i].update();
            ++i;
        }
    }

    public void assignDotManager(DotContainer dotContainer, GameTurn currentTurn) {
        this.dotContainer = dotContainer;
        this.numberDots = dotContainer.mainDotArray.getNumber();
        if (dotContainer.getAddition()) {
            this.addition = true;
            int leftNum = dotContainer.subDotArrays[0].getNumber();
            int rightNum = dotContainer.subDotArrays[1].getNumber();
            this.dotList = new DotSprite[leftNum + rightNum];
            int i = 0;
            while (i < leftNum) {
                this.dotList[i] = dotContainer.subDotArrays[0].dotList[i];
                ++i;
            }
            i = 0;
            while (i < rightNum) {
                this.dotList[i + leftNum] = dotContainer.subDotArrays[1].dotList[i];
                ++i;
            }
            dotContainer.subDotArrays[0].setDotsVisible(false);
            dotContainer.subDotArrays[1].setDotsVisible(false);
            this.numberToSubtract = 0;
        } else if (dotContainer.getSubtraction()) {
            this.subtraction = true;
            this.numberToSubtract = currentTurn.getSubNumber(dotContainer.getId(), 1);
            this.dotList = dotContainer.mainDotArray.dotList;
        } else {
            this.dotList = dotContainer.mainDotArray.dotList;
            this.numberToSubtract = 0;
        }
        this.numberRemaining = this.numberDots;
        this.numberWithSpace = Math.min(this.numberDots - this.numberToSubtract, 40 - this.player.getBoardSquare());
    }

    public void grabAndLineUpDotsOnCarpet() {
        this.movementMode = 1;
        this.moveSeveralDotsAtOnce = true;
        if (!this.dotContainer.getSubtraction()) {
            int i = 0;
            while (i < this.numberDots) {
                if (this.player.playerID == 0) {
                    this.dotList[i].setDestination(this.choiceScreen.dotCarpet.topDotStackPoints[i]);
                } else if (this.player.playerID == 1) {
                    this.dotList[i].setDestination(this.choiceScreen.dotCarpet.bottomDotStackPoints[i]);
                }
                this.dotList[i].setDeadline(500);
                this.dotList[i].setDotMover(this);
                this.dotList[i].setActive(true);
                if (this.player.playerID == 0) {
                    this.choiceScreen.dotCarpet.setTopDigit(this.numberDots);
                } else if (this.player.playerID == 1) {
                    this.choiceScreen.dotCarpet.setBottomDigit(this.numberDots);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numberRemaining) {
                if (this.player.playerID == 0) {
                    this.dotList[i].setDestination(this.choiceScreen.dotCarpet.topDotStackPoints[i]);
                } else if (this.player.playerID == 1) {
                    this.dotList[i].setDestination(this.choiceScreen.dotCarpet.bottomDotStackPoints[i]);
                }
                this.dotList[i].setDeadline(500);
                this.dotList[i].setDotMover(this);
                this.dotList[i].setActive(true);
                if (this.player.playerID == 0) {
                    this.choiceScreen.dotCarpet.setTopDigit(this.numberRemaining);
                } else if (this.player.playerID == 1) {
                    this.choiceScreen.dotCarpet.setBottomDigit(this.numberRemaining);
                }
                ++i;
            }
        }
        this.setReady(true);
    }

    public void grabAndSubtractDots() {
        this.movementMode = (byte)2;
        int i = this.numberRemaining = this.numberDots - this.numberToSubtract;
        while (i < this.numberDots) {
            this.dotList[i].setDestination(this.dotContainer.dotStackPoints[i - this.numberRemaining]);
            this.dotList[i].setDeadline(500);
            this.dotList[i].setDotMover(this);
            this.dotList[i].setActive(true);
            ++i;
        }
        this.moveSeveralDotsAtOnce = true;
        this.setReady(true);
        this.dotContainer.update();
    }

    public void nextClickResponse(byte player, int numDots) {
        this.numberClickedDots += numDots;
        this.moveMultipleDotsToBoard(player, numDots);
        if (!this.subtraction && this.numberClickedDots == this.numberDots || this.subtraction && this.numberClickedDots == this.numberRemaining || this.numberClickedDots == this.numberWithSpace) {
            this.allDotsClicked = true;
            this.game.soundManager.play(String.valueOf(Utilities.charac4id(player)) + Utilities.getVerbalForArabic(this.numberClickedDots));
        } else {
            this.game.soundManager.play(String.valueOf(Utilities.charac4id(player)) + "counting_" + Utilities.getVerbalForArabic(this.numberClickedDots));
        }
    }

    public void moveMultipleDotsToBoard(byte player, int numDots) {
        this.movementMode = (byte)3;
        Point newDestination = new Point(0, 0);
        int i = this.numberClickedDots - numDots;
        while (i < this.numberClickedDots) {
            if (this.player.getBoardSquare() + 1 + i <= 40) {
                this.boardScreen.numberBoard.getScreenPointforSquare(this.player.getBoardSquare() + 1 + i, newDestination);
                this.dotList[i].setDestination(newDestination);
                this.dotList[i].setSquare(this.player.getBoardSquare() + 1 + i);
                this.dotList[i].setDeadline(500);
                this.dotList[i].setActive(true);
                this.moveSeveralDotsAtOnce = true;
            }
            ++i;
        }
        this.setActive(true);
        this.setReady(true);
    }

    public void setupClickDotsToBoard() {
        this.movementMode = (byte)4;
        this.allDotsClicked = false;
    }

    public void switchDotPointer() {
        if (this.currentMovingDot < this.numberRemaining - 1 && this.currentMovingDot < this.numberWithSpace - 1) {
            ++this.currentMovingDot;
            this.playedName = false;
            if (this.movementMode == 3) {
                this.dotList[this.currentMovingDot].setActive(true);
            } else if (this.movementMode == 4) {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
            this.game.nextTaskInQueue("DotManager.switchDotPointer");
        }
    }

    public void setDotsVisible(boolean state) {
        if (this.movementMode == 3 || this.movementMode == 4) {
            int i = 0;
            while (i < this.numberDots) {
                this.dotList[i].setVisible(state);
                ++i;
            }
            this.update();
        }
    }

    public void switchDrawingScreen(String screen) {
        if (screen == "GAME_SCREEN") {
            this.screenDrawingTo = 0;
        } else if (screen == "BOARD_SCREEN") {
            this.screenDrawingTo = 1;
        } else if (screen == "NOWHERE") {
            this.drawDotsTo = 0;
            this.screenDrawingTo = 0;
        }
    }

    public void reset() {
        this.drawDotsTo = 0;
        this.screenDrawingTo = 0;
        this.numberDots = 0;
        this.allDotsClicked = false;
        this.numberToSubtract = 0;
        this.numberRemaining = 0;
        this.movementMode = 0;
        this.currentMovingDot = 0;
        this.numberClickedDots = 0;
        this.playedName = false;
        this.setActive(false);
        this.moveSeveralDotsAtOnce = false;
        this.addition = false;
        this.subtraction = false;
        this.update();
    }

    @Override
    public void setPosition(float x, float y) {
    }

    @Override
    public void setVelocity(float x, float y) {
    }
}

