/*
 * Decompiled with CFR 0.152.
 */
package graphics.events;

import bsh.EvalError;
import bsh.Interpreter;
import graphics.Game;
import graphics.events.Task;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TaskManager {
    private List taskList;
    private LinkedList taskQueue;
    public Interpreter bsh = new Interpreter();
    private long pauseStartStamp;
    private long pauseEndStamp;

    public TaskManager(Game game) {
        try {
            this.bsh.set("game", game);
            this.bsh.set("choiceScreen", game.choiceScreen);
            this.bsh.set("boardScreen", game.choiceScreen.boardScreen);
            this.bsh.set("ncm", game.choiceScreen.ncm);
        }
        catch (EvalError e) {
            System.out.println(e.toString());
        }
        this.taskList = new ArrayList();
        this.taskQueue = new LinkedList();
    }

    public boolean setPaused(boolean pauseState) {
        if (pauseState) {
            this.pauseStartStamp = System.currentTimeMillis();
        } else if (!pauseState) {
            long pauseEndStamp = System.currentTimeMillis();
            int size = this.taskList.size();
            int i = 0;
            while (i < size) {
                Task task = (Task)this.taskList.get(i);
                task.accountForPause(this.pauseStartStamp, pauseEndStamp);
                ++i;
            }
        }
        return true;
    }

    public void addTaskToList(int delay, String statement, long startTime) {
        this.addTaskToList(new Task(this, true, delay, statement, startTime));
    }

    public void addTaskToQueue(int delay, String statement, long startTime) {
        this.addTaskToQueue(new Task(this, false, delay, statement, startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToList(Task task) {
        List list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTasksFromList(String key) {
        List list = this.taskList;
        synchronized (list) {
            ArrayList<Task> removeList = null;
            int size = this.taskList.size();
            int i = 0;
            while (i < size) {
                Task task = (Task)this.taskList.get(i);
                if (task.containsKey(key)) {
                    if (removeList == null) {
                        removeList = new ArrayList<Task>();
                    }
                    removeList.add(task);
                }
                ++i;
            }
            if (removeList != null) {
                this.taskList.removeAll(removeList);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToQueue(Task task) {
        LinkedList linkedList = this.taskQueue;
        synchronized (linkedList) {
            this.taskQueue.add(task);
        }
    }

    public void clearTaskList() {
        this.taskList.clear();
    }

    public void clearTaskQueue() {
        this.taskQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List list = this.taskList;
        synchronized (list) {
            ArrayList<Task> removeList = null;
            int size = this.taskList.size();
            int i = 0;
            while (i < size) {
                Task task = (Task)this.taskList.get(i);
                if (task.check()) {
                    if (removeList == null) {
                        removeList = new ArrayList<Task>();
                    }
                    removeList.add(task);
                }
                ++i;
            }
            if (removeList != null) {
                this.taskList.removeAll(removeList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextInTaskQueue() {
        String taskName = null;
        LinkedList linkedList = this.taskQueue;
        synchronized (linkedList) {
            Task task;
            if (this.taskQueue.size() > 0 && (task = (Task)this.taskQueue.getFirst()).check()) {
                taskName = task.statement;
                this.taskQueue.removeFirst();
            }
        }
        return taskName;
    }
}

