/*
 * Decompiled with CFR 0.152.
 */
package debug;

import algorithms.GameTurn;
import graphics.Game;
import graphics.sprites.PlayerPiece;
import graphics.vars.GraphicsVariables;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.util.Random;
import org.jmat.data.Matrix;
import util.Utilities;

public class Simulator
extends Robot {
    Game game;
    private Matrix knowledge;
    private double[][] d_knowledge = new double[][]{{0.5, 0.5, 0.5}};
    private Matrix learningSpeed;
    private double[][] d_learningSpeed = new double[][]{{1.0, 1.0, 1.0}};
    private int sigslope = 20;
    private final float HOLE_SIZE = 0.4f;
    private final byte ALGO_CHILD = 1;
    private Random randomNumber;

    public Simulator(Game game, int ntrials) throws AWTException {
        this.game = game;
        this.randomNumber = new Random();
        this.randomNumber.setSeed(System.currentTimeMillis());
        this.knowledge = new Matrix(this.d_knowledge);
        this.learningSpeed = new Matrix(this.d_learningSpeed);
    }

    public void learn(Matrix currentDifficulty) {
        Matrix expo = (Matrix)currentDifficulty.minus(this.knowledge);
        expo = (Matrix)expo.times(-1 * this.sigslope);
        int i = 0;
        while (i < currentDifficulty.getColumnDimension()) {
            expo.set(0, i, Math.exp(expo.get(0, i)));
            ++i;
        }
        Matrix delta = (Matrix)expo.ebePower(-1.0).plus(1.0).ebeTimes(expo.plus(1.0)).ebePower(-1.0).times(4.0);
        this.knowledge = (Matrix)this.knowledge.plus(delta.ebeTimes(this.learningSpeed).times(0.001));
    }

    public String getKnowledge() {
        String commaDelimStr = "";
        int i = 0;
        while (i < 3) {
            commaDelimStr = commaDelimStr.concat(String.valueOf(String.valueOf(Utilities.round(this.knowledge.get(0, i), 4))) + ",");
            ++i;
        }
        return commaDelimStr;
    }

    public void doChoiceResponse() {
        boolean chosenSide;
        GameTurn currentTurn = this.game.choiceScreen.ncm.getCurrentTurn();
        Matrix currentDifficulty = currentTurn.getCurrentDifficulty();
        int leftNumber = currentTurn.getNumber(0);
        int rightNumber = currentTurn.getNumber(1);
        double pcorrect = 1.0;
        pcorrect = 1.0;
        int i = 0;
        while (i < 3) {
            pcorrect /= 1.0 + Math.exp((double)this.sigslope * (currentDifficulty.get(0, i) - this.knowledge.get(0, i)));
            ++i;
        }
        pcorrect = 0.5 + 0.5 * Math.pow(pcorrect, 0.3333);
        double chosenRand = this.randomNumber.nextDouble();
        if (chosenRand <= pcorrect) {
            boolean success = true;
            chosenSide = leftNumber <= rightNumber;
        } else {
            boolean success = false;
            chosenSide = leftNumber > rightNumber;
        }
        this.learn(currentDifficulty);
        if (!chosenSide) {
            this.mouseMove(256, 512);
            this.mousePress(16);
        } else if (chosenSide) {
            this.mouseMove(768, 512);
            this.mousePress(16);
        }
    }

    public void doBoardClick(PlayerPiece player, int boardSquare) {
        Point screenPoint = new Point(0, 0);
        this.game.choiceScreen.boardScreen.numberBoard.getScreenPointforSquare(boardSquare, screenPoint);
        this.mouseMove(screenPoint.x, screenPoint.y);
        this.mousePress(16);
    }

    public void selectTopRightButton() {
        this.mouseMove(992, 96);
        this.mousePress(16);
    }

    public void clickScreenSwitchButton() {
        this.mouseMove(374, 734);
        this.mousePress(16);
    }

    public void clickRewardViewButton() {
        this.mouseMove(690, 690);
        this.mousePress(16);
    }

    public void chooseCharacter() {
        int chosenRand;
        while (!this.game.currentStudent.getCharacAccess(chosenRand = this.randomNumber.nextInt(6), this.game.getTheme())) {
        }
        if (chosenRand == 0) {
            this.mouseMove(GraphicsVariables.CHARAC_1_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_1_BUTTON_LOC.y + 15);
        } else if (chosenRand == 1) {
            this.mouseMove(GraphicsVariables.CHARAC_2_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_2_BUTTON_LOC.y + 15);
        } else if (chosenRand == 2) {
            this.mouseMove(GraphicsVariables.CHARAC_3_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_3_BUTTON_LOC.y + 15);
        } else if (chosenRand == 3) {
            this.mouseMove(GraphicsVariables.CHARAC_4_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_4_BUTTON_LOC.y + 15);
        } else if (chosenRand == 4) {
            this.mouseMove(GraphicsVariables.CHARAC_5_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_5_BUTTON_LOC.y + 15);
        } else if (chosenRand == 5) {
            this.mouseMove(GraphicsVariables.CHARAC_6_BUTTON_LOC.x + 15, GraphicsVariables.CHARAC_6_BUTTON_LOC.y + 15);
        }
        this.mousePress(16);
    }

    public void selectTheme() {
        boolean chosenRand = this.randomNumber.nextBoolean();
        if (chosenRand) {
            this.mouseMove(GraphicsVariables.THEME_1_LOC.x + 30, GraphicsVariables.THEME_1_LOC.y + 30);
        } else {
            this.mouseMove(GraphicsVariables.THEME_2_LOC.x + 30, GraphicsVariables.THEME_2_LOC.y + 30);
        }
        this.mousePress(16);
    }

    public void doFishClick() {
        this.mouseMove((int)this.game.rewardScreen.rewardSprite.getX(), (int)this.game.rewardScreen.rewardSprite.getY());
        this.mousePress(16);
    }
}

