/*
 * Decompiled with CFR 0.152.
 */
package debug;

import debug.MemMonitor;
import graphics.Game;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lang.Translator;

public class Debugger
extends JDialog
implements ActionListener {
    public static final boolean IN_USE = false;
    Game game;
    public Translator translator;
    private MemMonitor memMonitor;
    public boolean debugLearningAlgorithm = false;
    public boolean debugGameScreens = false;
    public boolean debugHeapAlloc = false;
    public boolean translation = false;
    public boolean fullScreenMode = false;
    public boolean debugNotnLevel = false;
    public int notnLevelToDebug;
    public boolean debugMeanProbs = false;
    public double[] defaultMeanProbs = new double[3];
    public boolean simulationMode = false;
    public boolean autoMoveDots = false;
    private JLabel titleLabel;
    private JLabel explnLabel;
    private JRadioButton debugAlgButton;
    private JRadioButton debugGameScreensButton;
    private JRadioButton debugHeapAllocButton;
    private JRadioButton translationButton;
    private JRadioButton fullScreenButton;
    private JRadioButton debugNotnLevelButton;
    private JTextField debugNotnLevelText;
    private JLabel magProbLabel;
    private JTextField magProbText;
    private JLabel distProbLabel;
    private JTextField distProbText;
    private JLabel notnProbLabel;
    private JTextField notnProbText;
    private JRadioButton simModeButton;
    private JButton okButton;
    private JButton exitButton;

    public Debugger(Game game) {
        super(game, "JeuAdaptatif Debugger", true);
        this.game = game;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Debugger.this.exitProgram();
            }
        });
        this.setSize(400, 450);
        this.getContentPane().setBackground(Color.CYAN);
        this.getContentPane().setForeground(Color.BLACK);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(null);
        this.initializeGUIObjects();
    }

    @Override
    public void show() {
        this.setModal(false);
        super.show();
        this.resizeToInternalSize(this.getWidth(), this.getHeight());
        this.setResizable(false);
        this.hide();
        this.setModal(true);
        super.show();
    }

    public void gameStart() {
        if (this.debugHeapAlloc) {
            System.out.println(this.memMonitor.outputHeadings());
        }
    }

    public void memMonitorSample() {
        this.memMonitor.takeSample();
        System.out.println(this.memMonitor.outputCurrent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean infoEnteredCorrectly = true;
        if (e.getSource() == this.debugNotnLevelButton) {
            this.debugNotnLevelText.setEditable(true);
            return;
        } else if (e.getSource() == this.okButton) {
            if (this.debugAlgButton.isSelected()) {
                this.debugLearningAlgorithm = true;
            }
            if (this.debugGameScreensButton.isSelected()) {
                this.debugGameScreens = true;
            }
            if (this.debugHeapAllocButton.isSelected()) {
                this.debugHeapAlloc = true;
                this.memMonitor = new MemMonitor();
            }
            if (this.translationButton.isSelected()) {
                this.translation = true;
                this.translator = new Translator(this.game, this);
            }
            if (this.fullScreenButton.isSelected()) {
                this.fullScreenMode = true;
            }
            if (this.debugNotnLevelButton.isSelected()) {
                if (this.debugNotnLevelText.getText() == "") {
                    JOptionPane.showMessageDialog(this, "Enter a level to debug (0-11)");
                    return;
                }
                this.debugNotnLevel = true;
                this.notnLevelToDebug = Integer.parseInt(this.debugNotnLevelText.getText());
            }
            if (this.simModeButton.isSelected()) {
                this.simulationMode = true;
                this.autoMoveDots = true;
            }
            if (!infoEnteredCorrectly) return;
            this.hide();
            return;
        } else {
            if (e.getSource() != this.exitButton) return;
            this.game.endGame();
        }
    }

    private void initializeGUIObjects() {
        this.titleLabel = new JLabel("DEBUGGING OPTIONS");
        this.titleLabel.setFont(new Font("Arial Black", 0, 16));
        this.titleLabel.setSize(this.titleLabel.getPreferredSize());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setLocation(50, 25);
        this.getContentPane().add(this.titleLabel);
        this.explnLabel = new JLabel("Select the options you would like:");
        this.explnLabel.setFont(new Font("Arial", 2, 14));
        this.explnLabel.setSize(this.explnLabel.getPreferredSize());
        this.explnLabel.setHorizontalAlignment(0);
        this.explnLabel.setLocation(50, 62);
        this.getContentPane().add(this.explnLabel);
        this.debugAlgButton = new JRadioButton("Debug Adaptive Algorithm (Displays Parameters)");
        this.debugAlgButton.setFont(new Font("Arial", 0, 12));
        this.debugAlgButton.setBackground(Color.CYAN);
        this.debugAlgButton.setForeground(Color.BLACK);
        this.debugAlgButton.setLocation(50, 100);
        this.debugAlgButton.setSize(this.debugAlgButton.getPreferredSize());
        this.getContentPane().add(this.debugAlgButton);
        this.debugGameScreensButton = new JRadioButton("Debug Game Screens (Skips Intro)");
        this.debugGameScreensButton.setFont(new Font("Arial", 0, 12));
        this.debugGameScreensButton.setBackground(Color.CYAN);
        this.debugGameScreensButton.setForeground(Color.BLACK);
        this.debugGameScreensButton.setLocation(50, 137);
        this.debugGameScreensButton.setSize(this.debugGameScreensButton.getPreferredSize());
        this.getContentPane().add(this.debugGameScreensButton);
        this.debugHeapAllocButton = new JRadioButton("Debug Heap Allocation (Memory Usage)");
        this.debugHeapAllocButton.setFont(new Font("Arial", 0, 12));
        this.debugHeapAllocButton.setBackground(Color.CYAN);
        this.debugHeapAllocButton.setForeground(Color.BLACK);
        this.debugHeapAllocButton.setLocation(50, 175);
        this.debugHeapAllocButton.setSize(this.debugHeapAllocButton.getPreferredSize());
        this.getContentPane().add(this.debugHeapAllocButton);
        this.translationButton = new JRadioButton("French to English Translation");
        this.translationButton.setFont(new Font("Arial", 0, 12));
        this.translationButton.setBackground(Color.CYAN);
        this.translationButton.setForeground(Color.BLACK);
        this.translationButton.setLocation(50, 212);
        this.translationButton.setSize(this.translationButton.getPreferredSize());
        this.getContentPane().add(this.translationButton);
        this.fullScreenButton = new JRadioButton("Run in Full Screen Mode");
        this.fullScreenButton.setFont(new Font("Arial", 0, 12));
        this.fullScreenButton.setBackground(Color.CYAN);
        this.fullScreenButton.setForeground(Color.BLACK);
        this.fullScreenButton.setLocation(50, 250);
        this.fullScreenButton.setSize(this.fullScreenButton.getPreferredSize());
        this.getContentPane().add(this.fullScreenButton);
        this.debugNotnLevelButton = new JRadioButton("Debug Notation Level");
        this.debugNotnLevelButton.setFont(new Font("Arial", 0, 12));
        this.debugNotnLevelButton.setBackground(Color.CYAN);
        this.debugNotnLevelButton.setForeground(Color.BLACK);
        this.debugNotnLevelButton.setLocation(50, 287);
        this.debugNotnLevelButton.setSize(this.debugNotnLevelButton.getPreferredSize());
        this.debugNotnLevelButton.addActionListener(this);
        this.getContentPane().add(this.debugNotnLevelButton);
        this.debugNotnLevelText = new JTextField(2);
        this.debugNotnLevelText.setLocation(200, 287);
        this.debugNotnLevelButton.setFont(new Font("Arial", 0, 12));
        this.debugNotnLevelText.setSize(this.debugNotnLevelText.getPreferredSize());
        this.debugNotnLevelText.setEditable(false);
        this.getContentPane().add(this.debugNotnLevelText);
        this.simModeButton = new JRadioButton("Simulation Mode");
        this.simModeButton.setFont(new Font("Arial", 0, 12));
        this.simModeButton.setBackground(Color.CYAN);
        this.simModeButton.setForeground(Color.BLACK);
        this.simModeButton.setLocation(50, 325);
        this.simModeButton.setSize(this.simModeButton.getPreferredSize());
        this.getContentPane().add(this.simModeButton);
        this.okButton = new JButton("OK");
        this.okButton.setFont(new Font("Arial", 0, 14));
        this.okButton.setBackground(Color.GREEN);
        this.okButton.setForeground(Color.BLACK);
        this.okButton.setLocation(75, 375);
        this.okButton.addActionListener(this);
        this.okButton.setSize(100, 50);
        this.getContentPane().add(this.okButton);
        this.exitButton = new JButton("Exit");
        this.exitButton.setFont(new Font("Arial", 0, 14));
        this.exitButton.setBackground(Color.MAGENTA);
        this.exitButton.setForeground(Color.BLACK);
        this.exitButton.setLocation(225, 375);
        this.exitButton.addActionListener(this);
        this.exitButton.setSize(100, 50);
        this.getContentPane().add(this.exitButton);
    }

    public void resizeToInternalSize(int internalWidth, int internalHeight) {
        Insets insets = this.getInsets();
        final int newWidth = internalWidth + insets.left + insets.right;
        final int newHeight = internalHeight + insets.top + insets.bottom;
        Runnable resize = new Runnable(){

            @Override
            public void run() {
                Debugger.this.setSize(newWidth, newHeight);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(resize);
            }
            catch (Exception exception) {}
        } else {
            resize.run();
        }
        this.validate();
    }

    public void exitProgram() {
        this.game.endGame();
    }
}

