/*
 * Decompiled with CFR 0.152.
 */
package data;

import algorithms.GameTurn;
import algorithms.Matrix3D;
import algorithms.NewMultiDimAlg;
import data.Student;
import graphics.Game;
import graphics.managers.NumCompManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Vector;
import org.jmat.data.Matrix;

public class DataFileHandler {
    SaveMatrix save = new SaveMatrix();
    private Game game;
    private NumCompManager ncm;
    private File studentDataFile;
    private FileWriter studentDataFileWriter;
    private FileReader studentDataFileReader;
    private LineNumberReader studentDataFileLineReader;
    private File studentAlgDataFile;
    private FileOutputStream studentAlgDataFileOutStream;
    private ObjectOutputStream studentAlgDataObjOutStream;
    private FileInputStream studentAlgDataFileInStream;
    private ObjectInputStream studentAlgDataObjInStream;
    private File allStudentListFile;
    private FileWriter studentListFileWriter;
    private FileReader studentListFileReader;
    private LineNumberReader studentListFileLineReader;
    private DateFormat dateFormatter;
    private DateFormat timeFormatter;
    public Student currentStudent;
    Vector studentListData;
    private final int MODEL_DATA = 0;
    private final int ED_MATRIX = 1;

    public DataFileHandler(Game game, NumCompManager ncm) {
        this.game = game;
        this.ncm = ncm;
        this.dateFormatter = DateFormat.getDateInstance(3, Locale.FRANCE);
        this.timeFormatter = DateFormat.getTimeInstance(2, Locale.FRANCE);
    }

    public boolean createAllStudentList() {
        this.allStudentListFile = new File("Data/AllStudentsList.txt");
        return true;
    }

    public boolean loadAllStudentList(Vector studentListData) {
        try {
            this.studentListFileReader = new FileReader(this.allStudentListFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.studentListFileLineReader = new LineNumberReader(this.studentListFileReader);
        boolean endOfData = false;
        do {
            Student studentReadFromFile;
            if ((studentReadFromFile = Student.readAllStudentListLine(this.studentListFileLineReader)) != null) {
                studentListData.add(studentReadFromFile);
                continue;
            }
            endOfData = true;
        } while (!endOfData);
        return true;
    }

    public boolean saveAllStudentList(Vector studentListData) {
        try {
            this.studentListFileWriter = new FileWriter(this.allStudentListFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeAllStudentListHeader(this.studentListFileWriter);
        int listLength = studentListData.size();
        int i = 0;
        while (i < listLength) {
            Student tmpStudent = (Student)studentListData.get(i);
            tmpStudent.setDataLine(i);
            tmpStudent.writeAllStudentListLine(this.studentListFileWriter);
            ++i;
        }
        boolean success = this.closeAllStudentListFile();
        this.studentListFileWriter = null;
        return success;
    }

    private boolean replaceAllStudentListLine(Student student) {
        Vector<Student> studentListData = new Vector<Student>();
        this.loadAllStudentList(studentListData);
        studentListData.set(student.getDataLine(), student);
        boolean success = this.saveAllStudentList(studentListData);
        return success;
    }

    private void writeAllStudentListHeader(FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.write(String.valueOf(Student.getHeaders()) + "\r\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean closeAllStudentListFile() {
        if (this.studentListFileWriter != null) {
            try {
                this.studentListFileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.studentListFileReader != null) {
            try {
                this.studentListFileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void createStudentDataFile(Student student) {
        this.studentDataFile = new File("Data/" + student.getFileHeader() + "_" + student.getSessionNumber() + "_Data.txt");
        try {
            this.studentDataFileWriter = new FileWriter(this.studentDataFile, true);
            this.studentDataFileReader = new FileReader(this.studentDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.studentDataFileLineReader = new LineNumberReader(this.studentDataFileReader);
        this.writeStudentFileHeader();
    }

    public void writeStudentFileHeader() {
        try {
            this.studentDataFileWriter.write("lastName,firstName,session,game,turn,date,time,meanSucc,currDesir,edChosen,DiffSpeed,DiffDist,DiffNotn,cDiffSpeed,cDiffDist,cDiffNotn,ptChosn1,ptChosn2,ptChosn3,anlgMag,verbal,arabic,dotFade,rstrRge,hazard,add,subtrc,fadeSpd,controlFor,leftStim,rightStim,leftSubLeft,leftSubOp,leftSubRight,rightSubLeft,rightSubOp,rightSubRight,respSide,respCorr,finalCorr,RT,relNetGain,p1NetGain,p2NetGain,p1movfor,p2movfor,p1movback,p2movback,p1square,p2square,h_relNetGain,h_p1NetGain,h_p2NetGain,h_p1movfor,h_p2movfor,h_p1movback,h_p2movback," + this.game.choiceScreen.boardScreen.hazardManager.getHazardHeadersCommaDelim() + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeStudentFileDataLine(GameTurn currentTurn) {
        try {
            this.studentDataFileWriter.write(String.valueOf(this.currentStudent.getLastName()) + "," + this.currentStudent.getFirstName() + "," + this.currentStudent.getSessionNumber() + "," + (this.ncm.getNumGamesPlayed() + 1) + "," + currentTurn.getTurnNumber() + "," + this.dateFormatter.format(currentTurn.getTurnStartTime()) + "," + this.timeFormatter.format(currentTurn.getTurnStartTime()) + "," + currentTurn.getMeanSuccess() + "," + currentTurn.getCurrDesiredDiff() + "," + currentTurn.getEstimatedDiff() + "," + currentTurn.getDiffLvlsCommaDelim() + currentTurn.getConvDiffLvlsCommaDelim() + currentTurn.getCoordsChosenCommaDelim() + this.ncm.getNotnAttrCommaDelim(currentTurn.getCurrentNotnLevel()) + currentTurn.getControlDensityStr() + "," + currentTurn.getNumbersCommaDelim() + currentTurn.getSubNumbersAndOpsCommaDelim() + currentTurn.getResponseSideString() + "," + currentTurn.getResponseCorrectStr() + "," + currentTurn.getFinalCorrectStr() + "," + currentTurn.getRTStr() + "," + currentTurn.getRelativeGainInfo() + currentTurn.getHypRelativeGainInfo() + this.game.choiceScreen.boardScreen.hazardManager.getHazardPositionsCommaDelim() + "\r");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean closeStudentDataFile() {
        if (this.studentDataFileWriter != null) {
            try {
                this.studentDataFileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.studentDataFileReader != null) {
            try {
                this.studentDataFileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void setStudentAlgDataFile(Student student) {
        this.studentAlgDataFile = new File("Data/" + student.getFileHeader() + "_Alg.txt");
        boolean previousDataPresent = this.studentAlgDataFile.isFile();
        if (previousDataPresent) {
            Object[] algData = this.getStudentAlgData();
            this.game.choiceScreen.ncm.setModelData((Matrix)algData[0], (Matrix3D)algData[1]);
        }
    }

    public void writeStudentAlgDataFile(Matrix modelData, Matrix3D edMatrix) {
        try {
            this.studentAlgDataFileOutStream = new FileOutputStream(this.studentAlgDataFile);
            this.studentAlgDataObjOutStream = new ObjectOutputStream(this.studentAlgDataFileOutStream);
            this.studentAlgDataObjOutStream.writeObject(modelData);
            this.studentAlgDataObjOutStream.writeObject(edMatrix);
            this.studentAlgDataObjOutStream.flush();
            this.studentAlgDataFileOutStream.close();
            this.studentAlgDataObjOutStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object[] getStudentAlgData() {
        Object[] algData = new Object[2];
        try {
            this.studentAlgDataFileInStream = new FileInputStream(this.studentAlgDataFile);
            this.studentAlgDataObjInStream = new ObjectInputStream(this.studentAlgDataFileInStream);
            algData[0] = (Matrix)this.studentAlgDataObjInStream.readObject();
            algData[1] = (Matrix3D)this.studentAlgDataObjInStream.readObject();
            this.studentAlgDataFileInStream.close();
            this.studentAlgDataObjInStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return algData;
    }

    public boolean closeStudentAlgDataFile() {
        if (this.studentAlgDataFileOutStream != null) {
            try {
                this.studentAlgDataFileOutStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.studentAlgDataFileInStream != null) {
            try {
                this.studentAlgDataFileInStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.studentAlgDataObjOutStream != null) {
            try {
                this.studentAlgDataObjOutStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.studentAlgDataObjInStream != null) {
            try {
                this.studentAlgDataObjInStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void saveEdMatrix(Matrix3D matrix) {
        this.save.setMatrix(matrix);
        new Thread(this.save).start();
    }

    public void setStudent(Student student) {
        this.ncm.newStudent(student);
        this.currentStudent = student;
        this.game.currentStudent = student;
        this.currentStudent.augmentSession();
        this.createStudentDataFile(this.currentStudent);
        this.setStudentAlgDataFile(this.currentStudent);
    }

    public boolean exitStudent() {
        if (this.currentStudent != null) {
            if (this.saveGame() && this.closeStudentDataFile() && this.closeStudentAlgDataFile()) {
                this.currentStudent = null;
                this.ncm.exitStudent();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean saveGame() {
        if (this.currentStudent != null) {
            boolean success = this.replaceAllStudentListLine(this.currentStudent);
            return success;
        }
        return true;
    }

    public boolean closeAllDataFiles() {
        if (this.game.currentScreen == this.game.regScreen) {
            this.saveAllStudentList(this.game.regScreen.studentListData);
        }
        if (this.currentStudent != null) {
            boolean filesClosed = false;
            filesClosed = this.closeAllStudentListFile() && this.closeStudentDataFile() && this.closeStudentAlgDataFile();
            return filesClosed;
        }
        return true;
    }

    class SaveMatrix
    implements Runnable {
        private Matrix3D matrix;

        SaveMatrix() {
        }

        public void setMatrix(Matrix3D mtrx) {
            this.matrix = mtrx;
        }

        @Override
        public void run() {
            File log = new File("Data" + File.separator + DataFileHandler.this.currentStudent.getFileHeader() + "_" + DataFileHandler.this.currentStudent.getSessionNumber() + "_" + "edMatrix.txt");
            try {
                FileWriter fileWriter = new FileWriter(log, false);
                fileWriter.write("x,y,z,ed\r\n");
                int x = 0;
                while (x < NewMultiDimAlg.NUM_AXIS_DIVISIONS[0]) {
                    int y = 0;
                    while (y < NewMultiDimAlg.NUM_AXIS_DIVISIONS[1]) {
                        int z = 0;
                        while (z < NewMultiDimAlg.NUM_AXIS_DIVISIONS[2]) {
                            StringBuffer buffer = new StringBuffer(32);
                            buffer.append(x);
                            buffer.append(',');
                            buffer.append(y);
                            buffer.append(',');
                            buffer.append(z);
                            buffer.append(',');
                            buffer.append(this.matrix.get(x, y, z));
                            buffer.append("\r\n");
                            fileWriter.write(buffer.toString());
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Matrix saved");
        }
    }
}

