/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

import algorithms.Matrix3D;
import java.util.ArrayList;
import java.util.Random;
import org.jmat.data.Matrix;

public class NewMultiDimAlg {
    private final double ALPHA = 0.7;
    private final double DESIRED_SUCCESS = 0.75;
    private final double NORM_CUTOFF = 2.5;
    private final double[] ST_DEVS = new double[]{0.05, 0.05, 0.05};
    public static final int MODEL_SIZE = 20;
    public static final int[] NUM_AXIS_DIVISIONS = new int[]{20, 20, 20};
    private final int[] GENERALIZING_DISTANCE = new int[]{4, 4, 4};
    private final int MODEL_THREASHOLD = 5;
    private final double OMEGA = 0.5;
    private final double TOLERANCE = 0.05;
    private final double TOLERANCE_INCREMENT = 0.02;
    private final double SIG_SLOPE_SLOW = 10.0;
    private final double SIG_SLOPE_FAST = 40.0;
    private boolean ready;
    private int numDimensions;
    private double[] coordsChosen;
    private Matrix meanDifficulty;
    private double edChosen;
    private double currDesir;
    private double meanYmat;
    private Matrix axisDivisions = new Matrix(1, 3);
    private boolean modelFull;
    private boolean modelSufficientlyFull;
    private Matrix modelData;
    private int dataLine;
    private Matrix currentDifficulty;
    private Matrix3D estimatedDifficulty;
    double[] indexCurrDifficulty;
    Random randomNumber = new Random();

    public NewMultiDimAlg(int numDimensions, int startLevel) {
        this.numDimensions = numDimensions;
        int i = 0;
        while (i < numDimensions) {
            this.axisDivisions.set(0, i, NUM_AXIS_DIVISIONS[i]);
            ++i;
        }
        this.modelData = new Matrix(20, numDimensions + 1);
        this.estimatedDifficulty = new Matrix3D(NUM_AXIS_DIVISIONS[0], NUM_AXIS_DIVISIONS[1], NUM_AXIS_DIVISIONS[2], 0.5);
        this.estimatedDifficulty.set(0, 0, 0, 0.75);
        double convStartLvl = ((double)startLevel - 1.0) / 14.0;
        double[] convStartLvls = new double[]{convStartLvl, convStartLvl, convStartLvl};
        this.setStartKnowledge(convStartLvls);
        this.currentDifficulty = new Matrix(1, numDimensions);
        this.indexCurrDifficulty = new double[3];
        this.dataLine = 0;
        this.modelFull = false;
        this.modelSufficientlyFull = false;
        this.randomNumber.setSeed(System.currentTimeMillis());
        this.setReady(true);
    }

    public boolean start() {
        return this.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTrial(Matrix dataPoint) {
        NewMultiDimAlg newMultiDimAlg = this;
        synchronized (newMultiDimAlg) {
            block6: {
                if (dataPoint.getColumnDimension() != this.numDimensions + 1 || dataPoint.getRowDimension() != 1) break block6;
                if (!this.modelFull) {
                    this.modelData.setRow(this.dataLine, dataPoint);
                    ++this.dataLine;
                } else {
                    this.modelData = (Matrix)this.modelData.deleteRow(0);
                    this.modelData = (Matrix)this.modelData.insertRows(19, dataPoint);
                }
                this.checkIfModelAtThreashold();
                this.checkIfModelFull();
                boolean success = dataPoint.get(0, 3) != 0.0;
                this.runLearningAlg(success);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix getGeneratedDataPoint() {
        NewMultiDimAlg newMultiDimAlg = this;
        synchronized (newMultiDimAlg) {
            ArrayList candidateCoords;
            int numTrials = this.modelFull ? 20 : this.dataLine;
            if (this.modelSufficientlyFull) {
                Matrix yMat = (Matrix)this.modelData.getSubMatrix(0, numTrials - 1, this.numDimensions, this.numDimensions);
                this.meanYmat = yMat.mean().toDouble();
                this.currDesir = 0.75 - 0.7 * (this.meanYmat - 0.75);
            } else {
                this.currDesir = 0.75;
            }
            Matrix3D proximity = this.estimatedDifficulty.minus(this.currDesir).ebeAbs();
            double currentTolerance = 0.05;
            int its = 0;
            do {
                ++its;
                candidateCoords = proximity.findIndicesLessThan_v2ArrayList(currentTolerance);
                if (!candidateCoords.isEmpty()) continue;
                currentTolerance += 0.02;
            } while (candidateCoords.isEmpty());
            candidateCoords.trimToSize();
            int rowPicked = (int)(Math.ceil(this.randomNumber.nextDouble() * (double)candidateCoords.size()) - 1.0);
            int[] coordsChosenInt = (int[])candidateCoords.get(rowPicked);
            this.coordsChosen = new double[3];
            this.coordsChosen[0] = coordsChosenInt[0];
            this.coordsChosen[1] = coordsChosenInt[1];
            this.coordsChosen[2] = coordsChosenInt[2];
            this.edChosen = this.estimatedDifficulty.get(coordsChosenInt[0], coordsChosenInt[1], coordsChosenInt[2]);
            Matrix coordsChosenMatrix = new Matrix(this.coordsChosen, 1);
            this.meanDifficulty = (Matrix)coordsChosenMatrix.plus(0.5).ebeDivide(this.axisDivisions);
            int i = 0;
            while (i < this.numDimensions) {
                double chosenNumber = this.randomNumber.nextGaussian();
                double tmpValue = chosenNumber * this.ST_DEVS[i] + this.meanDifficulty.get(0, i);
                if (tmpValue < 0.0) {
                    tmpValue = 0.0;
                }
                if (tmpValue > 1.0) {
                    tmpValue = 1.0;
                }
                this.currentDifficulty.set(0, i, tmpValue);
                ++i;
            }
            return this.currentDifficulty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLearningAlg(boolean success) {
        NewMultiDimAlg newMultiDimAlg = this;
        synchronized (newMultiDimAlg) {
            int k;
            int j;
            int i = 0;
            while (i < 3) {
                this.indexCurrDifficulty[i] = this.currentDifficulty.get(0, i) * (double)NUM_AXIS_DIVISIONS[i];
                this.indexCurrDifficulty[i] = Math.floor(this.indexCurrDifficulty[i]);
                if (this.indexCurrDifficulty[i] > (double)(NUM_AXIS_DIVISIONS[i] - 1)) {
                    this.indexCurrDifficulty[i] = NUM_AXIS_DIVISIONS[i] - 1;
                }
                ++i;
            }
            double booleanSuccess = success ? 1.0 : 0.0;
            int i2 = (int)Math.max(0.0, this.indexCurrDifficulty[0] - (double)this.GENERALIZING_DISTANCE[0]);
            while ((double)i2 <= Math.min((double)(NUM_AXIS_DIVISIONS[0] - 1), this.indexCurrDifficulty[0] + (double)this.GENERALIZING_DISTANCE[0])) {
                j = (int)Math.max(0.0, this.indexCurrDifficulty[1] - (double)this.GENERALIZING_DISTANCE[1]);
                while ((double)j <= Math.min((double)(NUM_AXIS_DIVISIONS[1] - 1), this.indexCurrDifficulty[1] + (double)this.GENERALIZING_DISTANCE[1])) {
                    k = (int)Math.max(0.0, this.indexCurrDifficulty[2] - (double)this.GENERALIZING_DISTANCE[2]);
                    while ((double)k <= Math.min((double)(NUM_AXIS_DIVISIONS[2] - 1), this.indexCurrDifficulty[2] + (double)this.GENERALIZING_DISTANCE[2])) {
                        double dist = Math.abs((double)i2 - this.indexCurrDifficulty[0]) + Math.abs((double)j - this.indexCurrDifficulty[1]) + Math.abs((double)k - this.indexCurrDifficulty[2]);
                        if (dist < 5.0) {
                            double multip = 1.0 - dist / 5.0;
                            this.estimatedDifficulty.set(i2, j, k, (1.0 - 0.5 * multip) * this.estimatedDifficulty.get(i2, j, k) + 0.5 * multip * booleanSuccess);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            if (success) {
                i2 = 0;
                while ((double)i2 <= this.indexCurrDifficulty[0]) {
                    j = 0;
                    while ((double)j <= this.indexCurrDifficulty[1]) {
                        k = 0;
                        while ((double)k <= this.indexCurrDifficulty[2]) {
                            double multip = 1.0;
                            this.estimatedDifficulty.set(i2, j, k, (1.0 - 0.25 * multip) * this.estimatedDifficulty.get(i2, j, k) + 0.25 * multip * booleanSuccess);
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
            } else {
                i2 = (int)this.indexCurrDifficulty[0];
                while (i2 < NUM_AXIS_DIVISIONS[0]) {
                    j = (int)this.indexCurrDifficulty[1];
                    while (j < NUM_AXIS_DIVISIONS[1]) {
                        k = (int)this.indexCurrDifficulty[2];
                        while (k < NUM_AXIS_DIVISIONS[2]) {
                            double multip = 1.0;
                            double tmpValue = this.estimatedDifficulty.get(i2, j, k);
                            tmpValue = (1.0 - 0.25 * multip) * tmpValue + 0.25 * multip * 0.5;
                            this.estimatedDifficulty.set(i2, j, k, tmpValue);
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
        }
    }

    public boolean isModelSufficientlyFull() {
        return this.modelSufficientlyFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix getModelData() {
        NewMultiDimAlg newMultiDimAlg = this;
        synchronized (newMultiDimAlg) {
            return this.modelData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setModelData(Matrix modelDataToSet) {
        NewMultiDimAlg newMultiDimAlg = this;
        synchronized (newMultiDimAlg) {
            block5: {
                if (modelDataToSet.getColumnDimension() != this.numDimensions + 1 || modelDataToSet.getRowDimension() < 1 || modelDataToSet.getRowDimension() > 20) break block5;
                int i = 0;
                while (i < 20) {
                    this.dataLine = i;
                    if (modelDataToSet.get(i, 0) == 0.0 || modelDataToSet.get(i, 1) == 0.0 || modelDataToSet.get(i, 2) == 0.0) break;
                    this.modelData.setRow(i, modelDataToSet.getRow(i));
                    ++i;
                }
                this.checkIfModelAtThreashold();
                this.checkIfModelFull();
                return true;
            }
            return false;
        }
    }

    private void setStartKnowledge(double[] startKnowledge) {
        int i = 0;
        while ((double)i < Math.min((double)NUM_AXIS_DIVISIONS[0], Math.floor((double)NUM_AXIS_DIVISIONS[0] * startKnowledge[0] * 2.0))) {
            int j = 0;
            while ((double)j < Math.min((double)NUM_AXIS_DIVISIONS[1], Math.floor((double)NUM_AXIS_DIVISIONS[1] * startKnowledge[1] * 2.0))) {
                int k = 0;
                while ((double)k < Math.min((double)NUM_AXIS_DIVISIONS[2], Math.floor((double)NUM_AXIS_DIVISIONS[2] * startKnowledge[2] * 2.0))) {
                    double tmpVal = 1.0;
                    double[] location = new double[this.numDimensions];
                    location[0] = (double)(i + 1) / (double)NUM_AXIS_DIVISIONS[0];
                    location[1] = (double)(j + 1) / (double)NUM_AXIS_DIVISIONS[1];
                    location[2] = (double)(k + 1) / (double)NUM_AXIS_DIVISIONS[2];
                    int d = 0;
                    while (d < this.numDimensions) {
                        tmpVal = location[d] <= startKnowledge[d] ? (tmpVal /= 1.0 + Math.exp(10.0 * (location[d] - startKnowledge[d]))) : (tmpVal /= 1.0 + Math.exp(40.0 * (location[d] - startKnowledge[d])));
                        ++d;
                    }
                    tmpVal = 0.5 + 0.5 * Math.pow(tmpVal, 0.3333);
                    this.estimatedDifficulty.set(i, j, k, tmpVal);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void checkIfModelAtThreashold() {
        if (this.dataLine > 4) {
            this.modelSufficientlyFull = true;
        }
    }

    private void checkIfModelFull() {
        if (this.dataLine > 19) {
            this.modelFull = true;
        }
    }

    public Matrix3D getEdMatrix() {
        return this.estimatedDifficulty;
    }

    public void setEdMatrix(Matrix3D edMatrix) {
        this.estimatedDifficulty = edMatrix;
    }

    public Matrix getMeanDiff() {
        return this.meanDifficulty;
    }

    public Matrix getCoordsChosen() {
        return new Matrix(this.coordsChosen, 1);
    }

    public double getEdChosen() {
        return this.edChosen;
    }

    public double getMeanYmat() {
        return this.meanYmat;
    }

    public double getCurrDesir() {
        return this.currDesir;
    }

    public void setReady(boolean state) {
        this.ready = state;
    }

    public boolean isReady() {
        return this.ready;
    }
}

