/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.jmat.data.AbstractDoubleArray;
import org.jmat.data.Matrix;

public class Matrix3D
implements Serializable {
    private Matrix[] matrixArray;
    private int numRows;
    private int numColumns;
    private int numLayers;

    public Matrix3D(int x, int y, int z) {
        this.matrixArray = new Matrix[z];
        int i = 0;
        while (i < z) {
            this.matrixArray[i] = new Matrix(x, y);
            ++i;
        }
        this.numRows = x;
        this.numColumns = y;
        this.numLayers = z;
    }

    public Matrix3D(int x, int y, int z, double k) {
        this.matrixArray = new Matrix[z];
        int i = 0;
        while (i < z) {
            this.matrixArray[i] = new Matrix(x, y, k);
            ++i;
        }
        this.numRows = x;
        this.numColumns = y;
        this.numLayers = z;
    }

    public Matrix3D(Matrix[] inputMatrixArray) {
        this.matrixArray = inputMatrixArray;
        this.numRows = this.matrixArray[0].getRowDimension();
        this.numColumns = this.matrixArray[0].getColumnDimension();
        this.numLayers = inputMatrixArray.length;
    }

    public boolean set(int x, int y, int z, double k) {
        this.matrixArray[z].set(x, y, k);
        return true;
    }

    public boolean setLayer(Matrix layerToSet, int zIndex) {
        if (layerToSet.getRowDimension() == this.numRows && layerToSet.getColumnDimension() == this.numColumns) {
            this.matrixArray[zIndex] = layerToSet;
            return true;
        }
        System.out.println("Error: Matrix3D.setLayer: dimensions do not agree");
        return false;
    }

    public double get(int x, int y, int z) {
        return this.matrixArray[z].get(x, y);
    }

    public Matrix3D minus(double k) {
        Matrix[] result = new Matrix[this.numLayers];
        int i = 0;
        while (i < this.numLayers) {
            result[i] = (Matrix)this.matrixArray[i].minus(k);
            ++i;
        }
        return new Matrix3D(result);
    }

    public Matrix3D ebeAbs() {
        Matrix[] result = new Matrix[this.numLayers];
        int i = 0;
        while (i < this.numLayers) {
            result[i] = (Matrix)this.matrixArray[i].ebeAbs();
            ++i;
        }
        return new Matrix3D(result);
    }

    public Matrix3D getSubMatrix(int xStart, int xEnd, int yStart, int yEnd, int zStart, int zEnd) {
        Matrix3D subMatrix = new Matrix3D(xEnd - xStart + 1, yEnd - yStart + 1, zEnd - zStart + 1);
        int z = zStart;
        while (z < zEnd + 1) {
            Matrix layerSubMatrix = (Matrix)this.matrixArray[z].getSubMatrix(xStart, xEnd, yStart, yEnd);
            subMatrix.setLayer(layerSubMatrix, z - zStart);
            ++z;
        }
        return subMatrix;
    }

    public Matrix findIndicesLessThan(double val) {
        AbstractDoubleArray indexMatrix = null;
        Matrix xyzCoords = new Matrix(1, 3);
        int z = 0;
        while (z < this.numLayers) {
            int y = 0;
            while (y < this.numColumns) {
                int x = 0;
                while (x < this.numRows) {
                    double currentValue = this.get(x, y, z);
                    if (currentValue < val) {
                        xyzCoords.set(0, 0, x);
                        xyzCoords.set(0, 1, y);
                        xyzCoords.set(0, 2, z);
                        if (indexMatrix != null) {
                            indexMatrix.insertRowsEquals(indexMatrix.getRowDimension(), xyzCoords);
                        } else {
                            indexMatrix = (Matrix)xyzCoords.copy();
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return indexMatrix;
    }

    public ArrayList findIndicesLessThan_v2ArrayList(double val) {
        ArrayList<int[]> foundIndices = new ArrayList<int[]>();
        int z = 0;
        while (z < this.numLayers) {
            int y = 0;
            while (y < this.numColumns) {
                int x = 0;
                while (x < this.numRows) {
                    double currentValue = this.get(x, y, z);
                    if (currentValue < val) {
                        int[] xyzCoords = new int[]{x, y, z};
                        foundIndices.add(xyzCoords);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return foundIndices;
    }

    public Matrix getRandMinimum(double randNumber) {
        double currentValue;
        double currentMin = this.get(0, 0, 0);
        int z = 0;
        while (z < this.numLayers) {
            int y = 0;
            while (y < this.numColumns) {
                int x = 0;
                while (x < this.numRows) {
                    currentValue = this.get(x, y, z);
                    if (currentValue < currentMin) {
                        currentMin = currentValue;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        Vector<Matrix> minima = new Vector<Matrix>();
        int z2 = 0;
        while (z2 < this.numLayers) {
            int y = 0;
            while (y < this.numColumns) {
                int x = 0;
                while (x < this.numRows) {
                    currentValue = this.get(x, y, z2);
                    if (currentValue == currentMin) {
                        Matrix indexMatrix = new Matrix(1, 3);
                        indexMatrix.set(0, 0, x);
                        indexMatrix.set(0, 1, y);
                        indexMatrix.set(0, 2, z2);
                        minima.add(indexMatrix);
                    }
                    ++x;
                }
                ++y;
            }
            ++z2;
        }
        int chosenIndex = (int)Math.floor(randNumber * (double)minima.size());
        Matrix indexMatrix = (Matrix)minima.get(chosenIndex);
        return indexMatrix;
    }

    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.numLayers) {
            sum += this.matrixArray[i].sum().transpose().sum().toDouble();
            ++i;
        }
        return sum;
    }

    public void toCommandLine(String label) {
        System.out.println(label);
        int i = 0;
        while (i < this.numLayers) {
            this.matrixArray[i].toCommandLine("layer " + i + " =");
            ++i;
        }
    }
}

