/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

import graphics.Game;
import graphics.screens.BoardScreen;
import java.util.Date;
import org.jmat.data.Matrix;
import util.Constants;
import util.Utilities;

public class GameTurn {
    private Game game;
    private BoardScreen boardScreen;
    private int turnNumber = 0;
    private int[] numbers;
    private int[][] subNumbers;
    private String[] operators;
    private int additionSide;
    private boolean deadlineTrial = false;
    private double currentDeadline = 0.0;
    private int notationLevel;
    private boolean controlDensity;
    private Matrix difficulty;
    private Matrix convDifficulty;
    private Matrix coordsChosen;
    private double desiredDifficulty;
    private double meanSuccess;
    private double estimatedDifficulty;
    private Date turnStartTime;
    private byte responseSide = (byte)2;
    private byte responseCorrect = 0;
    private long RT = 0L;
    private int relNetGain = 0;
    private int[] netGain = new int[2];
    private int[] squaresMovedForward = new int[2];
    private int[] squaresMovedBack = new int[2];
    private int h_relNetGain = 0;
    private int[] h_netGain = new int[2];
    private int[] h_squaresMovedForward = new int[2];
    private int[] h_squaresMovedBack = new int[2];
    private int preTurnInterPlayerDistance = 0;
    private int postTurnInterPlayerDistance = 0;
    private byte actualWinner = (byte)2;
    public static final String[] controlFor = new String[]{"density", "itemSize"};
    private static String[] titles = new String[]{"Speed: ", "Dist: ", "Notn: "};

    public GameTurn(int turnNumber, BoardScreen boardScreen, Game game) {
        this.turnNumber = turnNumber;
        this.boardScreen = boardScreen;
        this.game = game;
        this.preTurnInterPlayerDistance = boardScreen.players[0].getBoardSquare() - boardScreen.players[1].getBoardSquare();
        this.subNumbers = new int[2][2];
        this.operators = new String[2];
    }

    public void startTurn() {
        this.turnStartTime = this.game.getDate();
    }

    public void calculateActualWinner() {
        int[] simBoardLocations = new int[]{this.boardScreen.players[0].getBoardSquare(), this.boardScreen.players[1].getBoardSquare()};
        this.squaresMovedForward[0] = this.numbers[this.responseSide];
        this.squaresMovedForward[1] = this.numbers[Utilities.oppositeSide(this.responseSide)];
        int i = 0;
        while (i < 2) {
            int n = i;
            simBoardLocations[n] = simBoardLocations[n] + this.squaresMovedForward[i];
            while (true) {
                if (simBoardLocations[i] == simBoardLocations[Utilities.otherPlayer((byte)i)]) {
                    byte by = Utilities.otherPlayer((byte)i);
                    simBoardLocations[by] = simBoardLocations[by] - 1;
                    while (this.boardScreen.hazardManager.movementDueToHazard(simBoardLocations[Utilities.otherPlayer((byte)i)]) < 0) {
                        byte by2 = Utilities.otherPlayer((byte)i);
                        simBoardLocations[by2] = simBoardLocations[by2] + this.boardScreen.hazardManager.movementDueToHazard(simBoardLocations[Utilities.otherPlayer((byte)i)]);
                    }
                }
                if (this.boardScreen.hazardManager.movementDueToHazard(simBoardLocations[i]) >= 0) break;
                int n2 = i;
                simBoardLocations[n2] = simBoardLocations[n2] + this.boardScreen.hazardManager.movementDueToHazard(simBoardLocations[i]);
            }
            ++i;
        }
        this.netGain[0] = simBoardLocations[0] - this.boardScreen.players[0].getBoardSquare();
        this.netGain[1] = simBoardLocations[1] - this.boardScreen.players[1].getBoardSquare();
        this.squaresMovedBack[0] = this.squaresMovedForward[0] - this.netGain[0];
        this.squaresMovedBack[1] = this.squaresMovedForward[1] - this.netGain[1];
        this.relNetGain = this.netGain[0] - this.netGain[1];
        this.calculateHypotheticalWinner((byte)Utilities.oppositeSide(this.responseSide), this.boardScreen);
        this.actualWinner = this.relNetGain >= this.h_relNetGain || this.responseCorrect == 1 ? (byte)0 : 1;
    }

    public void calculateHypotheticalWinner(byte responseSide, BoardScreen boardScreen) {
        int[] simBoardLocations = new int[]{boardScreen.players[0].getBoardSquare(), boardScreen.players[1].getBoardSquare()};
        this.h_squaresMovedForward[0] = this.numbers[responseSide];
        this.h_squaresMovedForward[1] = this.numbers[Utilities.oppositeSide(responseSide)];
        int i = 0;
        while (i < 2) {
            int n = i;
            simBoardLocations[n] = simBoardLocations[n] + this.h_squaresMovedForward[i];
            while (true) {
                if (simBoardLocations[i] == simBoardLocations[Utilities.otherPlayer((byte)i)]) {
                    byte by = Utilities.otherPlayer((byte)i);
                    simBoardLocations[by] = simBoardLocations[by] - 1;
                    while (boardScreen.hazardManager.movementDueToHazard(simBoardLocations[Utilities.otherPlayer((byte)i)]) < 0) {
                        byte by2 = Utilities.otherPlayer((byte)i);
                        simBoardLocations[by2] = simBoardLocations[by2] + boardScreen.hazardManager.movementDueToHazard(simBoardLocations[Utilities.otherPlayer((byte)i)]);
                    }
                }
                if (boardScreen.hazardManager.movementDueToHazard(simBoardLocations[i]) >= 0) break;
                int n2 = i;
                simBoardLocations[n2] = simBoardLocations[n2] + boardScreen.hazardManager.movementDueToHazard(simBoardLocations[i]);
            }
            ++i;
        }
        this.h_netGain[0] = simBoardLocations[0] - boardScreen.players[0].getBoardSquare();
        this.h_netGain[1] = simBoardLocations[1] - boardScreen.players[1].getBoardSquare();
        this.h_squaresMovedBack[0] = this.h_squaresMovedForward[0] - this.h_netGain[0];
        this.h_squaresMovedBack[1] = this.h_squaresMovedForward[1] - this.h_netGain[1];
        this.h_relNetGain = this.h_netGain[0] - this.h_netGain[1];
    }

    public Date getTurnStartTime() {
        return this.turnStartTime;
    }

    public double getMeanSuccess() {
        return this.meanSuccess;
    }

    public void setMeanSuccess(double meanSucc) {
        this.meanSuccess = meanSucc;
    }

    public double getEstimatedDiff() {
        return this.estimatedDifficulty;
    }

    public void setEstimatedDiff(double diff) {
        this.estimatedDifficulty = diff;
    }

    public String getCoordsChosenCommaDelim() {
        String commaDelimStr = "";
        int i = 0;
        while (i < 3) {
            commaDelimStr = commaDelimStr.concat(String.valueOf(String.valueOf(this.coordsChosen.get(0, i))) + ",");
            ++i;
        }
        return commaDelimStr;
    }

    public void setCoordsChosen(Matrix coordsChosen) {
        this.coordsChosen = coordsChosen;
    }

    public double getCurrDesiredDiff() {
        return this.desiredDifficulty;
    }

    public void setCurrDesiredDiff(double diff) {
        this.desiredDifficulty = diff;
    }

    public String getCurrDesiredDiffForPrompt() {
        String str = "";
        str = str.concat(String.valueOf(Utilities.round(this.desiredDifficulty, 2)));
        return str;
    }

    public String getDiffLvlsCommaDelim() {
        String commaDelimStr = "";
        int i = 0;
        while (i < 3) {
            commaDelimStr = commaDelimStr.concat(String.valueOf(String.valueOf(this.difficulty.get(0, i))) + ",");
            ++i;
        }
        return commaDelimStr;
    }

    public String getDiffLvlsForPrompt() {
        String promptStr = "";
        int i = 0;
        while (i < 3) {
            promptStr = promptStr.concat(String.valueOf(titles[i]) + String.valueOf(Utilities.round(this.difficulty.get(0, i), 2)) + "  ");
            ++i;
        }
        return promptStr;
    }

    public String getConvDiffLvlsCommaDelim() {
        String commaDelimStr = "";
        int i = 0;
        while (i < 3) {
            commaDelimStr = commaDelimStr.concat(String.valueOf(String.valueOf(this.convDifficulty.get(0, i))) + ",");
            ++i;
        }
        return commaDelimStr;
    }

    public String getConvDiffLvlsForPrompt() {
        String promptStr = "";
        int i = 0;
        while (i < 3) {
            promptStr = promptStr.concat(String.valueOf(titles[i]) + String.valueOf(Utilities.round(this.convDifficulty.get(0, i), 2)) + "  ");
            ++i;
        }
        return promptStr;
    }

    public byte getActualWinner() {
        return this.actualWinner;
    }

    public byte getFinalCorrect() {
        if (this.actualWinner == 0) {
            return 1;
        }
        return 0;
    }

    public String getFinalCorrectStr() {
        if (this.actualWinner == 0) {
            return "1";
        }
        return "0";
    }

    public void setActualWinner(byte player) {
        this.actualWinner = player;
    }

    public String getRelativeGainInfo() {
        return String.valueOf(this.relNetGain) + "," + this.netGain[0] + "," + this.netGain[1] + "," + this.squaresMovedForward[0] + "," + this.squaresMovedForward[1] + "," + this.squaresMovedBack[0] + "," + this.squaresMovedBack[1] + "," + this.boardScreen.players[0].getBoardSquare() + "," + this.boardScreen.players[1].getBoardSquare() + ",";
    }

    public String getHypRelativeGainInfo() {
        return String.valueOf(this.h_relNetGain) + "," + this.h_netGain[0] + "," + this.h_netGain[1] + "," + this.h_squaresMovedForward[0] + "," + this.h_squaresMovedForward[1] + "," + this.h_squaresMovedBack[0] + "," + this.h_squaresMovedBack[1] + ",";
    }

    public byte getResponseSide() {
        return this.responseSide;
    }

    public String getResponseSideString() {
        return Constants.sides[this.responseSide];
    }

    public long getRT() {
        return this.RT;
    }

    public String getRTStr() {
        return String.valueOf(this.RT);
    }

    public void setRT(long rt) {
        this.RT = rt;
    }

    public byte getResponseCorrect() {
        return this.responseCorrect;
    }

    public String getResponseCorrectStr() {
        return Constants.correct[this.responseCorrect];
    }

    public void setResponseCorrect(byte status) {
        this.responseCorrect = status;
    }

    public void setResponseSide(byte respSide) {
        this.responseSide = respSide;
    }

    public int getPostTurnInterPlayerDistance() {
        return this.postTurnInterPlayerDistance;
    }

    public void setPostTurnInterPlayerDistance(int value) {
        this.postTurnInterPlayerDistance = value;
    }

    public int getPreTurnInterPlayerDistance() {
        return this.preTurnInterPlayerDistance;
    }

    public void setPreTurnInterPlayerDistance(int value) {
        this.preTurnInterPlayerDistance = value;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public String[] getOperators() {
        return this.operators;
    }

    public void setOperators(String[] operators) {
        this.operators = operators;
    }

    public int getAdditionSide() {
        return this.additionSide;
    }

    public void setAdditionSide(int additionSide) {
        this.additionSide = additionSide;
    }

    public int[][] getSubNumbers() {
        return this.subNumbers;
    }

    public int getSubNumber(int i, int j) {
        return this.subNumbers[i][j];
    }

    public void setSubNumbers(int[][] subNumbers) {
        this.subNumbers = subNumbers;
    }

    public String getSubNumbersAndOpsCommaDelim() {
        return String.valueOf(String.valueOf(this.subNumbers[0][0])) + "," + this.operators[0] + "," + String.valueOf(this.subNumbers[0][1]) + "," + String.valueOf(this.subNumbers[1][0]) + "," + this.operators[1] + "," + String.valueOf(this.subNumbers[1][1]) + ",";
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    public int getNumber(int i) {
        return this.numbers[i];
    }

    public String getNumbersCommaDelim() {
        return String.valueOf(String.valueOf(this.numbers[0])) + "," + String.valueOf(this.numbers[1]) + ",";
    }

    public void setNumbers(int[] numbers) {
        this.numbers = numbers;
    }

    public boolean getControlDensity() {
        return this.controlDensity;
    }

    public int getControlDensityInt() {
        if (this.controlDensity) {
            return 1;
        }
        return 0;
    }

    public String getControlDensityStr() {
        return controlFor[this.getControlDensityInt()];
    }

    public void setControlDensity(boolean state) {
        this.controlDensity = state;
    }

    public int getCurrentNotnLevel() {
        return this.notationLevel;
    }

    public void setCurrentNotnLevel(int level) {
        this.notationLevel = level;
    }

    public Matrix getConvCurrDifficulty() {
        return this.convDifficulty;
    }

    public void setConvCurrDifficulty(Matrix convDifficulty) {
        this.convDifficulty = convDifficulty;
    }

    public Matrix getCurrentDifficulty() {
        return this.difficulty;
    }

    public void setCurrentDifficulty(Matrix difficulty) {
        this.difficulty = difficulty;
    }

    public boolean isDeadlineTrial() {
        return this.deadlineTrial;
    }

    public void setDeadlineTrial(boolean state) {
        this.deadlineTrial = state;
    }

    public double getCurrentDeadline() {
        return this.currentDeadline;
    }

    public void setCurrentDeadline(double deadline) {
        this.currentDeadline = deadline;
    }
}

