/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

public class AdapDimensions {
    public static final int NUM_ADAP_DIMS = 3;
    public static final int XMIN = 2;
    public static final int YMIN = 1;
    public static final int XMAX_RESTR_RANGE = 5;
    public static final int XMAX_FULL_RANGE = 9;
    public static final int NUM_NOT_DIMENSIONS = 14;
    public static final double DEADLINE_DECR_RATE = 0.001;
    public static final double DEADLINE_MIN = 0.25;
    public static final int DEADLINE_MAX = 10;
    public static final double DEADLINE_ALPHA = 0.3;
    public static final double DEADLINE_RIGHTSHIFT = Math.log(0.10256410256410256) / Math.log(0.001) + 0.3;
    public static final double MAX_DIST_RATIO = 2.0;
    public static final byte SPEED_DIM = 0;
    public static final byte DIST_DIM = 1;
    public static final byte NOTN_DIM = 2;

    public static double speedDimension(double ds) {
        return Math.pow(0.001, ds - DEADLINE_RIGHTSHIFT) + 0.25;
    }

    public static int[] distDimension(double dd, double randx, boolean rstrRnge, Double weberFraction) {
        int[] xyValues;
        xyValues = new int[]{rstrRnge ? (int)Math.floor(4.0 * randx + 2.0) : (int)Math.floor(8.0 * randx + 2.0), (int)Math.min(Math.floor((double)xyValues[0] * Math.pow(2.0, dd - 1.0)), (double)(xyValues[0] - 1))};
        weberFraction = new Double((xyValues[1] - xyValues[0]) / xyValues[0]);
        return xyValues;
    }

    public static int notnDimension(double dn) {
        int zValue = (int)Math.floor(dn * 14.0);
        if (zValue == 14) {
            --zValue;
        }
        return zValue;
    }
}

