/*
 * Decompiled with CFR 0.152.
 */
package util;

import graphics.screens.ChoiceScreen;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class Utilities {
    public static int oppositeSide(int side) {
        return (side + 1) % 2;
    }

    public static byte otherPlayer(byte player) {
        byte otherPlayer = 9;
        if (player == 0) {
            otherPlayer = 1;
        } else if (player == 1) {
            otherPlayer = 0;
        }
        return otherPlayer;
    }

    public static String getVerbalForArabic(int arabicNumber) {
        String[] numberWords = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
        String returnValue = numberWords[arabicNumber];
        return returnValue;
    }

    public static int int4Bool(boolean bool) {
        if (bool) {
            return 1;
        }
        return 0;
    }

    public static void drawFromPoint(String text, Point xy, int relativeToX, int relativeToY, Graphics g) {
        int x = xy.x;
        int y = xy.y;
        FontMetrics fm = g.getFontMetrics();
        int widthOffset = relativeToX < 0 ? 0 : (relativeToX == 0 ? -(fm.stringWidth(text) / 2) : -fm.stringWidth(text));
        int heightOffset = relativeToY < 0 ? fm.getAscent() : (relativeToY == 0 ? fm.getHeight() / 2 - fm.getDescent() : -fm.getDescent());
        g.drawString(text, x += widthOffset, y += heightOffset);
    }

    public static void drawFromPoint(String text, int x, int y, int relativeToX, int relativeToY, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int widthOffset = relativeToX < 0 ? 0 : (relativeToX == 0 ? -(fm.stringWidth(text) / 2) : -fm.stringWidth(text));
        int heightOffset = relativeToY < 0 ? fm.getAscent() : (relativeToY == 0 ? fm.getHeight() / 2 - fm.getDescent() : -fm.getDescent());
        g.drawString(text, x += widthOffset, y += heightOffset);
    }

    public static int writeParagraph(Graphics2D g2D, int width, AttributedString textLine, int xPos, int yPos) {
        float formatWidth = width;
        float drawPosY = 0.0f;
        float descent = 0.0f;
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(textLine.getIterator(), new FontRenderContext(null, false, false));
        AttributedCharacterIterator paragraph = textLine.getIterator();
        int paragraphStart = paragraph.getBeginIndex();
        int paragraphEnd = paragraph.getEndIndex();
        lineMeasurer.setPosition(paragraphStart);
        drawPosY += (float)yPos;
        while (lineMeasurer.getPosition() < paragraphEnd) {
            TextLayout layout = lineMeasurer.nextLayout(formatWidth);
            float drawPosX = xPos;
            drawPosX = layout.isLeftToRight() ? (drawPosX += 0.0f) : (drawPosX += formatWidth - layout.getAdvance());
            layout.draw(g2D, drawPosX, drawPosY += layout.getAscent());
            drawPosY += layout.getDescent() + layout.getLeading();
            descent = 2.0f * (layout.getDescent() + layout.getLeading());
        }
        return (int)(drawPosY + descent);
    }

    public static Image createImage(ChoiceScreen choiceScreen, int width, int height) {
        return choiceScreen.gc.createCompatibleImage(width, height, 2);
    }

    public static float calculateDistance(Point x, Point y) {
        float distance = (float)Math.sqrt(Math.pow(Math.abs(x.getX() - y.getX()), 2.0) + Math.pow(Math.abs(x.getY() - y.getY()), 2.0));
        return distance;
    }

    public static Point2D.Float calculateMovementVector(Point2D.Float origin, Point2D.Float destination) {
        Point2D.Float movementVector = new Point2D.Float((float)(destination.getX() - origin.getX()), (float)(destination.getY() - origin.getY()));
        return movementVector;
    }

    public static double round(double x, int decimalPlaces) {
        double y = Math.floor(x * Math.pow(10.0, decimalPlaces) + 0.5) / Math.pow(10.0, decimalPlaces);
        return y;
    }

    public static int searchStrArrStr(String[] strArr, String key) {
        int i = 0;
        while (i < strArr.length) {
            if (strArr[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String charac4id(int player) {
        if (player == 0) {
            return "friend1_";
        }
        if (player == 1) {
            return "enemy1_";
        }
        return null;
    }
}

