/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.io.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.jmat.io.files.DataFile;
import org.jmat.io.files.littleEndian.LittleEndianDataInputStream;
import org.jmat.io.files.littleEndian.LittleEndianDataOutputStream;

public class BinaryFile
extends DataFile {
    public static final String LITTLE_ENDIAN = "LITTLE_ENDIAN";
    public static final String BIG_ENDIAN = "BIG_ENDIAN";
    private boolean bigEndian;

    public BinaryFile(File f, String e) {
        super(f);
        this.bigEndian = BinaryFile.isBigEndian(e);
    }

    private static boolean isBigEndian(String os) {
        boolean be;
        if (os.equals(LITTLE_ENDIAN)) {
            be = false;
        } else if (os.equals(BIG_ENDIAN)) {
            be = true;
        } else {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("The Endian type : ").append(os).append("is unknown. You must specify LITTLE_ENDIAN or BIG_ENDIAN."))));
        }
        return be;
    }

    public static double[] readDoubleArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readDoubleArray();
    }

    public static float[] readFloatArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readFloatArray();
    }

    public static int[] readIntArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readIntArray();
    }

    public static void writeDoubleArray(File f, double[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeDoubleArray(array, false);
    }

    public static void appendDoubleArray(File f, double[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeDoubleArray(array, true);
    }

    public static void writeFloatArray(File f, float[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeFloatArray(array, false);
    }

    public static void appendFloatArray(File f, float[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeFloatArray(array, true);
    }

    public static void writeIntArray(File f, int[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeIntArray(array, false);
    }

    public static void appendIntArray(File f, int[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeIntArray(array, true);
    }

    public int[] readIntArray() {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInput dis = this.bigEndian ? new DataInputStream(bis) : new LittleEndianDataInputStream(bis);
            Vector<Integer> intV = new Vector<Integer>();
            try {
                while (true) {
                    int i = dis.readInt();
                    intV.add(new Integer(i));
                }
            }
            catch (EOFException eof) {
                bis.close();
                int[] array = new int[intV.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Integer)intV.get(i);
                }
                int[] nArray = array;
                return nArray;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
    }

    public float[] readFloatArray() {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInput dis = this.bigEndian ? new DataInputStream(bis) : new LittleEndianDataInputStream(bis);
            Vector<Float> floatV = new Vector<Float>();
            try {
                while (true) {
                    float f = dis.readFloat();
                    floatV.add(new Float(f));
                }
            }
            catch (EOFException eof) {
                bis.close();
                float[] array = new float[floatV.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = ((Float)floatV.get(i)).floatValue();
                }
                float[] fArray = array;
                return fArray;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
    }

    public double[] readDoubleArray() {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInput dis = this.bigEndian ? new DataInputStream(bis) : new LittleEndianDataInputStream(bis);
            Vector<Double> doubleV = new Vector<Double>();
            try {
                while (true) {
                    double f = dis.readDouble();
                    doubleV.add(new Double(f));
                }
            }
            catch (EOFException eof) {
                bis.close();
                double[] array = new double[doubleV.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Double)doubleV.get(i);
                }
                double[] dArray = array;
                return dArray;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
    }

    public byte[] readByteArray() {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInput dis = this.bigEndian ? new DataInputStream(bis) : new LittleEndianDataInputStream(bis);
            Vector<Byte> bytesV = new Vector<Byte>();
            try {
                while (true) {
                    byte b = dis.readByte();
                    bytesV.add(new Byte(b));
                }
            }
            catch (EOFException eof) {
                bis.close();
                byte[] bytes = new byte[bytesV.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (Byte)bytesV.get(i);
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unreadable : ").append(e.toString()))));
        }
    }

    public void writeIntArray(int[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file, append);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutput dos = this.bigEndian ? new DataOutputStream(bos) : new LittleEndianDataOutputStream(bos);
            for (int i = 0; i < array.length; ++i) {
                dos.writeInt(array[i]);
            }
            bos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public void writeFloatArray(float[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file, append);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutput dos = this.bigEndian ? new DataOutputStream(bos) : new LittleEndianDataOutputStream(bos);
            for (int i = 0; i < array.length; ++i) {
                dos.writeFloat(array[i]);
            }
            bos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public void writeDoubleArray(double[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file, append);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutput dos = this.bigEndian ? new DataOutputStream(bos) : new LittleEndianDataOutputStream(bos);
            for (int i = 0; i < array.length; ++i) {
                dos.writeDouble(array[i]);
            }
            bos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public void writeByteArray(byte[] bytes, boolean append) {
        if (this.file.exists()) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Warning : the file ").append(this.file.getName()).append(" already exists !"))));
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file, append);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.write(bytes);
            dos.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(new StringBuffer("File ").append(this.file.getName()).append(" is unwritable : ").append(e.toString()))));
        }
    }

    public int readInt() {
        return this.readIntArray()[0];
    }

    public float readFloat() {
        return this.readFloatArray()[0];
    }

    public double readDouble() {
        return this.readDoubleArray()[0];
    }

    public byte readByte() {
        return this.readByteArray()[0];
    }

    public void writeIntArray(int i, boolean append) {
        this.writeIntArray(new int[]{i}, append);
    }

    public void writeFloat(float f, boolean append) {
        this.writeFloatArray(new float[]{f}, append);
    }

    public void writeDouble(double d, boolean append) {
        this.writeDoubleArray(new double[]{d}, append);
    }

    public void writeByte(byte b, boolean append) {
        this.writeByteArray(new byte[]{b}, append);
    }

    public static void main(String[] args) {
        double[] doubleArray = new double[10];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = Math.random();
        }
        BinaryFile.writeDoubleArray(new File("double.be.dat"), doubleArray, BIG_ENDIAN);
        double[] dABE = BinaryFile.readDoubleArray(new File("double.be.dat"), BIG_ENDIAN);
        for (int i = 0; i < dABE.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(doubleArray[i]))).append(" -> ").append(dABE[i]))));
        }
        BinaryFile.writeDoubleArray(new File("double.le.dat"), doubleArray, LITTLE_ENDIAN);
        double[] dALE = BinaryFile.readDoubleArray(new File("double.le.dat"), LITTLE_ENDIAN);
        for (int i = 0; i < dALE.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(doubleArray[i]))).append(" -> ").append(dALE[i]))));
        }
    }

    static {
        LITTLE_ENDIAN = LITTLE_ENDIAN;
        BIG_ENDIAN = BIG_ENDIAN;
    }
}

