/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plots;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Noteable;
import org.jmat.gui.plotObjects.Plotable;
import org.jmat.gui.plotObjects.RelativeCoord;

public abstract class Plot
implements Plotable,
Noteable {
    public int dot_radius = 2;
    protected String name;
    protected Base base;
    protected AbstractMatrix datas;
    protected Color color;
    protected boolean noteEachCoord = false;

    public Plot(AbstractMatrix d, Color c, String n, Base b) {
        this.name = n;
        this.datas = d;
        this.base = b;
        this.color = c;
        this.base = b;
    }

    public void setNoteEachCoord(boolean nec) {
        this.noteEachCoord = nec;
    }

    public void setDatas(Matrix d) {
        this.datas = d;
    }

    public AbstractMatrix getDatas() {
        return this.datas;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public RelativeCoord[] getCoords() {
        RelativeCoord[] coords = new RelativeCoord[this.datas.getRowDimension()];
        for (int i = 0; i < this.datas.getRowDimension(); ++i) {
            coords[i] = new RelativeCoord(this.datas.toDoubleRowArray(i), this.base);
        }
        return coords;
    }

    public boolean tryNote(int[] screenCoord) {
        RelativeCoord[] coords = this.getCoords();
        for (int i = 0; i < coords.length; ++i) {
            if (!coords[i].tryNote(screenCoord)) continue;
            return true;
        }
        return false;
    }

    public boolean tryNote(int[] screenCoord, Graphics comp) {
        RelativeCoord[] coords = this.getCoords();
        if (this.noteEachCoord) {
            for (int i = 0; i < coords.length; ++i) {
                if (!coords[i].tryNote(screenCoord, comp)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < coords.length; ++i) {
            if (!coords[i].tryNote(screenCoord)) continue;
            this.note(comp);
            comp.setColor(Color.black);
            comp.drawString(this.name, screenCoord[0], screenCoord[1]);
            return true;
        }
        return false;
    }

    public abstract void note(Graphics var1);

    public abstract void plot(Graphics var1, Color var2);

    public void plot(Graphics comp) {
        this.plot(comp, this.color);
    }

    protected void drawLine(double[] pC1, double[] pC2, Graphics2D comp2D) {
        RelativeCoord c1 = new RelativeCoord(pC1, this.base);
        RelativeCoord c2 = new RelativeCoord(pC2, this.base);
        this.drawLine(c1, c2, comp2D);
    }

    protected void drawLargeLine(double[] pC1, double[] pC2, Graphics2D comp2D) {
        RelativeCoord c1 = new RelativeCoord(pC1, this.base);
        RelativeCoord c2 = new RelativeCoord(pC2, this.base);
        this.drawLargeLine(c1, c2, comp2D);
    }

    protected void drawDot(double[] pC, Graphics2D comp2D) {
        RelativeCoord c = new RelativeCoord(pC, this.base);
        this.drawDot(c, this.dot_radius, comp2D);
    }

    protected void drawDot(double[] pC, int radius, Graphics2D comp2D) {
        RelativeCoord c = new RelativeCoord(pC, this.base);
        this.drawDot(c, radius, comp2D);
    }

    protected void drawPloygon(double[][] pC, Graphics2D comp2D) {
        Coord[] c = new RelativeCoord[pC.length];
        for (int i = 0; i < pC.length; ++i) {
            c[i] = new RelativeCoord(pC[i], this.base);
        }
        this.drawPloygon(c, comp2D);
    }

    protected void fillPloygon(double[][] pC, Graphics2D comp2D) {
        Coord[] c = new RelativeCoord[pC.length];
        for (int i = 0; i < pC.length; ++i) {
            c[i] = new RelativeCoord(pC[i], this.base);
        }
        this.fillPloygon(c, comp2D);
    }

    protected void drawLargeLine(Coord c1, Coord c2, Graphics2D comp2D) {
        comp2D.drawLine(c1.getScreenCoordCopy()[0] + 1, c1.getScreenCoordCopy()[1], c2.getScreenCoordCopy()[0] + 1, c2.getScreenCoordCopy()[1]);
        comp2D.drawLine(c1.getScreenCoordCopy()[0] - 1, c1.getScreenCoordCopy()[1], c2.getScreenCoordCopy()[0] - 1, c2.getScreenCoordCopy()[1]);
        comp2D.drawLine(c1.getScreenCoordCopy()[0], c1.getScreenCoordCopy()[1] + 1, c2.getScreenCoordCopy()[0], c2.getScreenCoordCopy()[1] + 1);
        comp2D.drawLine(c1.getScreenCoordCopy()[0], c1.getScreenCoordCopy()[1] - 1, c2.getScreenCoordCopy()[0], c2.getScreenCoordCopy()[1] - 1);
    }

    protected void drawLine(Coord c1, Coord c2, Graphics2D comp2D) {
        comp2D.drawLine(c1.getScreenCoordCopy()[0], c1.getScreenCoordCopy()[1], c2.getScreenCoordCopy()[0], c2.getScreenCoordCopy()[1]);
    }

    protected void drawDot(Coord c, int radius, Graphics2D comp2D) {
        comp2D.fillOval(c.getScreenCoordCopy()[0] - radius, c.getScreenCoordCopy()[1] - radius, 2 * radius, 2 * radius);
    }

    protected void drawPloygon(Coord[] c, Graphics2D comp2D) {
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i].getScreenCoordCopy()[0];
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i].getScreenCoordCopy()[1];
        }
        comp2D.drawPolygon(x, y, x.length);
    }

    protected void fillPloygon(Coord[] c, Graphics2D comp2D) {
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i].getScreenCoordCopy()[0];
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i].getScreenCoordCopy()[1];
        }
        comp2D.fillPolygon(x, y, x.length);
    }
}

