/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.plotObjects;

import java.awt.Color;
import java.awt.Graphics;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.BaseLabel;
import org.jmat.gui.plotObjects.BaseScalesDependant;
import org.jmat.gui.plotObjects.Coord;
import org.jmat.gui.plotObjects.Label;
import org.jmat.gui.plotObjects.Line;
import org.jmat.gui.plotObjects.Plotable;
import org.jmat.gui.plotObjects.RelativeCoord;

public class Axe
implements Plotable,
BaseScalesDependant {
    public int linear_slicing;
    public double label_offset;
    protected int index;
    protected Base base;
    protected double[] linesSlicing;
    protected double[] labelsSlicing;
    protected String name;
    protected Coord origin;
    protected Coord end;
    protected Line darkLine;
    protected Line[][] lightLines;
    protected Label darkLabel;
    protected Label[] lightLabels;

    public Axe(Base b, String aS, int i) {
        this.base = b;
        this.name = aS;
        this.index = i;
        this.linear_slicing = 10;
        this.label_offset = 0.05;
        this.updateBase();
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    private void setOriginEnd() {
        this.origin = new RelativeCoord(this.base.getCoords()[0].getPlotCoordCopy(), this.base);
        this.end = new RelativeCoord(this.base.getCoords()[this.index + 1].getPlotCoordCopy(), this.base);
    }

    private void setSlicing() {
        block5: {
            block4: {
                int i;
                if (this.base.getAxeScale(this.index) != 1) break block4;
                int numPow10 = (int)Math.rint(Math.log(this.base.getMaxBounds()[this.index] / this.base.getMinBounds()[this.index]) / Math.log(10.0));
                double minPow10 = Math.rint(Math.log(this.base.getMinBounds()[this.index]) / Math.log(10.0));
                this.linesSlicing = new double[numPow10 * 9 + 1];
                this.labelsSlicing = new double[numPow10 + 1];
                for (i = 0; i < numPow10 + 1; ++i) {
                    this.labelsSlicing[i] = Math.pow(10.0, (double)i + minPow10);
                }
                for (i = 0; i < numPow10; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        this.linesSlicing[i * 9 + j] = Math.pow(10.0, (double)i + minPow10) * (double)(j + 1);
                    }
                }
                break block5;
            }
            if (this.base.getAxeScale(this.index) != 0) break block5;
            this.linesSlicing = new double[this.linear_slicing + 1];
            this.labelsSlicing = new double[this.linear_slicing + 1];
            double min = this.base.getMinBounds()[this.index];
            double pitch = (this.base.getCoords()[this.index + 1].getPlotCoordCopy()[this.index] - this.base.getCoords()[0].getPlotCoordCopy()[this.index]) / (double)this.linear_slicing;
            for (int i = 0; i < this.linear_slicing + 1; ++i) {
                this.linesSlicing[i] = min + (double)i * pitch;
                this.labelsSlicing[i] = min + (double)i * pitch;
            }
        }
    }

    public void plot(Graphics comp) {
        int i;
        for (i = 0; i < this.lightLines.length; ++i) {
            for (int j = 1; j < this.lightLines[i].length; ++j) {
                this.lightLines[i][j].plot(comp);
            }
        }
        for (i = 0; i < this.lightLabels.length; ++i) {
            this.lightLabels[i].plot(comp);
        }
        this.darkLine.plot(comp);
        this.darkLabel.plot(comp);
    }

    private void setLightLabels() {
        double[] labelOffset = new double[this.base.dimension];
        for (int i = 0; i < this.base.getDimension(); ++i) {
            if (i == this.index) continue;
            labelOffset[i] = -this.label_offset;
        }
        int decimal = 0;
        this.lightLabels = new Label[this.labelsSlicing.length];
        for (int i = 0; i < this.lightLabels.length; ++i) {
            RelativeCoord labelCoord = BaseLabel.buildRelativeCoord(labelOffset, this.base);
            labelCoord.setPlotCoord(this.labelsSlicing[i], this.index);
            if (this.base.getAxeScale(this.index) == 0) {
                decimal = -((int)(Math.log(this.base.getPrecisionUnit()[this.index] / (double)100) / Math.log(10.0)));
            } else if (this.base.getAxeScale(this.index) == 1) {
                decimal = -((int)Math.floor(Math.log(this.labelsSlicing[i]) / Math.log(10.0)));
            }
            String lab = new String(String.valueOf(String.valueOf(Label.approx(labelCoord.getPlotCoordCopy()[this.index], decimal))).concat(""));
            this.lightLabels[i] = new Label(lab, labelCoord, Color.lightGray);
        }
    }

    private void setLightLines() {
        this.lightLines = new Line[this.base.getDimension() - 1][this.linesSlicing.length];
        int i2 = 0;
        for (int i = 0; i < this.base.getDimension() - 1; ++i) {
            if (i2 == this.index) {
                ++i2;
            }
            for (int j = 0; j < this.lightLines[i].length; ++j) {
                double[] originCoord_tmp = this.origin.getPlotCoordCopy();
                double[] endCoord_tmp = this.base.getCoords()[i2 + 1].getPlotCoordCopy();
                originCoord_tmp[this.index] = this.linesSlicing[j];
                endCoord_tmp[this.index] = this.linesSlicing[j];
                RelativeCoord origin_tmp = new RelativeCoord(originCoord_tmp, this.base);
                RelativeCoord end_tmp = new RelativeCoord(endCoord_tmp, this.base);
                this.lightLines[i][j] = new Line(origin_tmp, end_tmp, Color.lightGray);
            }
            ++i2;
        }
    }

    private void setDarkLines() {
        this.darkLine = new Line(this.origin, this.end, Color.black);
    }

    private void setDarkLabels() {
        this.darkLabel = new Label(this.name, this.end, Color.black);
        this.darkLabel.setCorner(0.0, 0.0);
    }

    public void updateBase() {
        this.setOriginEnd();
        this.setSlicing();
        this.setDarkLines();
        this.setDarkLabels();
        this.setLightLines();
        this.setLightLabels();
    }
}

