/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jmat.gui.PlotPanel;

public class SetScalesFrame
extends JFrame {
    private PlotPanel plotPanel;
    private JPanel panel;

    public SetScalesFrame(PlotPanel p) {
        super("scales settings");
        this.plotPanel = p;
        this.setPanel();
        this.setContentPane(this.panel);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private void setPanel() {
        int nbAxes = this.plotPanel.getBase().getDimension();
        ((Component)this).setSize(nbAxes * 300, 200);
        this.panel = new JPanel();
        GridLayout gbl = new GridLayout(1, nbAxes);
        this.panel.setLayout(gbl);
        for (int i = 0; i < nbAxes; ++i) {
            ScalePanel s = new ScalePanel(this, this.plotPanel, i);
            this.panel.add(s);
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public class ScalePanel
    extends JPanel {
        private PlotPanel plotPanel;
        private int numAxe;
        private String title;
        private int scaleType;
        private double min;
        private double max;
        private JLabel title_label = new JLabel("Title");
        private JTextField title_field;
        private JLabel scale_label = new JLabel("Scale");
        private ButtonGroup scale_group = new ButtonGroup();
        private JRadioButton linear_check = new JRadioButton("Linear");
        private JRadioButton log_check = new JRadioButton("Logarithmic");
        private JLabel bounds_label = new JLabel("Bounds");
        private JLabel min_label = new JLabel("Min");
        private JLabel max_label = new JLabel("Max");
        private JTextField min_field;
        private JTextField max_field;
        private JButton bounds_auto = new JButton("Automatic");

        public ScalePanel(SetScalesFrame this$0, PlotPanel p, int i) {
            this.numAxe = i;
            this.plotPanel = p;
            this.title = this.plotPanel.getGrid().getLegend(this.numAxe);
            this.scaleType = this.plotPanel.getAxesScales()[this.numAxe];
            this.min = this.plotPanel.getBase().getMinBounds()[this.numAxe];
            this.max = this.plotPanel.getBase().getMaxBounds()[this.numAxe];
            this.setComponents();
            this.addComponents();
            this.setListeners();
        }

        private void setComponents() {
            this.title_field = new JTextField(this.title);
            this.scale_group.add(this.linear_check);
            this.scale_group.add(this.log_check);
            this.log_check.setSelected(this.scaleType == 1);
            this.linear_check.setSelected(this.scaleType == 0);
            this.min_field = new JTextField("".concat(String.valueOf(String.valueOf(this.min))));
            this.max_field = new JTextField("".concat(String.valueOf(String.valueOf(this.max))));
        }

        private void addComponents() {
            this.setSize(300, 200);
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gbl);
            this.buildConstraints(c, 0, 0, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.title_label, c);
            this.add(this.title_label);
            this.buildConstraints(c, 1, 0, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.title_field, c);
            this.add(this.title_field);
            this.buildConstraints(c, 0, 1, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.scale_label, c);
            this.add(this.scale_label);
            this.buildConstraints(c, 1, 1, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.linear_check, c);
            this.add(this.linear_check);
            this.buildConstraints(c, 1, 2, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.log_check, c);
            this.add(this.log_check);
            this.buildConstraints(c, 0, 3, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.bounds_label, c);
            this.add(this.bounds_label);
            this.buildConstraints(c, 1, 3, 1, 1, 20, 20);
            c.fill = 10;
            c.fill = 10;
            gbl.setConstraints(this.min_label, c);
            this.add(this.min_label);
            this.buildConstraints(c, 2, 3, 1, 1, 50, 20);
            c.fill = 2;
            gbl.setConstraints(this.min_field, c);
            this.add(this.min_field);
            this.buildConstraints(c, 1, 4, 1, 1, 20, 20);
            c.fill = 10;
            c.fill = 10;
            gbl.setConstraints(this.max_label, c);
            this.add(this.max_label);
            this.buildConstraints(c, 2, 4, 1, 1, 50, 20);
            c.fill = 2;
            gbl.setConstraints(this.max_field, c);
            this.add(this.max_field);
            this.buildConstraints(c, 1, 5, 2, 1, 60, 20);
            c.fill = 10;
            gbl.setConstraints(this.bounds_auto, c);
            this.add(this.bounds_auto);
        }

        private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }

        private void setListeners() {
            this.title_field.addKeyListener(new KeyListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyReleased(KeyEvent e) {
                    ScalePanel.access$0(this.this$1);
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.log_check.addActionListener(new ActionListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ScalePanel.access$1(this.this$1);
                }
            });
            this.linear_check.addActionListener(new ActionListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ScalePanel.access$1(this.this$1);
                }
            });
            this.min_field.addKeyListener(new KeyListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyReleased(KeyEvent e) {
                    ScalePanel.access$2(this.this$1);
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.max_field.addKeyListener(new KeyListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyReleased(KeyEvent e) {
                    ScalePanel.access$2(this.this$1);
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.bounds_auto.addActionListener(new ActionListener(this){
                private final /* synthetic */ ScalePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ScalePanel.access$3(this.this$1);
                }
            });
        }

        public void toCommandLine(String s) {
            System.out.println(String.valueOf(String.valueOf(s)).concat(" : "));
            System.out.println("title = ".concat(String.valueOf(String.valueOf(this.title))));
            System.out.println("scaleType = ".concat(String.valueOf(String.valueOf(this.scaleType))));
            System.out.println("min = ".concat(String.valueOf(String.valueOf(this.min))));
            System.out.println("max = ".concat(String.valueOf(String.valueOf(this.max))));
        }

        private void setTitle() {
            this.plotPanel.setAxeLabel(this.numAxe, this.title_field.getText());
        }

        private void setBounds() {
            try {
                this.plotPanel.setFixedBounds(this.numAxe, Double.parseDouble(this.min_field.getText()), Double.parseDouble(this.max_field.getText()));
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showConfirmDialog(null, iae.getMessage(), "Error", -1, 0);
                this.updateBoundsFields();
            }
        }

        private void setScale() {
            try {
                this.plotPanel.setAxeScale(this.numAxe, this.log_check.isSelected() ? 1 : 0);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showConfirmDialog(null, iae.getMessage(), "Error", -1, 0);
                this.updateBoundsFields();
            }
        }

        private void setBoundsAuto() {
            this.plotPanel.setAutoBounds(this.numAxe);
            this.updateBoundsFields();
        }

        private void updateBoundsFields() {
            this.min = this.plotPanel.getBase().getMinBounds()[this.numAxe];
            this.max = this.plotPanel.getBase().getMaxBounds()[this.numAxe];
            this.min_field.setText("".concat(String.valueOf(String.valueOf(this.min))));
            this.max_field.setText("".concat(String.valueOf(String.valueOf(this.max))));
        }

        static /* synthetic */ void access$0(ScalePanel x$0) {
            x$0.setTitle();
        }

        static /* synthetic */ void access$1(ScalePanel x$0) {
            x$0.setScale();
        }

        static /* synthetic */ void access$2(ScalePanel x$0) {
            x$0.setBounds();
        }

        static /* synthetic */ void access$3(ScalePanel x$0) {
            x$0.setBoundsAuto();
        }
    }
}

