/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jmat.gui.DataPanel;
import org.jmat.gui.FrameView;
import org.jmat.io.files.ASCIIFile;

public class TextPanel
extends DataPanel {
    private StringBuffer text;
    private JTextArea textArea;

    public TextPanel(String s) {
        this.text = new StringBuffer(s);
        this.toWindow();
    }

    public void append(String t) {
        this.text.append(t);
        this.update();
    }

    public void toClipBoard() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.toString()), null);
        }
        catch (IllegalStateException e) {
            JOptionPane.showConfirmDialog(null, "Copy to clipboard failed : ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", -1, 0);
        }
    }

    public String toString() {
        return this.text.toString();
    }

    public void toASCIIFile(File file) {
        try {
            ASCIIFile.write(file, this.text.toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void toWindow() {
        this.textArea = new JTextArea(this.text.toString());
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, "Center");
    }

    public static void main(String[] args) {
        TextPanel tw = new TextPanel("essai...\nkljhkhkjh");
        new FrameView(tw);
        tw.append("-----------------------------");
    }
}

