/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.gui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;
import org.jmat.gui.PlotPanel;
import org.jmat.gui.plotObjects.Base;
import org.jmat.gui.plotObjects.Base3D;
import org.jmat.gui.plotObjects.Grid;
import org.jmat.gui.plots.BarPlot;
import org.jmat.gui.plots.BoxPlot3D;
import org.jmat.gui.plots.HistogramPlot3D;
import org.jmat.gui.plots.LinePlot;
import org.jmat.gui.plots.Plot;
import org.jmat.gui.plots.ScatterPlot;
import org.jmat.gui.plots.StaircasePlot;

public class Plot3DPanel
extends PlotPanel {
    public static final int ROTATION = 2;

    public Plot3DPanel() {
    }

    public Plot3DPanel(double[] min, double[] max, int[] axesScales, String[] axesLabels) {
        super(min, max, axesScales, axesLabels);
    }

    public Plot3DPanel(AbstractMatrix xy, String name, String type) {
        super(xy.min().getColumns(0, 2).toDoubleArray(), xy.max().getColumns(0, 2).toDoubleArray());
        this.addPlot(xy, name, type);
    }

    public void initBasenGrid(double[] min, double[] max, int[] axesScales, String[] axesLabels) {
        this.base = new Base3D(min, max, PlotPanel.panelSize, axesScales, Base.DEFAULT_BORDER);
        this.grid = new Grid(this.base, axesLabels);
    }

    public void initBasenGrid(double[] min, double[] max) {
        this.initBasenGrid(min, max, new int[]{0, 0, 0}, new String[]{"X", "Y", "Z"});
    }

    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 1.0, 1.0});
    }

    public void setAxesLabels(String Xlabel, String Ylabel, String Zlabel) {
        this.setAxesLabels(new String[]{Xlabel, Ylabel, Zlabel});
    }

    public void addPlot(AbstractMatrix XY, String name, String type, Color c) {
        Plot newPlot = null;
        if (type.equals("SCATTER")) {
            XY.checkColumnDimension(3);
            newPlot = new ScatterPlot(XY, c, name, this.base);
        } else if (type.equals("LINE")) {
            XY.checkColumnDimension(3);
            newPlot = new LinePlot(XY, c, name, this.base);
        } else if (type.equals("BAR")) {
            XY.checkColumnDimension(3);
            newPlot = new BarPlot(XY, c, name, this.base);
        } else if (type.equals("HISTOGRAM")) {
            XY.checkColumnDimension(5);
            newPlot = new HistogramPlot3D((Matrix)XY.getColumns(0, 2), (Matrix)XY.getColumns(3, 4), c, name, this.base);
        } else if (type.equals("BOX")) {
            XY.checkColumnDimension(9);
            newPlot = new BoxPlot3D((Matrix)XY.getColumns(0, 2), (Matrix)XY.getColumns(3, 8), c, name, this.base);
        } else if (type.equals("STAIRCASE")) {
            XY.checkColumnDimension(3);
            newPlot = new StaircasePlot(XY, c, name, this.base);
        } else {
            throw new IllegalArgumentException("Plot type is unknown : ".concat(String.valueOf(String.valueOf(type))));
        }
        this.addPlot(newPlot);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 1: {
                int[] t = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                this.base.translate(t);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
                break;
            }
            case 2: {
                int[] t = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
                ((Base3D)this.base).rotate(t, PlotPanel.panelSize, this.base.getBorder());
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
            }
        }
        this.repaint();
    }

    static {
        ROTATION = 2;
    }
}

