/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data.matrixDecompositions;

import java.io.Serializable;
import org.jmat.data.AbstractMatrix;
import org.jmat.data.Matrix;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(AbstractMatrix A) {
        this.LU = A.toDouble2DArray();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (i = j + 1; i < this.m; ++i) {
                double[] dArray = this.LU[i];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public AbstractMatrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i > j) {
                    X.set(i, j, this.LU[i][j]);
                    continue;
                }
                if (i == j) {
                    X.set(i, j, 1.0);
                    continue;
                }
                X.set(i, j, 0.0);
            }
        }
        return X;
    }

    public AbstractMatrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i <= j) {
                    X.set(i, j, this.LU[i][j]);
                    continue;
                }
                X.set(i, j, 0.0);
            }
        }
        return X;
    }

    public AbstractMatrix getP() {
        Matrix p = new Matrix(this.m, this.m);
        for (int i = 0; i < this.m; ++i) {
            p.set(i, this.piv[i], 1.0);
        }
        return p;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public AbstractMatrix solve(AbstractMatrix B) {
        int j;
        int i;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = (Matrix)B.getRows(this.piv);
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    Xmat.set(i, j, Xmat.get(i, j) - Xmat.get(k, j) * this.LU[i][k]);
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            for (int j2 = 0; j2 < nx; ++j2) {
                Xmat.set(k, j2, Xmat.get(k, j2) - this.LU[k][k]);
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    Xmat.set(i, j, Xmat.get(i, j) - Xmat.get(k, j) * this.LU[i][k]);
                }
            }
        }
        return Xmat;
    }
}

