/*
 * Decompiled with CFR 0.152.
 */
package org.jmat.data;

import org.jmat.data.Matrix;
import org.jmat.function.DoubleFunction;

public class RandomVariable {
    protected static double rand() {
        double x = Math.random();
        return x;
    }

    protected static int randInt(int i0, int i1) {
        double x = RandomVariable.rand();
        int i = i0 + new Double(Math.floor((double)(i1 - i0 + 1) * x)).intValue();
        return i;
    }

    public static double uniform(double min, double max) {
        double x = min + (max - min) * RandomVariable.rand();
        return x;
    }

    public static double dirac(double[] values, double[] prob) {
        double[] prob_cumul = new double[values.length];
        prob_cumul[0] = prob[0];
        for (int i = 1; i < values.length; ++i) {
            prob_cumul[i] = prob_cumul[i - 1] + prob[i];
        }
        double y = RandomVariable.rand();
        double x = 0.0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!(y > prob_cumul[i]) || !(y < prob_cumul[i + 1])) continue;
            x = values[i];
        }
        return x;
    }

    public static double normal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * RandomVariable.rand()) * Math.sqrt((double)-2 * Math.log(RandomVariable.rand()));
        return x;
    }

    public static double chi2(int n) {
        double x = 0.0;
        for (int i = 0; i < n; ++i) {
            double norm = RandomVariable.normal(0.0, 1.0);
            x += norm * norm;
        }
        return x;
    }

    public static double logNormal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * RandomVariable.rand()) * Math.sqrt((double)-2 * Math.log(RandomVariable.rand()));
        return x;
    }

    public static double exponential(double lambda) {
        double x = (double)-1 / lambda * Math.log(RandomVariable.rand());
        return x;
    }

    public static double triangular(double min, double max) {
        double x = min / (double)2 + (max - min) * RandomVariable.rand() / (double)2 + min / (double)2 + (max - min) * RandomVariable.rand() / (double)2;
        return x;
    }

    public static double triangular(double min, double med, double max) {
        double y = RandomVariable.rand();
        double x = y < (med - min) / (max - min) ? min + Math.sqrt(y * (max - min) * (med - min)) : max - Math.sqrt((1.0 - y) * (max - min) * (max - med));
        return x;
    }

    public static double beta(double a, double b) {
        double try_y;
        double try_x;
        while ((try_x = Math.pow(RandomVariable.rand(), 1.0 / a)) + (try_y = Math.pow(RandomVariable.rand(), 1.0 / b)) > 1.0) {
        }
        return try_x / (try_x + try_y);
    }

    public static double cauchy(double mu, double sigma) {
        double x = sigma * Math.tan(Math.PI * (RandomVariable.rand() - 0.5)) + mu;
        return x;
    }

    public static double weibull(double lambda, double c) {
        double x = Math.pow(-Math.log(1.0 - RandomVariable.rand()), 1.0 / c) / lambda;
        return x;
    }

    public static double rejection(DoubleFunction fun, double maxFun, double min, double max) {
        double try_y;
        double[] try_x = new double[]{min + RandomVariable.rand() * (max - min)};
        do {
            try_y = RandomVariable.rand() * maxFun;
        } while (fun.eval(new Matrix(try_x, 1)) < try_y);
        return try_x[0];
    }
}

