/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.Game;
import graphics.sprites.AnimatedObject;
import java.awt.Point;
import java.awt.geom.Point2D;

public abstract class Sprite
extends AnimatedObject {
    protected float destinationX;
    protected float destinationY;
    protected float vX;
    protected float vY;
    protected float x;
    protected float y;
    protected boolean moved = false;
    protected int deadline;
    protected int width;
    protected int height;

    public abstract void render();

    public void animate() {
    }

    public boolean isPointInBounds(Point point) {
        return (float)point.x > this.x - (float)(this.width / 2) && (float)point.x < this.x + (float)(this.width / 2) && (float)point.y > this.y - (float)(this.height / 2) && (float)point.y < this.y + (float)(this.height / 2);
    }

    protected float calculateDistanceX() {
        float _x = this.destinationX - this.getX();
        return _x;
    }

    protected float calculateDistanceY() {
        float _y = this.destinationY - this.getY();
        return _y;
    }

    public void adjustSpeed() {
        float _tmp = (float)this.deadline / 1000.0f * (float)Game.actualFrameRate;
        float speedX = 0.0f;
        float speedY = 0.0f;
        if (_tmp != 0.0f) {
            speedX = this.calculateDistanceX() / _tmp;
            speedY = this.calculateDistanceY() / _tmp;
        } else {
            speedX = this.calculateDistanceX();
            speedY = this.calculateDistanceY();
        }
        this.deadline = (int)((float)this.deadline - 1000.0f / (float)Game.actualFrameRate);
        if (this.deadline < 0) {
            this.deadline = 0;
            speedX = this.calculateDistanceX();
            speedY = this.calculateDistanceY();
        }
        this.setVelocity(speedX, speedY);
    }

    public void setDestination(Point2D.Float destinationToSet) {
        this.destinationX = destinationToSet.x;
        this.destinationY = destinationToSet.y;
    }

    public void setDestination(Point destinationToSet) {
        this.destinationX = destinationToSet.x;
        this.destinationY = destinationToSet.y;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setVelocity(float x, float y) {
        this.vX = x;
        this.vY = y;
    }

    public void setDeadline(int deadline) {
        this.deadline = deadline;
    }

    public void setX(int xPos) {
        this.x = xPos;
    }

    public void setY(int yPos) {
        this.y = yPos;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }
}

