/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.PlayerSprite;
import graphics.vars.GraphicsVariables;
import java.awt.Point;
import util.Utilities;

public class PlayerPiece
extends PlayerSprite {
    public static final int MOVE_TIME = 400;
    public static final int PAUSE_TIME = 200;
    private int originalSquare;
    public double xRelativeToBoardImage;
    private double interSquareDistance;
    private int boardSquare;
    private int squaresToMove;
    private int verbalCountingCounter;
    private boolean playedSound = false;
    private boolean autoMove = false;
    private boolean jumpedPosition = false;
    private boolean movingFromStartPoint;

    public PlayerPiece(BoardScreen boardScreen, ChoiceScreen choiceScreen, int square, Point location, double squareWidth, byte playerID, int characterID) {
        super(boardScreen, choiceScreen, location, playerID, characterID, "PlayerPiece");
        this.setBoardSquare(square);
        this.originalSquare = square;
        this.interSquareDistance = squareWidth;
        this.setVelocity((float)(squareWidth * 4.0 / 40.0), (float)(squareWidth * 4.0 / 40.0));
        this.squaresToMove = 0;
        this.setDestination(location);
        this.setPosition(location.x, location.y);
        this.originalLocation = location;
    }

    @Override
    public void animate(Screen screen) {
        super.animate();
        if (this.isActive() && !this.suspended && this.x == this.destinationX && this.y == this.destinationY && (this.moved || this.jumpedPosition)) {
            this.setActive(false);
            if (this.boardSquare == 40) {
                this.choiceScreen.ncm.playerWins(this);
                this.squaresToMove = 0;
            } else {
                if (this.squaresToMove < 0) {
                    ++this.squaresToMove;
                } else if (this.squaresToMove > 0) {
                    --this.squaresToMove;
                }
                if (this.squaresToMove == 0) {
                    boolean hazardCollision = this.boardScreen.hazardManager.checkForCollisions(this.playerID);
                    if (!hazardCollision) {
                        boolean playerCollision = this.checkForCollision();
                        if (!playerCollision) {
                            this.choiceScreen.game.delay(1000, "game.nextTaskInQueue(\"PlayerPiece.animate\")");
                        } else {
                            this.setActive(true);
                        }
                    } else {
                        this.setActive(true);
                    }
                } else if (this.squaresToMove != 0 && this.autoMove) {
                    if (this.squaresToMove > 0) {
                        this.moveSquare(1);
                        this.setActive(true);
                    } else if (this.squaresToMove < 0) {
                        this.moveSquare(-1);
                        this.setActive(true);
                    }
                }
            }
        }
        if (this.moved || this.jumpedPosition) {
            this.update();
        }
    }

    public boolean autoMoveSquares() {
        this.autoMove = true;
        this.suspended = true;
        if (this.squaresToMove > 0) {
            this.moveSquare(1);
        } else if (this.squaresToMove < 0) {
            this.moveSquare(-1);
        }
        return true;
    }

    public boolean moveSquares() {
        if (this.squaresToMove > 0) {
            this.moveSquare(1);
        }
        this.start();
        return true;
    }

    public boolean moveSquare(int squareDirection) {
        this.setDeadline(400);
        this.playedSound = false;
        ++this.verbalCountingCounter;
        if (this.getX() == (float)GraphicsVariables.PLAYER1_ICON_START_POINT.x && this.getY() == (float)GraphicsVariables.PLAYER1_ICON_START_POINT.y || this.getX() == (float)GraphicsVariables.PLAYER2_ICON_START_POINT.x && this.getY() == (float)GraphicsVariables.PLAYER2_ICON_START_POINT.y) {
            this.movingFromStartPoint = true;
        }
        this.setBoardSquare(this.boardSquare + squareDirection);
        Point newDestination = new Point(0, 0);
        this.boardScreen.numberBoard.getScreenPointforSquare(this.boardSquare, newDestination);
        this.setDestination(newDestination);
        if (this.boardSquare == 40) {
            this.boardScreen.game.delay(0, "game.soundManager.play(\"" + Utilities.charac4id(this.playerID) + Utilities.getVerbalForArabic(this.verbalCountingCounter) + "\")");
        } else if (this.squaresToMove > 1) {
            this.boardScreen.game.delay(0, "game.soundManager.play(\"" + Utilities.charac4id(this.playerID) + "counting_" + Utilities.getVerbalForArabic(this.verbalCountingCounter) + "\")");
        } else if (this.squaresToMove == 1) {
            this.boardScreen.game.delay(0, "game.soundManager.play(\"" + Utilities.charac4id(this.playerID) + Utilities.getVerbalForArabic(this.verbalCountingCounter) + "\")");
        } else if (this.squaresToMove < 1) {
            this.boardScreen.game.delay(0, "game.soundManager.play(\"" + this.noise + "\")");
        }
        if (!this.autoMove) {
            if (this.boardSquare - 1 > 0 && (this.boardSquare - 1) % 10 == 0 && squareDirection > 0 || this.boardSquare - 1 > 1 && (this.boardSquare - 1) % 10 == 1 && squareDirection < 0) {
                this.boardScreen.players[this.playerID].setPosition(newDestination.x, newDestination.y);
            }
        } else {
            this.setSuspended(true);
            if (this.boardSquare - 1 > 0 && (this.boardSquare - 1) % 10 == 0 && squareDirection > 0 || this.boardSquare + 1 > 0 && (this.boardSquare + 1) % 10 == 1 && squareDirection < 0) {
                this.boardScreen.game.delay(600, "boardScreen.players[" + this.playerID + "].jumpPosition(" + newDestination.x + "," + newDestination.y + ")");
            } else {
                this.boardScreen.game.delay(200, "boardScreen.players[" + this.playerID + "].setSuspended(false)");
            }
        }
        return true;
    }

    public boolean checkForCollision() {
        boolean hit = false;
        if (this.boardScreen.players[Utilities.otherPlayer((byte)this.playerID)].boardSquare == this.boardSquare) {
            this.boardScreen.players[Utilities.otherPlayer(this.playerID)].landedOn();
            hit = true;
        }
        return hit;
    }

    public void landedOn() {
        if (this.playerID == 0) {
            this.choiceScreen.game.soundManager.play("enemy1_youHaveToGoBack");
        } else if (this.playerID == 1) {
            this.choiceScreen.game.soundManager.play("enemy1_youSentMeBack");
        }
        this.boardScreen.players[this.playerID].setSquaresToMove(-1);
        this.boardScreen.players[this.playerID].autoMoveSquares();
        this.choiceScreen.game.delay(3000, "boardScreen.players[" + this.playerID + "].start()");
    }

    public void resetTurn() {
        this.squaresToMove = 0;
        this.verbalCountingCounter = 0;
        this.animationCycleCount = 0;
        this.setActive(false);
        this.setImageSuspended(false);
        this.setSuspended(false);
        this.autoMove = false;
        this.moved = false;
        this.changedImage = false;
        this.update();
    }

    public void resetGame() {
        this.setDestination(new Point(this.originalLocation.x, this.originalLocation.y));
        this.setPosition(this.originalLocation.x, this.originalLocation.y);
        this.setBoardSquare(this.originalSquare);
        this.resetTurn();
    }

    public void setSquaresToMove(int numSquares) {
        this.verbalCountingCounter = 0;
        this.squaresToMove = numSquares;
    }

    public void setBoardSquare(int square) {
        this.boardSquare = square;
    }

    public int getBoardSquare() {
        return this.boardSquare;
    }

    @Override
    public void update() {
        if (this.isReady()) {
            this.boardScreen.numberBoard.update();
            this.moved = false;
            this.changedImage = false;
            this.jumpedPosition = false;
        }
    }

    @Override
    public void setSuspended(boolean state) {
        super.setSuspended(state);
    }

    @Override
    public void setImageSuspended(boolean state) {
        super.setImageSuspended(state);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void jumpPosition(int x, int y) {
        this.setPosition(x, y);
        this.setSuspended(false);
        this.jumpedPosition = true;
    }

    @Override
    public boolean start() {
        super.start();
        return true;
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
    }
}

