/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.Game;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.PlayerSprite;
import graphics.vars.GraphicsVariables;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Random;
import util.Utilities;

public class PlayerIcon
extends PlayerSprite {
    private boolean sneaking;
    private byte movementDirection;
    private byte movementCounter;
    private byte actionCounter;
    private byte movementPhase;
    private final byte UP = 0;
    private final byte DOWN = 1;
    private final byte LEFT = (byte)2;
    private final byte RIGHT = (byte)3;
    private final byte MOVING_BELOW_CARPET = 0;
    private final byte NOT_MOVING = (byte)3;
    Random randomNumber;
    private int pixelStepCounter;

    public PlayerIcon(ChoiceScreen choiceScreen, BoardScreen boardScreen, Point location, byte playerID, int characID) {
        super(boardScreen, choiceScreen, location, playerID, characID, "PlayerIcon");
        this.setVelocity(0.0f, 0.0f);
        this.movementDirection = (byte)5;
        this.movementCounter = 0;
        this.actionCounter = 0;
        this.movementPhase = (byte)3;
    }

    @Override
    public void load() {
        super.load();
        this.randomNumber = new Random();
        this.randomNumber.setSeed(System.currentTimeMillis());
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(false);
            this.setVisible(true);
            return true;
        }
        return false;
    }

    public void startSneaking(int deadline) {
        this.pixelStepCounter = 0;
        this.setDeadline(deadline);
        this.movementPhase = 0;
        this.setDestination(GraphicsVariables.TOP_CENTER_SCREEN);
        Point2D.Float movementDirection = Utilities.calculateMovementVector(new Point2D.Float(this.getX(), this.getY()), new Point2D.Float(this.destinationX, this.destinationY));
        float distance = this.calculateDistanceX();
        float speedX = this.calculateDistanceX() / (float)((long)deadline / Game.actualFrameRate);
        float speedY = this.calculateDistanceY() / (float)((long)deadline / Game.actualFrameRate);
        deadline = (int)((long)deadline - 1000L / Game.actualFrameRate);
        this.setVelocity(speedX, speedY);
        this.setSneaking(true);
        this.setActive(true);
    }

    public void stopSneaking() {
        this.setActive(false);
        this.setSneaking(false);
        this.setDestination(new Point2D.Float(this.x, this.y));
        this.setVelocity(0.0f, 0.0f);
    }

    @Override
    public void animate(Screen screen) {
        super.animate();
        if (this.getX() >= (float)GraphicsVariables.TOP_CENTER_SCREEN.x) {
            this.setSneaking(false);
            this.setActive(false);
            this.movementPhase = (byte)3;
        }
        if (this.moved || this.changedImage) {
            this.update();
        }
    }

    @Override
    public void update() {
        if (this.isReady()) {
            if (this.choiceScreen.game.currentScreen == this.choiceScreen) {
                this.choiceScreen.setRendered(false);
            } else if (this.choiceScreen.game.currentScreen == this.boardScreen) {
                this.boardScreen.setRendered(false);
            }
            this.moved = false;
            this.changedImage = false;
        }
    }

    public void reset() {
        this.setPosition(this.originalLocation.x, this.originalLocation.y);
        this.setSneaking(false);
        this.movementCounter = 0;
        this.actionCounter = 0;
        this.movementDirection = (byte)5;
        this.currentImage = 0;
        this.setActive(false);
        this.setImageActive(false);
        this.setImageSuspended(false);
        this.setSuspended(false);
        this.animationCycleCount = 0;
        this.update();
    }

    public void setSneaking(boolean state) {
        this.sneaking = state;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public void setImageActive(boolean state) {
        this.imageActive = state;
    }

    @Override
    public void setSuspended(boolean state) {
        super.setSuspended(state);
    }

    @Override
    public void setImageSuspended(boolean state) {
        super.setImageSuspended(state);
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }
}

