/*
 * Decompiled with CFR 0.152.
 */
package graphics.sprites;

import graphics.managers.HazardManager;
import graphics.screens.BoardScreen;
import graphics.screens.ChoiceScreen;
import graphics.screens.Screen;
import graphics.sprites.GifSprite;
import java.awt.Graphics2D;
import java.awt.Point;
import util.Utilities;

public class HazardSprite
extends GifSprite {
    private byte id;
    private ChoiceScreen choiceScreen;
    private BoardScreen boardScreen;
    private HazardManager hazardManager;
    private int penaltyValue;
    static final String[] defaultFileNames = new String[]{"/resources/images/underWater/gameScreens/anemone3A.gif", "/resources/images/underWater/gameScreens/anemone3B.gif"};
    public int boardSquare;

    public HazardSprite(ChoiceScreen choiceScreen, BoardScreen boardScreen, HazardManager hazardManager, int square, Point location, double tileWidth, int penaltyValue, byte id) {
        super(location.x, location.y, defaultFileNames, (Screen)choiceScreen);
        this.setVisible(false);
        this.setActive(false);
        this.setImageSuspended(false);
        this.choiceScreen = choiceScreen;
        this.boardScreen = boardScreen;
        this.hazardManager = hazardManager;
        this.penaltyValue = penaltyValue;
        this.setDestination(new Point(location.x, location.y));
        this.setPosition(location.x, location.y);
        this.setSquare(this.boardSquare);
        this.numAnimationCycles = 6;
        this.animationCycleDelay = 300;
    }

    @Override
    public void load() {
        super.load();
        this.setReady(true);
    }

    @Override
    public void unload() {
        this.setReady(false);
        super.unload();
    }

    @Override
    public boolean start() {
        if (this.isReady()) {
            this.setActive(true);
            return true;
        }
        return false;
    }

    public void landedOn(byte player) {
        this.numAnimationCycles = 6;
        this.setImageActive(true);
        this.setImageSuspended(false);
        if (this.penaltyValue == -1) {
            this.choiceScreen.game.delay(800, "choiceScreen.game.soundManager.play(\"anemone1\")");
        } else if (this.penaltyValue == -2) {
            this.choiceScreen.game.delay(800, "choiceScreen.game.soundManager.play(\"anemone2\")");
        } else if (this.penaltyValue == -3) {
            this.choiceScreen.game.delay(800, "choiceScreen.game.soundManager.play(\"anemone3\")");
        }
        this.choiceScreen.game.soundManager.play(String.valueOf(Utilities.charac4id(player)) + "landedOnTrap");
        this.boardScreen.players[player].setSquaresToMove(this.penaltyValue);
        this.boardScreen.players[player].autoMoveSquares();
        this.choiceScreen.game.delay(1100, "boardScreen.players[" + player + "].start()");
    }

    @Override
    public void animate(Screen screen) {
    }

    @Override
    public void animateImage(Screen screen) {
        this.changedImage = false;
        if (!this.imageSuspended) {
            this.switchImage();
            this.changedImage = true;
            this.setImageSuspended(true);
            this.choiceScreen.game.delay(this.animationCycleDelay, "boardScreen.hazardManager.hazards[" + this.id + "].setImageSuspended(false)");
            ++this.animationCycleCount;
            if (this.animationCycleCount >= this.numAnimationCycles) {
                this.setImageActive(false);
                this.setImageSuspended(false);
                if (this.currentImage != 0) {
                    this.switchImage();
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.isReady() && this.getVisible()) {
            if (!this.isRendered()) {
                this.render();
            }
            g.drawImage(this.images[this.currentImage], (int)(this.x - (float)(this.width / 2)), (int)(this.y - (float)(this.height / 2)), this.width, this.height, null);
        }
    }

    public void setSquare(int square) {
        this.boardSquare = square;
        Point newPosition = new Point(0, 0);
        this.boardScreen.numberBoard.getScreenPointforSquare(square, newPosition);
        this.setPosition(newPosition.x, newPosition.y);
    }

    public void setPenaltyValue(int penaltyValue) {
        this.penaltyValue = penaltyValue;
        if (penaltyValue == -1) {
            this.fileNames[0] = this.hazardManager.hazardFiles[0][0];
            this.fileNames[1] = this.hazardManager.hazardFiles[0][1];
            this.reload();
        } else if (penaltyValue == -2) {
            this.fileNames[0] = this.hazardManager.hazardFiles[1][0];
            this.fileNames[1] = this.hazardManager.hazardFiles[1][1];
            this.reload();
        } else if (penaltyValue == -3) {
            this.fileNames[0] = this.hazardManager.hazardFiles[2][0];
            this.fileNames[1] = this.hazardManager.hazardFiles[2][1];
            this.reload();
        }
    }

    public void themeChanged() {
        this.reset();
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }

    public void reset() {
        this.setSquare(0);
        this.setPenaltyValue(0);
        this.setVisible(false);
        this.changedImage = false;
        this.setImageActive(false);
        this.setActive(false);
        this.setImageSuspended(false);
        this.animationCycleCount = 0;
        this.update();
    }

    @Override
    public void update() {
        if (this.isReady()) {
            this.boardScreen.hazardManager.update();
        }
    }

    public int getPenaltyValue() {
        return this.penaltyValue;
    }

    @Override
    public void setImageSuspended(boolean state) {
        super.setImageSuspended(state);
    }
}

