/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.others.GifButton;
import graphics.screens.Screen;
import graphics.vars.GraphicsVariables;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import util.Utilities;

public class ThemeChoiceScreen
extends Screen {
    public final Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public boolean timeToSwitchImage = false;
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    public static final int NUMBER_THEMES = 2;
    public static final boolean[] DEFAULT_ACCESS_PARAMS = new boolean[]{true, true};
    public GifButton theme1Button;
    public GifButton theme2Button;

    public ThemeChoiceScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = false;
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.theme1Button = new GifButton((Screen)this, GraphicsVariables.THEME_1_LOC, "/resources/images/common/titlePages/underwater300wide.gif");
        this.theme2Button = new GifButton((Screen)this, GraphicsVariables.THEME_2_LOC, "/resources/images/common/titlePages/jungle300wide.gif");
    }

    @Override
    public void load() {
        super.load();
        this.theme1Button.load();
        this.theme2Button.load();
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.soundManager.stopAllSounds();
        this.game.soundManager.play("chooseTheme");
        super.start();
    }

    @Override
    public void process() {
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                g2D.setColor(this.DEFAULT_SCREEN_COLOR);
                g2D.fill(this.getBounds());
                this.theme1Button.paint(g2D);
                this.theme2Button.paint(g2D);
                g2D.setColor(Color.BLACK);
                g2D.setFont(this.game.themeVars.characChoiceTitleFont);
                Utilities.drawFromPoint("Scegli il mondo dove vuoi giocare", GraphicsVariables.THEME_TITLE_LOC, 0, -1, g2D);
                this.setPainted(false);
            } else if (this.loading) {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.theme1Button.unload();
        this.theme2Button.unload();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            int themeSelected = 9;
            boolean wasThemeSelected = false;
            if (this.theme1Button.isPointInBounds(this.mousePoint)) {
                this.theme1Button.selected();
                wasThemeSelected = true;
                this.game.setTheme((byte)0);
            } else if (this.theme2Button.isPointInBounds(this.mousePoint)) {
                this.theme2Button.selected();
                wasThemeSelected = true;
                this.game.setTheme((byte)1);
            }
            if (wasThemeSelected) {
                this.respondOnEvent = false;
                this.game.delay(1000, "game.changeCurrentScreen(game.instrucScreen)");
            }
        }
    }
}

