/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import util.ImageFactory;
import util.Utilities;

public abstract class Screen
extends JPanel
implements MouseListener,
KeyListener {
    public Game game;
    public GraphicsConfiguration gc;
    public GraphicsDevice gd;
    public boolean loading = true;
    public boolean painted = false;
    public boolean respondOnEvent;
    public boolean rendered = true;
    protected boolean imageChanged;
    public boolean readyToProcess = false;
    protected Color screenBackground;
    protected Image backBuffer;
    protected Graphics2D bbGraphics;
    protected boolean hasBackgroundImages = false;
    protected String[] backgroundImageFiles;
    protected int currentBackgroundImage = 0;
    protected StringBuffer lblTranslation;
    protected boolean hasAnimations = false;
    protected List animationList;
    protected boolean hasSounds = false;
    protected String backgroundSoundtrack;
    protected String[] screenSoundKeys;
    private Object lockObject = new Object();
    private Image backgroundImage = null;

    public Screen(Rectangle bounds, Game game, Image backBuffer) {
        this.game = game;
        this.setLayout(null);
        this.setBounds(bounds);
        this.setIgnoreRepaint(true);
        this.setDoubleBuffered(false);
        this.gd = game.gd;
        this.gc = game.gc;
        this.backBuffer = backBuffer;
        this.bbGraphics = (Graphics2D)backBuffer.getGraphics();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.lblTranslation = new StringBuffer(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (!this.painted && this.readyToProcess) {
            Graphics2D g2D = (Graphics2D)g;
            Object object = this.lockObject;
            synchronized (object) {
                g2D.drawImage(this.backBuffer, 0, 0, this);
            }
        }
    }

    public void setCurrentBgImage(int value) {
        if (this.hasBackgroundImages) {
            if (value < this.backgroundImageFiles.length) {
                this.currentBackgroundImage = value;
            }
            this.imageChanged = true;
            this.rendered = false;
            this.painted = false;
        }
    }

    protected void render(Graphics g) {
        if (this.hasBackgroundImages) {
            if (this.imageChanged) {
                this.backgroundImage = ImageFactory.getCompatibleImage(this.backgroundImageFiles[this.currentBackgroundImage], this.gc, 2);
            }
            if (!this.rendered && this.backgroundImage != null) {
                this.setRendered(true);
                Graphics2D g2D = (Graphics2D)g;
                g2D.drawImage(this.backgroundImage, 0, 0, 1024, 768, null);
            }
        }
    }

    public abstract void process();

    public void start() {
        this.respondOnEvent = true;
        this.game.requestFocusInWindow();
    }

    public void load() {
        this.loadingStart();
        if (this.hasAnimations) {
            this.animationList = new ArrayList();
        }
    }

    public void loadingStart() {
        this.loading = true;
        this.rendered = false;
        this.imageChanged = false;
        this.painted = false;
        this.repaint();
    }

    public void loadingEnd() {
        this.loading = false;
        this.rendered = false;
        if (this.hasBackgroundImages) {
            this.imageChanged = true;
        }
        this.repaint();
        this.readyToProcess = true;
    }

    public void unload() {
        this.readyToProcess = false;
        if (this.hasAnimations) {
            this.animationList = null;
        }
        System.gc();
    }

    public void setRendered(boolean state) {
        this.rendered = state;
        if (!state) {
            this.setPainted(false);
        }
    }

    public void setPainted(boolean state) {
        this.painted = false;
    }

    protected void displayLoadingMsg(Graphics2D g2D) {
        g2D.setFont(new Font("Arial Black", 0, 32));
        g2D.setColor(Color.MAGENTA);
        Utilities.drawFromPoint("Chargement en cours... patiente-toi!", 400, 300, 0, 0, g2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reRender() {
        Object object = this.lockObject;
        synchronized (object) {
            block4: {
                if (this.rendered) break block4;
                this.render(this.bbGraphics);
                return true;
            }
            return false;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (this.game.currentScreen != this.game.gameOverScreen && this.game.currentScreen != this.game.rewardScreen) {
                this.respondOnEvent = false;
                if (this.game.currentScreen != this.game.titleScreen && this.game.currentScreen != this.game.regScreen && this.game.currentScreen != this.game.copyrightScreen) {
                    this.game.dataFileHandler.saveGame();
                }
                this.game.endGame();
            }
        } else if (e.getKeyCode() == 119) {
            if (this.game.currentScreen == this.game.choiceScreen || this.game.currentScreen == this.game.choiceScreen.boardScreen) {
                if (this.game.gamePaused) {
                    this.game.unpauseGame();
                } else {
                    this.game.pauseGame();
                }
            }
        } else if (e.getKeyCode() == 121 && this.game.currentScreen != this.game.copyrightScreen && this.game.currentScreen != this.game.regScreen && this.game.currentScreen != this.game.gameMenuScreen && this.game.currentScreen != this.game.gameOverScreen && this.game.currentScreen != this.game.rewardScreen && this.game.currentScreen != this.game.titleScreen) {
            this.game.callMenu(this.game.currentScreen);
        }
    }

    public void setLblTranslation(String string) {
        this.lblTranslation.delete(0, this.lblTranslation.capacity());
        this.lblTranslation.append(string);
        this.setRendered(false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

