/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.others.GifButton;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.RewardSprite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Random;

public class RewardViewScreen
extends Screen {
    public Color DEFAULT_SCREEN_COLOR = new Color(0, 255, 255);
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    public GifButton screenChangeButton;
    private RewardSprite[] rewardSprites;
    private Random randomNumber;

    public RewardViewScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.DEFAULT_SCREEN_COLOR);
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[1];
        this.backgroundImageFiles[0] = game.themeVars.rewardViewScreenBkgrd;
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.backgroundSoundtrack = "rewardChoice";
        this.randomNumber = new Random(System.currentTimeMillis());
        this.hasAnimations = true;
        String[] fileNames = new String[]{game.themeVars.screenSwitchButton, game.themeVars.screenSwitchButton};
        this.screenChangeButton = new GifButton((Screen)this, new Point(675, 675), fileNames);
    }

    @Override
    public void load() {
        super.load();
        this.loadRewards();
        this.screenChangeButton.load();
        this.loadingEnd();
    }

    public void loadRewards() {
        int numRewardSprites = this.game.currentStudent.getNumRewardsCollected(this.game.getTheme());
        this.rewardSprites = new RewardSprite[numRewardSprites];
        String[] rewardFiles = new String[2];
        int count = 0;
        byte[] rewardIDArray = this.game.currentStudent.getRewardCount(this.game.getTheme());
        int j = 0;
        while (j < 7) {
            int i = 0;
            while (i < rewardIDArray[j]) {
                if (j == 0) {
                    rewardFiles = this.game.themeVars.reward1;
                } else if (j == 1) {
                    rewardFiles = this.game.themeVars.reward2;
                } else if (j == 2) {
                    rewardFiles = this.game.themeVars.reward3;
                } else if (j == 3) {
                    rewardFiles = this.game.themeVars.reward4;
                } else if (j == 4) {
                    rewardFiles = this.game.themeVars.reward5;
                } else if (j == 5) {
                    rewardFiles = this.game.themeVars.reward6;
                } else if (j == 6) {
                    rewardFiles = this.game.themeVars.reward7;
                }
                Point rewardLocation = new Point(this.randomNumber.nextInt(1024), this.randomNumber.nextInt(477) + 73);
                this.rewardSprites[count] = new RewardSprite(this.game, this, rewardLocation, rewardFiles, j, 0, 1024, 73, 550);
                this.rewardSprites[count].load();
                this.animationList.add(this.rewardSprites[count]);
                this.rewardSprites[count].setActive(true);
                this.rewardSprites[count].setVisible(true);
                ++count;
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void start() {
        this.game.delay(1000, "game.soundManager.play(\"hereAreRewards\")");
        this.game.soundManager.play(this.backgroundSoundtrack, true);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.readyToProcess) {
            AnimatedObject animation = null;
            List list = this.animationList;
            synchronized (list) {
                int i = 0;
                while (i < this.animationList.size()) {
                    animation = (AnimatedObject)this.animationList.get(i);
                    if (animation.isActive()) {
                        animation.animate(this);
                    }
                    ++i;
                }
            }
            this.setRendered(false);
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                this.screenChangeButton.paint(g2D);
                int i = 0;
                while (i < this.rewardSprites.length) {
                    this.rewardSprites[i].paint(g2D);
                    ++i;
                }
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.backgroundImageFiles[0] = this.game.themeVars.rewardViewScreenBkgrd;
        String[] fileNames = new String[]{this.game.themeVars.screenSwitchButton, this.game.themeVars.screenSwitchButton};
        this.screenChangeButton = new GifButton((Screen)this, new Point(675, 675), fileNames);
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.screenChangeButton.unload();
        this.rewardSprites = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            if (this.screenChangeButton.isPointInBounds(this.mousePoint)) {
                this.respondOnEvent = false;
                this.screenChangeButton.selected();
                this.game.choiceScreen.resetGame();
                this.game.delay(1000, "game.changeCurrentScreen(game.themeChoiceScreen)");
            }
        }
    }
}

