/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.others.GifButton;
import graphics.screens.Screen;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Hashtable;
import util.Utilities;

public class GameOverScreen
extends Screen {
    private final Color SCREEN_COLOR = new Color(0, 0, 0);
    public boolean responseMade = false;
    private Point mousePoint = new Point();
    public boolean responseHandled = false;
    public byte lastWinner = (byte)9;
    private StringBuffer lblInfoPrompt;
    private Color lblInfoPromptColor;
    private final Color TEXT_COLOR = new Color(0, 0, 0);
    Font promptFont = new Font("Arial Black", 0, 32);
    private LineBreakMeasurer lineMeasurer;
    private static final Hashtable map = new Hashtable();
    private AttributedString text1;
    private AttributedString text2;
    private AttributedString text3;
    public GifButton screenSwitchButton;

    static {
        map.put(TextAttribute.FONT, new Font("Arial Black", 0, 26));
    }

    public GameOverScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.setBackground(this.SCREEN_COLOR);
        this.hasBackgroundImages = true;
        this.backgroundImageFiles = new String[1];
        this.backgroundImageFiles[0] = game.themeVars.gameOverScreenBkgrd;
        this.hasSounds = true;
        this.screenSoundKeys = new String[1];
        this.screenSoundKeys[0] = "iconClick";
        this.backgroundSoundtrack = "wavesSeaside";
        this.lblInfoPrompt = new StringBuffer(100);
        this.lblInfoPromptColor = new Color(0, 0, 0);
        this.setInfoPrompt("Fine del gioco...");
        String[] fileNames = new String[]{game.themeVars.screenSwitchButton, game.themeVars.screenSwitchButton};
        this.screenSwitchButton = new GifButton((Screen)this, new Point(314, 674), fileNames);
        this.screenSwitchButton.setVisible(true);
    }

    @Override
    public void load() {
        super.load();
        this.screenSwitchButton.load();
        this.text1 = this.lastWinner == 0 ? new AttributedString("Complimenti, hai vinto!", map) : (this.lastWinner == 1 ? new AttributedString("Che sfortuna, questa volta hai perso.", map) : new AttributedString("Che sfortuna, questa volta hai perso.", map));
        this.text2 = this.game.choiceScreen.ncm.getNumGamesWon() == 1 ? new AttributedString("Hai vinto " + this.game.choiceScreen.ncm.getNumGamesWon() + " partita su " + this.game.choiceScreen.ncm.getNumGamesPlayed(), map) : new AttributedString("Hai vinto " + this.game.choiceScreen.ncm.getNumGamesWon() + " partite su " + this.game.choiceScreen.ncm.getNumGamesPlayed(), map);
        this.text3 = this.lastWinner == 0 ? new AttributedString("Poi salvare un prigioniero.... selezionalo per liberarlo.", map) : new AttributedString("Premi sotto per giocare di nuovo.... ", map);
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.delay(1000, "game.soundManager.play(\"gameOver\")");
        if (this.lastWinner == 0) {
            this.game.delay(2500, "game.soundManager.play(\"wellDone\")");
        } else {
            this.game.delay(2500, "game.soundManager.play(\"badLuck\")");
        }
        if (this.game.choiceScreen.ncm.getNumGamesWon() <= 10 && this.game.choiceScreen.ncm.getNumGamesPlayed() <= 10) {
            this.game.delay(4700, "game.soundManager.play(\"youHaveWon\")");
            this.game.delay(5450, "game.soundManager.play(\"friend1_" + Utilities.getVerbalForArabic(this.game.choiceScreen.ncm.getNumGamesWon()) + "\")");
            this.game.delay(6250, "game.soundManager.play(\"gamesOutOf\")");
            this.game.delay(7450, "game.soundManager.play(\"friend1_" + Utilities.getVerbalForArabic(this.game.choiceScreen.ncm.getNumGamesPlayed()) + "\")");
            if (this.lastWinner == 0) {
                this.game.delay(8600, "game.soundManager.play(\"youGetReward\")");
            }
        } else if (this.lastWinner == 0) {
            this.game.delay(4700, "game.soundManager.play(\"youGetReward\")");
        }
        super.start();
    }

    @Override
    public void process() {
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            Graphics2D g2D = (Graphics2D)g;
            super.render(g);
            if (!this.loading) {
                g2D.setFont(this.promptFont);
                g2D.setColor(this.lblInfoPromptColor);
                Utilities.drawFromPoint(this.lblInfoPrompt.toString(), 512, 153, 0, 0, g);
                g2D.setColor(this.TEXT_COLOR);
                int yPos = Utilities.writeParagraph(g2D, 682, this.text1, 170, 256);
                yPos = Utilities.writeParagraph(g2D, 682, this.text2, 170, yPos);
                yPos = Utilities.writeParagraph(g2D, 682, this.text3, 170, yPos);
                this.screenSwitchButton.paint(g2D);
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        this.backgroundImageFiles[0] = this.game.themeVars.gameOverScreenBkgrd;
        String[] fileNames = new String[]{this.game.themeVars.screenSwitchButton, this.game.themeVars.screenSwitchButton};
        this.screenSwitchButton = new GifButton((Screen)this, new Point(314, 674), fileNames);
        this.screenSwitchButton.setVisible(true);
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.screenSwitchButton.unload();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.respondOnEvent) {
            int responseButton = e.getButton();
            this.mousePoint.setLocation(e.getX(), e.getY());
            if (this.screenSwitchButton.isPointInBounds(this.mousePoint)) {
                this.respondOnEvent = false;
                this.game.soundManager.stopAllSounds();
                this.game.removeTasksFromList("soundManager");
                this.screenSwitchButton.selected();
                if (this.lastWinner == 0) {
                    this.game.delay(1000, "game.changeCurrentScreen(game.rewardScreen)");
                } else if (this.lastWinner == 1) {
                    this.game.choiceScreen.resetGame();
                    this.game.delay(1000, "game.changeCurrentScreen(game.themeChoiceScreen)");
                }
            }
        }
    }

    public void setInfoPrompt(String prompt) {
        this.lblInfoPrompt.delete(0, this.lblInfoPrompt.capacity());
        this.lblInfoPrompt.append(prompt);
        this.rendered = false;
        this.repaint();
    }

    public void setPromptColor(Color col) {
        this.lblInfoPromptColor = col;
        this.rendered = false;
        this.repaint();
    }
}

