/*
 * Decompiled with CFR 0.152.
 */
package graphics.screens;

import graphics.Game;
import graphics.managers.DotManager;
import graphics.managers.NumCompManager;
import graphics.others.DotCarpet;
import graphics.others.DotContainer;
import graphics.others.GifButton;
import graphics.screens.BoardScreen;
import graphics.screens.Screen;
import graphics.sprites.AnimatedObject;
import graphics.sprites.PlayerIcon;
import graphics.vars.GraphicsVariables;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import util.ImageFactory;

public class ChoiceScreen
extends Screen {
    public BoardScreen boardScreen;
    public DotContainer[] dotContainers;
    public DotManager[] dotManagers;
    public DotCarpet dotCarpet;
    public PlayerIcon[] playerIcons;
    public NumCompManager ncm;
    public GifButton boardButton;
    public GifButton menuButton;
    private StringBuffer lblDebugAlg;
    public byte responseMode = 0;
    private Point mousePoint = new Point();

    public ChoiceScreen(Rectangle bounds, Game game, Image backBuffer) {
        super(bounds, game, backBuffer);
        this.hasAnimations = true;
        this.setBackground(game.themeVars.screenColor);
        String[] fileNames = new String[]{game.themeVars.boardButton, game.themeVars.boardButton};
        this.boardButton = new GifButton((Screen)this, new Point(960, 64), fileNames);
        String[] fileNames2 = new String[]{game.themeVars.helpButton, game.themeVars.helpButton};
        String[] fileNames3 = new String[]{game.themeVars.menuButton, game.themeVars.menuButton};
        this.menuButton = new GifButton((Screen)this, new Point(64, 64), fileNames3);
        this.lblDebugAlg = new StringBuffer(100);
        this.hasSounds = true;
        this.boardScreen = new BoardScreen(bounds, game, this, backBuffer);
        this.ncm = new NumCompManager(game, this, this.boardScreen);
        this.dotContainers = new DotContainer[2];
        this.dotManagers = new DotManager[2];
        this.dotCarpet = new DotCarpet(game, this, this.boardScreen);
        this.playerIcons = new PlayerIcon[2];
        this.dotContainers[0] = new DotContainer(game, this, 0, 32, 288, game.themeVars.leftDotContainerGifs, 448, 448, 0, 256, 192, 96, 64, 320, 256, 48, 48);
        this.dotContainers[1] = new DotContainer(game, this, 1, 544, 288, game.themeVars.rightDotContainerGifs, 448, 448, 256, 256, 192, 32, 64, 320, 256, 400, 48);
        this.dotManagers[0] = new DotManager(game, this, this.boardScreen, this.boardScreen.players[0]);
        this.dotManagers[1] = new DotManager(game, this, this.boardScreen, this.boardScreen.players[1]);
        this.playerIcons[0] = new PlayerIcon(this, this.boardScreen, GraphicsVariables.PLAYER1_ICON_START_POINT, 0, 0);
        this.playerIcons[1] = new PlayerIcon(this, this.boardScreen, GraphicsVariables.PLAYER2_ICON_START_POINT, 1, 0);
        this.setPlayer2Character();
    }

    @Override
    public void load() {
        super.load();
        this.boardScreen.load();
        this.ncm.load();
        this.dotContainers[0].load();
        this.dotContainers[1].load();
        this.dotManagers[0].load();
        this.dotManagers[1].load();
        this.playerIcons[0].load();
        this.playerIcons[1].load();
        this.dotCarpet.load();
        this.boardButton.load();
        this.menuButton.load();
        this.animationList.add(this.ncm);
        this.animationList.add(this.dotCarpet);
        this.animationList.add(this.dotContainers[0]);
        this.animationList.add(this.dotContainers[1]);
        this.animationList.add(this.dotManagers[0]);
        this.animationList.add(this.dotManagers[1]);
        this.animationList.add(this.playerIcons[0]);
        this.animationList.add(this.playerIcons[1]);
        this.loadingEnd();
    }

    @Override
    public void start() {
        this.game.soundManager.stopAllSounds();
        if (this.backgroundSoundtrack != null) {
            this.game.soundManager.play(this.backgroundSoundtrack, true);
        }
        this.ncm.start();
        this.playerIcons[0].start();
        this.playerIcons[1].start();
        super.start();
    }

    public void resetTurn() {
        this.responseMode = 0;
        this.boardScreen.resetTurn();
        this.dotCarpet.reset();
        this.playerIcons[0].reset();
        this.playerIcons[1].reset();
        this.dotContainers[0].reset();
        this.dotContainers[1].reset();
        this.dotManagers[0].reset();
        this.dotManagers[1].reset();
    }

    public void resetGame() {
        this.dotCarpet.reset();
        this.dotContainers[0].reset();
        this.dotContainers[1].reset();
        this.dotManagers[0].reset();
        this.dotManagers[1].reset();
        this.playerIcons[0].reset();
        this.playerIcons[1].reset();
        this.boardScreen.resetGame();
        this.setLblDebugAlg("");
        this.setPlayer2Character();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (this.readyToProcess && this.boardScreen.readyToProcess) {
            AnimatedObject animation = null;
            List list = this.animationList;
            synchronized (list) {
                int i = 0;
                while (i < this.animationList.size()) {
                    animation = (AnimatedObject)this.animationList.get(i);
                    if (animation.isActive()) {
                        animation.animate(this);
                    }
                    if (animation.isImageActive()) {
                        animation.animateImage(this);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    protected void render(Graphics g) {
        if (!this.rendered) {
            this.setRendered(true);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setColor(this.game.themeVars.screenColor);
            g2D.fill(this.getBounds());
            if (!this.loading) {
                BufferedImage cheatKey = ImageFactory.getCompatibleImage(this.game.themeVars.cheatKey, this.gc, 2);
                g2D.drawImage(cheatKey, GraphicsVariables.TOP_CENTER_SCREEN.x - cheatKey.getWidth() / 2, GraphicsVariables.TOP_CENTER_SCREEN.y - (cheatKey.getHeight() >> 1), cheatKey.getWidth(), cheatKey.getHeight(), null);
                AnimatedObject animatedObject = null;
                int i = 0;
                while (i < this.animationList.size()) {
                    animatedObject = (AnimatedObject)this.animationList.get(i);
                    animatedObject.paint(g2D);
                    ++i;
                }
                this.boardButton.paint(g2D);
                this.menuButton.paint(g2D);
                this.setPainted(false);
            } else {
                this.displayLoadingMsg(g2D);
            }
        }
    }

    public void themeChanged() {
        String[] fileNames = new String[]{this.game.themeVars.boardButton, this.game.themeVars.boardButton};
        this.boardButton = new GifButton((Screen)this, new Point(960, 64), fileNames);
        String[] fileNames2 = new String[]{this.game.themeVars.helpButton, this.game.themeVars.helpButton};
        String[] fileNames3 = new String[]{this.game.themeVars.menuButton, this.game.themeVars.menuButton};
        this.menuButton = new GifButton((Screen)this, new Point(64, 64), fileNames3);
        this.boardButton.load();
        this.menuButton.load();
        this.dotContainers[0].themeChanged();
        this.dotContainers[1].themeChanged();
        this.playerIcons[0].themeChanged();
        this.playerIcons[1].themeChanged();
        this.dotCarpet.themeChanged();
        this.setBackground(this.game.themeVars.screenColor);
        this.boardScreen.themeChanged();
        this.setRendered(false);
    }

    @Override
    public void unload() {
        super.unload();
        this.ncm.unload();
        this.dotContainers[0].unload();
        this.dotContainers[1].unload();
        this.dotManagers[0].unload();
        this.dotManagers[1].unload();
        this.playerIcons[0].unload();
        this.playerIcons[1].unload();
        this.dotCarpet.unload();
        this.boardButton = null;
        this.menuButton = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePoint.setLocation(e.getX(), e.getY());
        if (this.boardButton.isPointInBounds(this.mousePoint)) {
            this.boardButton.selected();
        } else if (this.menuButton.isPointInBounds(this.mousePoint)) {
            this.menuButton.selected();
            this.game.callMenu(this);
        } else {
            this.ncm.responseHandler(e);
        }
    }

    public void setLblDebugAlg(String string) {
        this.lblDebugAlg.delete(0, this.lblDebugAlg.capacity());
        this.lblDebugAlg.append(string);
        this.rendered = false;
    }

    public void setPlayer2Character() {
        Random randomNumber = new Random();
        randomNumber.setSeed(System.currentTimeMillis());
        int selectedCharac = randomNumber.nextInt(4);
        this.playerIcons[1].setCharacter(selectedCharac);
        this.boardScreen.players[1].setCharacter(selectedCharac);
    }
}

